/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.gossip;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.MinecraftSerializableUUID;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.gossip.ReputationType;

public class Reputation {
    public static final int DISCARD_THRESHOLD = 2;
    private final Map<UUID, a> gossips = Maps.newHashMap();

    @VisibleForDebug
    public Map<UUID, Object2IntMap<ReputationType>> getGossipEntries() {
        HashMap var0 = Maps.newHashMap();
        this.gossips.keySet().forEach(var1 -> {
            a var2 = this.gossips.get(var1);
            var0.put(var1, var2.entries);
        });
        return var0;
    }

    public void decay() {
        Iterator<a> var0 = this.gossips.values().iterator();
        while (var0.hasNext()) {
            a var1 = var0.next();
            var1.decay();
            if (!var1.isEmpty()) continue;
            var0.remove();
        }
    }

    private Stream<b> unpack() {
        return this.gossips.entrySet().stream().flatMap(var0 -> ((a)var0.getValue()).unpack((UUID)var0.getKey()));
    }

    private Collection<b> selectGossipsForTransfer(Random var0, int var1) {
        List var2 = this.unpack().collect(Collectors.toList());
        if (var2.isEmpty()) {
            return Collections.emptyList();
        }
        int[] var3 = new int[var2.size()];
        int var4 = 0;
        for (int var5 = 0; var5 < var2.size(); ++var5) {
            b var6 = (b)var2.get(var5);
            var3[var5] = (var4 += Math.abs(var6.weightedValue())) - 1;
        }
        Set var5 = Sets.newIdentityHashSet();
        for (int var6 = 0; var6 < var1; ++var6) {
            int var7 = var0.nextInt(var4);
            int var8 = Arrays.binarySearch(var3, var7);
            var5.add((b)var2.get(var8 < 0 ? -var8 - 1 : var8));
        }
        return var5;
    }

    private a getOrCreate(UUID var02) {
        return this.gossips.computeIfAbsent(var02, var0 -> new a());
    }

    public void transferFrom(Reputation var02, Random var1, int var2) {
        Collection<b> var3 = var02.selectGossipsForTransfer(var1, var2);
        var3.forEach(var0 -> {
            int var1 = var0.value - var0.type.decayPerTransfer;
            if (var1 >= 2) {
                this.getOrCreate((UUID)var0.target).entries.mergeInt((Object)var0.type, var1, Reputation::mergeValuesForTransfer);
            }
        });
    }

    public int getReputation(UUID var0, Predicate<ReputationType> var1) {
        a var2 = this.gossips.get(var0);
        return var2 != null ? var2.weightedValue(var1) : 0;
    }

    public long getCountForType(ReputationType var0, DoublePredicate var1) {
        return this.gossips.values().stream().filter(var2 -> var1.test(var2.entries.getOrDefault((Object)var0, 0) * var1.weight)).count();
    }

    public void add(UUID var0, ReputationType var12, int var22) {
        a var3 = this.getOrCreate(var0);
        var3.entries.mergeInt((Object)var12, var22, (var1, var2) -> this.mergeValuesForAddition(var12, var1, var2));
        var3.makeSureValueIsntTooLowOrTooHigh(var12);
        if (var3.isEmpty()) {
            this.gossips.remove(var0);
        }
    }

    public void remove(UUID var0, ReputationType var1, int var2) {
        this.add(var0, var1, -var2);
    }

    public void remove(UUID var0, ReputationType var1) {
        a var2 = this.gossips.get(var0);
        if (var2 != null) {
            var2.remove(var1);
            if (var2.isEmpty()) {
                this.gossips.remove(var0);
            }
        }
    }

    public void remove(ReputationType var0) {
        Iterator<a> var1 = this.gossips.values().iterator();
        while (var1.hasNext()) {
            a var2 = var1.next();
            var2.remove(var0);
            if (!var2.isEmpty()) continue;
            var1.remove();
        }
    }

    public <T> Dynamic<T> store(DynamicOps<T> var0) {
        return new Dynamic(var0, var0.createList(this.unpack().map(var1 -> var1.store(var0)).map(Dynamic::getValue)));
    }

    public void update(Dynamic<?> var02) {
        var02.asStream().map(b::load).flatMap(var0 -> var0.result().stream()).forEach(var0 -> this.getOrCreate((UUID)var0.target).entries.put((Object)var0.type, var0.value));
    }

    private static int mergeValuesForTransfer(int var0, int var1) {
        return Math.max(var0, var1);
    }

    private int mergeValuesForAddition(ReputationType var0, int var1, int var2) {
        int var3 = var1 + var2;
        return var3 > var0.max ? Math.max(var0.max, var1) : var3;
    }

    static class a {
        final Object2IntMap<ReputationType> entries = new Object2IntOpenHashMap();

        a() {
        }

        public int weightedValue(Predicate<ReputationType> var02) {
            return this.entries.object2IntEntrySet().stream().filter(var1 -> var02.test((ReputationType)((Object)((Object)var1.getKey())))).mapToInt(var0 -> var0.getIntValue() * ((ReputationType)((Object)((Object)var0.getKey()))).weight).sum();
        }

        public Stream<b> unpack(UUID var0) {
            return this.entries.object2IntEntrySet().stream().map(var1 -> new b(var0, (ReputationType)((Object)((Object)var1.getKey())), var1.getIntValue()));
        }

        public void decay() {
            ObjectIterator var0 = this.entries.object2IntEntrySet().iterator();
            while (var0.hasNext()) {
                Object2IntMap.Entry var1 = (Object2IntMap.Entry)var0.next();
                int var2 = var1.getIntValue() - ((ReputationType)((Object)var1.getKey())).decayPerDay;
                if (var2 < 2) {
                    var0.remove();
                    continue;
                }
                var1.setValue(var2);
            }
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public void makeSureValueIsntTooLowOrTooHigh(ReputationType var0) {
            int var1 = this.entries.getInt((Object)var0);
            if (var1 > var0.max) {
                this.entries.put((Object)var0, var0.max);
            }
            if (var1 < 2) {
                this.remove(var0);
            }
        }

        public void remove(ReputationType var0) {
            this.entries.removeInt((Object)var0);
        }
    }

    static class b {
        public static final String TAG_TARGET = "Target";
        public static final String TAG_TYPE = "Type";
        public static final String TAG_VALUE = "Value";
        public final UUID target;
        public final ReputationType type;
        public final int value;

        public b(UUID var0, ReputationType var1, int var2) {
            this.target = var0;
            this.type = var1;
            this.value = var2;
        }

        public int weightedValue() {
            return this.value * this.type.weight;
        }

        public String toString() {
            return "GossipEntry{target=" + this.target + ", type=" + this.type + ", value=" + this.value + "}";
        }

        public <T> Dynamic<T> store(DynamicOps<T> var0) {
            return new Dynamic(var0, var0.createMap((Map)ImmutableMap.of((Object)var0.createString(TAG_TARGET), MinecraftSerializableUUID.CODEC.encodeStart(var0, (Object)this.target).result().orElseThrow(RuntimeException::new), (Object)var0.createString(TAG_TYPE), (Object)var0.createString(this.type.id), (Object)var0.createString(TAG_VALUE), (Object)var0.createInt(this.value))));
        }

        public static DataResult<b> load(Dynamic<?> var0) {
            return DataResult.unbox((App)DataResult.instance().group((App)var0.get(TAG_TARGET).read(MinecraftSerializableUUID.CODEC), (App)var0.get(TAG_TYPE).asString().map(ReputationType::byId), (App)var0.get(TAG_VALUE).asNumber().map(Number::intValue)).apply((Applicative)DataResult.instance(), b::new));
        }
    }
}

