/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorBedJump;
import net.minecraft.world.entity.ai.behavior.BehaviorBell;
import net.minecraft.world.entity.ai.behavior.BehaviorBellAlert;
import net.minecraft.world.entity.ai.behavior.BehaviorBellRing;
import net.minecraft.world.entity.ai.behavior.BehaviorBetterJob;
import net.minecraft.world.entity.ai.behavior.BehaviorBonemeal;
import net.minecraft.world.entity.ai.behavior.BehaviorCareer;
import net.minecraft.world.entity.ai.behavior.BehaviorCelebrate;
import net.minecraft.world.entity.ai.behavior.BehaviorCooldown;
import net.minecraft.world.entity.ai.behavior.BehaviorFarm;
import net.minecraft.world.entity.ai.behavior.BehaviorFindAdmirableItem;
import net.minecraft.world.entity.ai.behavior.BehaviorFindPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorGate;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorHide;
import net.minecraft.world.entity.ai.behavior.BehaviorHome;
import net.minecraft.world.entity.ai.behavior.BehaviorHomeRaid;
import net.minecraft.world.entity.ai.behavior.BehaviorInteract;
import net.minecraft.world.entity.ai.behavior.BehaviorInteractDoor;
import net.minecraft.world.entity.ai.behavior.BehaviorInteractPlayer;
import net.minecraft.world.entity.ai.behavior.BehaviorLeaveJob;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookInteract;
import net.minecraft.world.entity.ai.behavior.BehaviorLookTarget;
import net.minecraft.world.entity.ai.behavior.BehaviorLookWalk;
import net.minecraft.world.entity.ai.behavior.BehaviorMakeLove;
import net.minecraft.world.entity.ai.behavior.BehaviorNearestVillage;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorOutsideCelebrate;
import net.minecraft.world.entity.ai.behavior.BehaviorPanic;
import net.minecraft.world.entity.ai.behavior.BehaviorPlay;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionValidate;
import net.minecraft.world.entity.ai.behavior.BehaviorPotentialJobSite;
import net.minecraft.world.entity.ai.behavior.BehaviorProfession;
import net.minecraft.world.entity.ai.behavior.BehaviorRaid;
import net.minecraft.world.entity.ai.behavior.BehaviorRaidReset;
import net.minecraft.world.entity.ai.behavior.BehaviorSchedule;
import net.minecraft.world.entity.ai.behavior.BehaviorSleep;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollInside;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollPlace;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollPlaceList;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandom;
import net.minecraft.world.entity.ai.behavior.BehaviorSwim;
import net.minecraft.world.entity.ai.behavior.BehaviorTradePlayer;
import net.minecraft.world.entity.ai.behavior.BehaviorTradeVillager;
import net.minecraft.world.entity.ai.behavior.BehaviorVictory;
import net.minecraft.world.entity.ai.behavior.BehaviorVillageHeroGift;
import net.minecraft.world.entity.ai.behavior.BehaviorWake;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAway;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAwayBlock;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkHome;
import net.minecraft.world.entity.ai.behavior.BehaviorWork;
import net.minecraft.world.entity.ai.behavior.BehaviorWorkComposter;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;

public class Behaviors {
    private static final float STROLL_SPEED_MODIFIER = 0.4f;

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super EntityVillager>>> getCorePackage(VillagerProfession var0, float var1) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new BehaviorSwim(0.8f)), (Object)Pair.of((Object)0, (Object)new BehaviorInteractDoor()), (Object)Pair.of((Object)0, (Object)new BehaviorLook(45, 90)), (Object)Pair.of((Object)0, (Object)new BehaviorPanic()), (Object)Pair.of((Object)0, (Object)new BehaviorWake()), (Object)Pair.of((Object)0, (Object)new BehaviorBellAlert()), (Object)Pair.of((Object)0, (Object)new BehaviorRaid()), (Object)Pair.of((Object)0, (Object)new BehaviorPositionValidate(var0.getJobPoiType(), MemoryModuleType.JOB_SITE)), (Object)Pair.of((Object)0, (Object)new BehaviorPositionValidate(var0.getJobPoiType(), MemoryModuleType.POTENTIAL_JOB_SITE)), (Object)Pair.of((Object)1, (Object)new BehavorMove()), (Object)Pair.of((Object)2, (Object)new BehaviorBetterJob(var0)), (Object)Pair.of((Object)3, (Object)new BehaviorInteractPlayer(var1)), (Object[])new Pair[]{Pair.of((Object)5, new BehaviorFindAdmirableItem(var1, false, 4)), Pair.of((Object)6, (Object)new BehaviorFindPosition(var0.getJobPoiType(), MemoryModuleType.JOB_SITE, MemoryModuleType.POTENTIAL_JOB_SITE, true, Optional.empty())), Pair.of((Object)7, (Object)new BehaviorPotentialJobSite(var1)), Pair.of((Object)8, (Object)new BehaviorLeaveJob(var1)), Pair.of((Object)10, (Object)new BehaviorFindPosition(VillagePlaceType.HOME, MemoryModuleType.HOME, false, Optional.of((byte)14))), Pair.of((Object)10, (Object)new BehaviorFindPosition(VillagePlaceType.MEETING, MemoryModuleType.MEETING_POINT, true, Optional.of((byte)14))), Pair.of((Object)10, (Object)new BehaviorCareer()), Pair.of((Object)10, (Object)new BehaviorProfession())});
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super EntityVillager>>> getWorkPackage(VillagerProfession var0, float var1) {
        BehaviorWork var2 = var0 == VillagerProfession.FARMER ? new BehaviorWorkComposter() : new BehaviorWork();
        return ImmutableList.of(Behaviors.getMinimalLookBehavior(), (Object)Pair.of((Object)5, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of((Object)var2, (Object)7), (Object)Pair.of((Object)new BehaviorStrollPosition(MemoryModuleType.JOB_SITE, 0.4f, 4), (Object)2), (Object)Pair.of((Object)new BehaviorStrollPlace(MemoryModuleType.JOB_SITE, 0.4f, 1, 10), (Object)5), (Object)Pair.of((Object)new BehaviorStrollPlaceList(MemoryModuleType.SECONDARY_JOB_SITE, var1, 1, 6, MemoryModuleType.JOB_SITE), (Object)5), (Object)Pair.of((Object)new BehaviorFarm(), (Object)(var0 == VillagerProfession.FARMER ? 2 : 5)), (Object)Pair.of((Object)new BehaviorBonemeal(), (Object)(var0 == VillagerProfession.FARMER ? 4 : 7))))), (Object)Pair.of((Object)10, (Object)new BehaviorTradePlayer(400, 1600)), (Object)Pair.of((Object)10, (Object)new BehaviorLookInteract(EntityTypes.PLAYER, 4)), (Object)Pair.of((Object)2, (Object)new BehaviorWalkAwayBlock(MemoryModuleType.JOB_SITE, var1, 9, 100, 1200)), (Object)Pair.of((Object)3, (Object)new BehaviorVillageHeroGift(100)), (Object)Pair.of((Object)99, (Object)new BehaviorSchedule()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super EntityVillager>>> getPlayPackage(float var0) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new BehavorMove(80, 120)), Behaviors.getFullLookBehavior(), (Object)Pair.of((Object)5, (Object)new BehaviorPlay()), (Object)Pair.of((Object)5, new BehaviorGateSingle((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.VISIBLE_VILLAGER_BABIES, (Object)((Object)MemoryStatus.VALUE_ABSENT)), ImmutableList.of((Object)Pair.of(BehaviorInteract.of(EntityTypes.VILLAGER, 8, MemoryModuleType.INTERACTION_TARGET, var0, 2), (Object)2), (Object)Pair.of(BehaviorInteract.of(EntityTypes.CAT, 8, MemoryModuleType.INTERACTION_TARGET, var0, 2), (Object)1), (Object)Pair.of((Object)new BehaviorStrollRandom(var0), (Object)1), (Object)Pair.of((Object)new BehaviorLookWalk(var0, 2), (Object)1), (Object)Pair.of((Object)new BehaviorBedJump(var0), (Object)2), (Object)Pair.of((Object)new BehaviorNop(20, 40), (Object)2)))), (Object)Pair.of((Object)99, (Object)new BehaviorSchedule()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super EntityVillager>>> getRestPackage(VillagerProfession var0, float var1) {
        return ImmutableList.of((Object)Pair.of((Object)2, (Object)new BehaviorWalkAwayBlock(MemoryModuleType.HOME, var1, 1, 150, 1200)), (Object)Pair.of((Object)3, (Object)new BehaviorPositionValidate(VillagePlaceType.HOME, MemoryModuleType.HOME)), (Object)Pair.of((Object)3, (Object)new BehaviorSleep()), (Object)Pair.of((Object)5, new BehaviorGateSingle((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.HOME, (Object)((Object)MemoryStatus.VALUE_ABSENT)), ImmutableList.of((Object)Pair.of((Object)new BehaviorWalkHome(var1), (Object)1), (Object)Pair.of((Object)new BehaviorStrollInside(var1), (Object)4), (Object)Pair.of((Object)new BehaviorNearestVillage(var1, 4), (Object)2), (Object)Pair.of((Object)new BehaviorNop(20, 40), (Object)2)))), Behaviors.getMinimalLookBehavior(), (Object)Pair.of((Object)99, (Object)new BehaviorSchedule()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super EntityVillager>>> getMeetPackage(VillagerProfession var0, float var1) {
        return ImmutableList.of((Object)Pair.of((Object)2, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of((Object)new BehaviorStrollPosition(MemoryModuleType.MEETING_POINT, 0.4f, 40), (Object)2), (Object)Pair.of((Object)new BehaviorBell(), (Object)2)))), (Object)Pair.of((Object)10, (Object)new BehaviorTradePlayer(400, 1600)), (Object)Pair.of((Object)10, (Object)new BehaviorLookInteract(EntityTypes.PLAYER, 4)), (Object)Pair.of((Object)2, (Object)new BehaviorWalkAwayBlock(MemoryModuleType.MEETING_POINT, var1, 6, 100, 200)), (Object)Pair.of((Object)3, (Object)new BehaviorVillageHeroGift(100)), (Object)Pair.of((Object)3, (Object)new BehaviorPositionValidate(VillagePlaceType.MEETING, MemoryModuleType.MEETING_POINT)), (Object)Pair.of((Object)3, new BehaviorGate((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(), (Set<MemoryModuleType<?>>)ImmutableSet.of(MemoryModuleType.INTERACTION_TARGET), BehaviorGate.Order.ORDERED, BehaviorGate.Execution.RUN_ONE, ImmutableList.of((Object)Pair.of((Object)new BehaviorTradeVillager(), (Object)1)))), Behaviors.getFullLookBehavior(), (Object)Pair.of((Object)99, (Object)new BehaviorSchedule()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super EntityVillager>>> getIdlePackage(VillagerProfession var0, float var1) {
        return ImmutableList.of((Object)Pair.of((Object)2, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of(BehaviorInteract.of(EntityTypes.VILLAGER, 8, MemoryModuleType.INTERACTION_TARGET, var1, 2), (Object)2), (Object)Pair.of(new BehaviorInteract<EntityVillager, EntityAgeable>(EntityTypes.VILLAGER, 8, EntityAgeable::canBreed, EntityAgeable::canBreed, MemoryModuleType.BREED_TARGET, var1, 2), (Object)1), (Object)Pair.of(BehaviorInteract.of(EntityTypes.CAT, 8, MemoryModuleType.INTERACTION_TARGET, var1, 2), (Object)1), (Object)Pair.of((Object)new BehaviorStrollRandom(var1), (Object)1), (Object)Pair.of((Object)new BehaviorLookWalk(var1, 2), (Object)1), (Object)Pair.of((Object)new BehaviorBedJump(var1), (Object)1), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1)))), (Object)Pair.of((Object)3, (Object)new BehaviorVillageHeroGift(100)), (Object)Pair.of((Object)3, (Object)new BehaviorLookInteract(EntityTypes.PLAYER, 4)), (Object)Pair.of((Object)3, (Object)new BehaviorTradePlayer(400, 1600)), (Object)Pair.of((Object)3, new BehaviorGate((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(), (Set<MemoryModuleType<?>>)ImmutableSet.of(MemoryModuleType.INTERACTION_TARGET), BehaviorGate.Order.ORDERED, BehaviorGate.Execution.RUN_ONE, ImmutableList.of((Object)Pair.of((Object)new BehaviorTradeVillager(), (Object)1)))), (Object)Pair.of((Object)3, new BehaviorGate((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(), (Set<MemoryModuleType<?>>)ImmutableSet.of(MemoryModuleType.BREED_TARGET), BehaviorGate.Order.ORDERED, BehaviorGate.Execution.RUN_ONE, ImmutableList.of((Object)Pair.of((Object)new BehaviorMakeLove(), (Object)1)))), Behaviors.getFullLookBehavior(), (Object)Pair.of((Object)99, (Object)new BehaviorSchedule()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super EntityVillager>>> getPanicPackage(VillagerProfession var0, float var1) {
        float var2 = var1 * 1.5f;
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new BehaviorCooldown()), (Object)Pair.of((Object)1, BehaviorWalkAway.entity(MemoryModuleType.NEAREST_HOSTILE, var2, 6, false)), (Object)Pair.of((Object)1, BehaviorWalkAway.entity(MemoryModuleType.HURT_BY_ENTITY, var2, 6, false)), (Object)Pair.of((Object)3, (Object)new BehaviorStrollRandom(var2, 2, 2)), Behaviors.getMinimalLookBehavior());
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super EntityVillager>>> getPreRaidPackage(VillagerProfession var0, float var1) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new BehaviorBellRing()), (Object)Pair.of((Object)0, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of((Object)new BehaviorWalkAwayBlock(MemoryModuleType.MEETING_POINT, var1 * 1.5f, 2, 150, 200), (Object)6), (Object)Pair.of((Object)new BehaviorStrollRandom(var1 * 1.5f), (Object)2)))), Behaviors.getMinimalLookBehavior(), (Object)Pair.of((Object)99, (Object)new BehaviorRaidReset()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super EntityVillager>>> getRaidPackage(VillagerProfession var0, float var1) {
        return ImmutableList.of((Object)Pair.of((Object)0, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of((Object)new BehaviorOutsideCelebrate(var1), (Object)5), (Object)Pair.of((Object)new BehaviorVictory(var1 * 1.1f), (Object)2)))), (Object)Pair.of((Object)0, (Object)new BehaviorCelebrate(600, 600)), (Object)Pair.of((Object)2, (Object)new BehaviorHomeRaid(24, var1 * 1.4f)), Behaviors.getMinimalLookBehavior(), (Object)Pair.of((Object)99, (Object)new BehaviorRaidReset()));
    }

    public static ImmutableList<Pair<Integer, ? extends Behavior<? super EntityVillager>>> getHidePackage(VillagerProfession var0, float var1) {
        int var2 = 2;
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new BehaviorHide(15, 3)), (Object)Pair.of((Object)1, (Object)new BehaviorHome(32, var1 * 1.25f, 2)), Behaviors.getMinimalLookBehavior());
    }

    private static Pair<Integer, Behavior<EntityLiving>> getFullLookBehavior() {
        return Pair.of((Object)5, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of((Object)new BehaviorLookTarget(EntityTypes.CAT, 8.0f), (Object)8), (Object)Pair.of((Object)new BehaviorLookTarget(EntityTypes.VILLAGER, 8.0f), (Object)2), (Object)Pair.of((Object)new BehaviorLookTarget(EntityTypes.PLAYER, 8.0f), (Object)2), (Object)Pair.of((Object)new BehaviorLookTarget(EnumCreatureType.CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new BehaviorLookTarget(EnumCreatureType.WATER_CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new BehaviorLookTarget(EnumCreatureType.AXOLOTLS, 8.0f), (Object)1), (Object)Pair.of((Object)new BehaviorLookTarget(EnumCreatureType.UNDERGROUND_WATER_CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new BehaviorLookTarget(EnumCreatureType.WATER_AMBIENT, 8.0f), (Object)1), (Object)Pair.of((Object)new BehaviorLookTarget(EnumCreatureType.MONSTER, 8.0f), (Object)1), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)2))));
    }

    private static Pair<Integer, Behavior<EntityLiving>> getMinimalLookBehavior() {
        return Pair.of((Object)5, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of((Object)new BehaviorLookTarget(EntityTypes.VILLAGER, 8.0f), (Object)2), (Object)Pair.of((Object)new BehaviorLookTarget(EntityTypes.PLAYER, 8.0f), (Object)2), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)8))));
    }
}

