/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3D;

public class BehaviorStrollPosition
extends Behavior<EntityCreature> {
    private static final int MIN_TIME_BETWEEN_STROLLS = 180;
    private static final int STROLL_MAX_XZ_DIST = 8;
    private static final int STROLL_MAX_Y_DIST = 6;
    private final MemoryModuleType<GlobalPos> memoryType;
    private long nextOkStartTime;
    private final int maxDistanceFromPoi;
    private final float speedModifier;

    public BehaviorStrollPosition(MemoryModuleType<GlobalPos> var0, float var1, int var2) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), var0, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.memoryType = var0;
        this.speedModifier = var1;
        this.maxDistanceFromPoi = var2;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        Optional<GlobalPos> var2 = var1.getBrain().getMemory(this.memoryType);
        return var2.isPresent() && var0.dimension() == var2.get().dimension() && var2.get().pos().closerToCenterThan(var1.position(), this.maxDistanceFromPoi);
    }

    @Override
    protected void start(WorldServer var02, EntityCreature var1, long var2) {
        if (var2 > this.nextOkStartTime) {
            Optional<Vec3D> var4 = Optional.ofNullable(LandRandomPos.getPos(var1, 8, 6));
            var1.getBrain().setMemory(MemoryModuleType.WALK_TARGET, var4.map(var0 -> new MemoryTarget((Vec3D)var0, this.speedModifier, 1)));
            this.nextOkStartTime = var2 + 180L;
        }
    }
}

