/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;

public class BehaviorStrollPlace
extends Behavior<EntityCreature> {
    private final MemoryModuleType<GlobalPos> memoryType;
    private final int closeEnoughDist;
    private final int maxDistanceFromPoi;
    private final float speedModifier;
    private long nextOkStartTime;

    public BehaviorStrollPlace(MemoryModuleType<GlobalPos> var0, float var1, int var2, int var3) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), var0, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.memoryType = var0;
        this.speedModifier = var1;
        this.closeEnoughDist = var2;
        this.maxDistanceFromPoi = var3;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        Optional<GlobalPos> var2 = var1.getBrain().getMemory(this.memoryType);
        return var2.isPresent() && var0.dimension() == var2.get().dimension() && var2.get().pos().closerToCenterThan(var1.position(), this.maxDistanceFromPoi);
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var12, long var2) {
        if (var2 > this.nextOkStartTime) {
            BehaviorController<?> var4 = var12.getBrain();
            Optional<GlobalPos> var5 = var4.getMemory(this.memoryType);
            var5.ifPresent(var1 -> var4.setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var1.pos(), this.speedModifier, this.closeEnoughDist)));
            this.nextOkStartTime = var2 + 80L;
        }
    }
}

