/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BehaviorStopRiding<E extends EntityLiving, T extends Entity>
extends Behavior<E> {
    private final int maxWalkDistToRideTarget;
    private final BiPredicate<E, Entity> dontRideIf;

    public BehaviorStopRiding(int var0, BiPredicate<E, Entity> var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.RIDE_TARGET, (Object)((Object)MemoryStatus.REGISTERED)));
        this.maxWalkDistToRideTarget = var0;
        this.dontRideIf = var1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        Entity var2 = ((Entity)var1).getVehicle();
        Entity var3 = ((EntityLiving)var1).getBrain().getMemory(MemoryModuleType.RIDE_TARGET).orElse(null);
        if (var2 == null && var3 == null) {
            return false;
        }
        Entity var4 = var2 == null ? var3 : var2;
        return !this.isVehicleValid(var1, var4) || this.dontRideIf.test(var1, var4);
    }

    private boolean isVehicleValid(E var0, Entity var1) {
        return var1.isAlive() && var1.closerThan((Entity)var0, this.maxWalkDistToRideTarget) && var1.level == ((EntityLiving)var0).level;
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        ((EntityLiving)var1).stopRiding();
        ((EntityLiving)var1).getBrain().eraseMemory(MemoryModuleType.RIDE_TARGET);
    }
}

