/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;

public class BehaviorInteractPlayer
extends Behavior<EntityVillager> {
    private final float speedModifier;

    public BehaviorInteractPlayer(float var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED)), Integer.MAX_VALUE);
        this.speedModifier = var0;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityVillager var1) {
        EntityHuman var2 = var1.getTradingPlayer();
        return var1.isAlive() && var2 != null && !var1.isInWater() && !var1.hurtMarked && var1.distanceToSqr(var2) <= 16.0 && var2.containerMenu != null;
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityVillager var1, long var2) {
        return this.checkExtraStartConditions(var0, var1);
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var1, long var2) {
        this.followPlayer(var1);
    }

    @Override
    protected void stop(WorldServer var0, EntityVillager var1, long var2) {
        BehaviorController<EntityVillager> var4 = var1.getBrain();
        var4.eraseMemory(MemoryModuleType.WALK_TARGET);
        var4.eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    @Override
    protected void tick(WorldServer var0, EntityVillager var1, long var2) {
        this.followPlayer(var1);
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    private void followPlayer(EntityVillager var0) {
        BehaviorController<EntityVillager> var1 = var0.getBrain();
        var1.setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(new BehaviorPositionEntity(var0.getTradingPlayer(), false), this.speedModifier, 2));
        var1.setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity(var0.getTradingPlayer(), true));
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityVillager)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityVillager)entityLiving, l2);
    }
}

