/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.ShufflingList;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BehaviorGate<E extends EntityLiving>
extends Behavior<E> {
    private final Set<MemoryModuleType<?>> exitErasedMemories;
    private final Order orderPolicy;
    private final Execution runningPolicy;
    private final ShufflingList<Behavior<? super E>> behaviors = new ShufflingList();

    public BehaviorGate(Map<MemoryModuleType<?>, MemoryStatus> var02, Set<MemoryModuleType<?>> var1, Order var2, Execution var3, List<Pair<Behavior<? super E>, Integer>> var4) {
        super(var02);
        this.exitErasedMemories = var1;
        this.orderPolicy = var2;
        this.runningPolicy = var3;
        var4.forEach(var0 -> this.behaviors.add((Behavior)var0.getFirst(), (Integer)var0.getSecond()));
    }

    @Override
    protected boolean canStillUse(WorldServer var02, E var1, long var2) {
        return this.behaviors.stream().filter(var0 -> var0.getStatus() == Behavior.Status.RUNNING).anyMatch(var4 -> var4.canStillUse(var02, var1, var2));
    }

    @Override
    protected boolean timedOut(long var0) {
        return false;
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        this.orderPolicy.apply(this.behaviors);
        this.runningPolicy.apply(this.behaviors.stream(), var0, var1, var2);
    }

    @Override
    protected void tick(WorldServer var02, E var1, long var2) {
        this.behaviors.stream().filter(var0 -> var0.getStatus() == Behavior.Status.RUNNING).forEach(var4 -> var4.tickOrStop(var02, var1, var2));
    }

    @Override
    protected void stop(WorldServer var02, E var1, long var2) {
        this.behaviors.stream().filter(var0 -> var0.getStatus() == Behavior.Status.RUNNING).forEach(var4 -> var4.doStop(var02, var1, var2));
        this.exitErasedMemories.forEach(((EntityLiving)var1).getBrain()::eraseMemory);
    }

    @Override
    public String toString() {
        Set var02 = this.behaviors.stream().filter(var0 -> var0.getStatus() == Behavior.Status.RUNNING).collect(Collectors.toSet());
        return "(" + this.getClass().getSimpleName() + "): " + var02;
    }

    public static final class Order
    extends Enum<Order> {
        public static final /* enum */ Order ORDERED = new Order(var0 -> {});
        public static final /* enum */ Order SHUFFLED = new Order(ShufflingList::shuffle);
        private final Consumer<ShufflingList<?>> consumer;
        private static final /* synthetic */ Order[] d;

        public static Order[] values() {
            return (Order[])d.clone();
        }

        public static Order valueOf(String var0) {
            return Enum.valueOf(Order.class, var0);
        }

        private Order(Consumer var2) {
            this.consumer = var2;
        }

        public void apply(ShufflingList<?> var0) {
            this.consumer.accept(var0);
        }

        private static /* synthetic */ Order[] a() {
            return new Order[]{ORDERED, SHUFFLED};
        }

        static {
            d = Order.a();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Execution
    extends Enum<Execution> {
        public static final /* enum */ Execution RUN_ONE = new Execution(){

            @Override
            public <E extends EntityLiving> void apply(Stream<Behavior<? super E>> var02, WorldServer var1, E var2, long var3) {
                var02.filter(var0 -> var0.getStatus() == Behavior.Status.STOPPED).filter(var4 -> var4.tryStart(var1, var2, var3)).findFirst();
            }
        };
        public static final /* enum */ Execution TRY_ALL = new Execution(){

            @Override
            public <E extends EntityLiving> void apply(Stream<Behavior<? super E>> var02, WorldServer var1, E var2, long var3) {
                var02.filter(var0 -> var0.getStatus() == Behavior.Status.STOPPED).forEach(var4 -> var4.tryStart(var1, var2, var3));
            }
        };
        private static final /* synthetic */ Execution[] c;

        public static Execution[] values() {
            return (Execution[])c.clone();
        }

        public static Execution valueOf(String var0) {
            return Enum.valueOf(Execution.class, var0);
        }

        public abstract <E extends EntityLiving> void apply(Stream<Behavior<? super E>> var1, WorldServer var2, E var3, long var4);

        private static /* synthetic */ Execution[] a() {
            return new Execution[]{RUN_ONE, TRY_ALL};
        }

        static {
            c = Execution.a();
        }
    }
}

