/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BehaviorFollowAdult<E extends EntityAgeable>
extends Behavior<E> {
    private final UniformInt followRange;
    private final Function<EntityLiving, Float> speedModifier;

    public BehaviorFollowAdult(UniformInt var0, float var12) {
        this(var0, var1 -> Float.valueOf(var12));
    }

    public BehaviorFollowAdult(UniformInt var0, Function<EntityLiving, Float> var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.followRange = var0;
        this.speedModifier = var1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        if (!((EntityAgeable)var1).isBaby()) {
            return false;
        }
        EntityAgeable var2 = this.getNearestAdult(var1);
        return ((Entity)var1).closerThan(var2, this.followRange.getMaxValue() + 1) && !((Entity)var1).closerThan(var2, this.followRange.getMinValue());
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        BehaviorUtil.setWalkAndLookTargetMemories(var1, this.getNearestAdult(var1), this.speedModifier.apply((EntityLiving)var1).floatValue(), this.followRange.getMinValue() - 1);
    }

    private EntityAgeable getNearestAdult(E var0) {
        return ((EntityLiving)var0).getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT).get();
    }
}

