/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class BehaviorCelebrateLocation<E extends EntityInsentient>
extends Behavior<E> {
    private final int closeEnoughDist;
    private final float speedModifier;

    public BehaviorCelebrateLocation(int var0, float var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.CELEBRATE_LOCATION, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED)));
        this.closeEnoughDist = var0;
        this.speedModifier = var1;
    }

    @Override
    protected void start(WorldServer var0, EntityInsentient var1, long var2) {
        BlockPosition var4 = BehaviorCelebrateLocation.getCelebrateLocation(var1);
        boolean var5 = var4.closerThan(var1.blockPosition(), this.closeEnoughDist);
        if (!var5) {
            BehaviorUtil.setWalkAndLookTargetMemories((EntityLiving)var1, BehaviorCelebrateLocation.getNearbyPos(var1, var4), this.speedModifier, this.closeEnoughDist);
        }
    }

    private static BlockPosition getNearbyPos(EntityInsentient var0, BlockPosition var1) {
        Random var2 = var0.level.random;
        return var1.offset(BehaviorCelebrateLocation.getRandomOffset(var2), 0, BehaviorCelebrateLocation.getRandomOffset(var2));
    }

    private static int getRandomOffset(Random var0) {
        return var0.nextInt(3) - 1;
    }

    private static BlockPosition getCelebrateLocation(EntityInsentient var0) {
        return var0.getBrain().getMemory(MemoryModuleType.CELEBRATE_LOCATION).get();
    }
}

