/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.IRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;

public class BehaviorCareer
extends Behavior<EntityVillager> {
    public BehaviorCareer() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.POTENTIAL_JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityVillager var1) {
        BlockPosition var2 = var1.getBrain().getMemory(MemoryModuleType.POTENTIAL_JOB_SITE).get().pos();
        return var2.closerToCenterThan(var1.position(), 2.0) || var1.assignProfessionWhenSpawned();
    }

    @Override
    protected void start(WorldServer var02, EntityVillager var12, long var22) {
        GlobalPos var4 = var12.getBrain().getMemory(MemoryModuleType.POTENTIAL_JOB_SITE).get();
        var12.getBrain().eraseMemory(MemoryModuleType.POTENTIAL_JOB_SITE);
        var12.getBrain().setMemory(MemoryModuleType.JOB_SITE, var4);
        var02.broadcastEntityEvent(var12, (byte)14);
        if (var12.getVillagerData().getProfession() != VillagerProfession.NONE) {
            return;
        }
        MinecraftServer var5 = var02.getServer();
        Optional.ofNullable(var5.getLevel(var4.dimension())).flatMap(var1 -> var1.getPoiManager().getType(var4.pos())).flatMap(var0 -> IRegistry.VILLAGER_PROFESSION.stream().filter(var1 -> var1.getJobPoiType() == var0).findFirst()).ifPresent(var2 -> {
            var12.setVillagerData(var12.getVillagerData().setProfession((VillagerProfession)var2));
            var12.refreshBrain(var02);
        });
    }
}

