/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.attributes.AttributeBase;

public class AttributeRanged
extends AttributeBase {
    private final double minValue;
    public final double maxValue;

    public AttributeRanged(String var0, double var1, double var3, double var5) {
        super(var0, var1);
        this.minValue = var3;
        this.maxValue = var5;
        if (var3 > var5) {
            throw new IllegalArgumentException("Minimum value cannot be bigger than maximum value!");
        }
        if (var1 < var3) {
            throw new IllegalArgumentException("Default value cannot be lower than minimum value!");
        }
        if (var1 > var5) {
            throw new IllegalArgumentException("Default value cannot be bigger than maximum value!");
        }
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public double sanitizeValue(double var0) {
        var0 = MathHelper.clamp(var0, this.minValue, this.maxValue);
        return var0;
    }
}

