/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.enchantment.EnchantmentFrostWalker;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockSkullAbstract;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import org.slf4j.Logger;

public abstract class EntityLiving
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final UUID SPEED_MODIFIER_SPRINTING_UUID = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");
    private static final UUID SPEED_MODIFIER_SOUL_SPEED_UUID = UUID.fromString("87f46a96-686f-4796-b035-22e16ee9e038");
    private static final UUID SPEED_MODIFIER_POWDER_SNOW_UUID = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4ce");
    private static final AttributeModifier SPEED_MODIFIER_SPRINTING = new AttributeModifier(SPEED_MODIFIER_SPRINTING_UUID, "Sprinting speed boost", (double)0.3f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final int HAND_SLOTS = 2;
    public static final int ARMOR_SLOTS = 4;
    public static final int EQUIPMENT_SLOT_OFFSET = 98;
    public static final int ARMOR_SLOT_OFFSET = 100;
    public static final int SWING_DURATION = 6;
    public static final int PLAYER_HURT_EXPERIENCE_TIME = 100;
    private static final int DAMAGE_SOURCE_TIMEOUT = 40;
    public static final double MIN_MOVEMENT_DISTANCE = 0.003;
    public static final double DEFAULT_BASE_GRAVITY = 0.08;
    public static final int DEATH_DURATION = 20;
    private static final int WAIT_TICKS_BEFORE_ITEM_USE_EFFECTS = 7;
    private static final int TICKS_PER_ELYTRA_FREE_FALL_EVENT = 10;
    private static final int FREE_FALL_EVENTS_PER_ELYTRA_BREAK = 2;
    public static final int USE_ITEM_INTERVAL = 4;
    private static final double MAX_LINE_OF_SIGHT_TEST_RANGE = 128.0;
    protected static final int LIVING_ENTITY_FLAG_IS_USING = 1;
    protected static final int LIVING_ENTITY_FLAG_OFF_HAND = 2;
    protected static final int LIVING_ENTITY_FLAG_SPIN_ATTACK = 4;
    protected static final DataWatcherObject<Byte> DATA_LIVING_ENTITY_FLAGS = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.BYTE);
    public static final DataWatcherObject<Float> DATA_HEALTH_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Integer> DATA_EFFECT_COLOR_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Boolean> DATA_EFFECT_AMBIENCE_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.BOOLEAN);
    public static final DataWatcherObject<Integer> DATA_ARROW_COUNT_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_STINGER_COUNT_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Optional<BlockPosition>> SLEEPING_POS_ID = DataWatcher.defineId(EntityLiving.class, DataWatcherRegistry.OPTIONAL_BLOCK_POS);
    protected static final float DEFAULT_EYE_HEIGHT = 1.74f;
    protected static final EntitySize SLEEPING_DIMENSIONS = EntitySize.fixed(0.2f, 0.2f);
    public static final float EXTRA_RENDER_CULLING_SIZE_WITH_BIG_HAT = 0.5f;
    private final AttributeMapBase attributes;
    public CombatTracker combatTracker = new CombatTracker(this);
    public final Map<MobEffectList, MobEffect> activeEffects = Maps.newHashMap();
    private final NonNullList<ItemStack> lastHandItemStacks = NonNullList.withSize(2, ItemStack.EMPTY);
    private final NonNullList<ItemStack> lastArmorItemStacks = NonNullList.withSize(4, ItemStack.EMPTY);
    public boolean swinging;
    private boolean discardFriction = false;
    public EnumHand swingingArm;
    public int swingTime;
    public int removeArrowTime;
    public int removeStingerTime;
    public int hurtTime;
    public int hurtDuration;
    public float hurtDir;
    public int deathTime;
    public float oAttackAnim;
    public float attackAnim;
    protected int attackStrengthTicker;
    public float animationSpeedOld;
    public float animationSpeed;
    public float animationPosition;
    public int invulnerableDuration = 20;
    public final float timeOffs;
    public final float rotA;
    public float yBodyRot;
    public float yBodyRotO;
    public float yHeadRot;
    public float yHeadRotO;
    public float flyingSpeed = 0.02f;
    @Nullable
    public EntityHuman lastHurtByPlayer;
    protected int lastHurtByPlayerTime;
    protected boolean dead;
    protected int noActionTime;
    protected float oRun;
    protected float run;
    protected float animStep;
    protected float animStepO;
    protected float rotOffs;
    protected int deathScore;
    public float lastHurt;
    protected boolean jumping;
    public float xxa;
    public float yya;
    public float zza;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;
    protected double lyHeadRot;
    protected int lerpHeadSteps;
    public boolean effectsDirty = true;
    @Nullable
    public EntityLiving lastHurtByMob;
    public int lastHurtByMobTimestamp;
    private EntityLiving lastHurtMob;
    private int lastHurtMobTimestamp;
    private float speed;
    private int noJumpDelay;
    private float absorptionAmount;
    protected ItemStack useItem = ItemStack.EMPTY;
    protected int useItemRemaining;
    protected int fallFlyTicks;
    private BlockPosition lastPos;
    private Optional<BlockPosition> lastClimbablePos = Optional.empty();
    @Nullable
    private DamageSource lastDamageSource;
    private long lastDamageStamp;
    protected int autoSpinAttackTicks;
    private float swimAmount;
    private float swimAmountO;
    protected BehaviorController<?> brain;

    protected EntityLiving(EntityTypes<? extends EntityLiving> var0, World var1) {
        super(var0, var1);
        this.attributes = new AttributeMapBase(AttributeDefaults.getSupplier(var0));
        this.setHealth(this.getMaxHealth());
        this.blocksBuilding = true;
        this.rotA = (float)((Math.random() + 1.0) * (double)0.01f);
        this.reapplyPosition();
        this.timeOffs = (float)Math.random() * 12398.0f;
        this.setYRot((float)(Math.random() * 6.2831854820251465));
        this.yHeadRot = this.getYRot();
        this.maxUpStep = 0.6f;
        DynamicOpsNBT var2 = DynamicOpsNBT.INSTANCE;
        this.brain = this.makeBrain(new Dynamic((DynamicOps)var2, (Object)((NBTBase)var2.createMap((Map)ImmutableMap.of((Object)var2.createString("memories"), (Object)((NBTBase)var2.emptyMap()))))));
    }

    public BehaviorController<?> getBrain() {
        return this.brain;
    }

    protected BehaviorController.b<?> brainProvider() {
        return BehaviorController.provider(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return this.brainProvider().makeBrain(var0);
    }

    @Override
    public void kill() {
        this.hurt(DamageSource.OUT_OF_WORLD, Float.MAX_VALUE);
    }

    public boolean canAttackType(EntityTypes<?> var0) {
        return true;
    }

    @Override
    protected void defineSynchedData() {
        this.entityData.define(DATA_LIVING_ENTITY_FLAGS, (byte)0);
        this.entityData.define(DATA_EFFECT_COLOR_ID, 0);
        this.entityData.define(DATA_EFFECT_AMBIENCE_ID, false);
        this.entityData.define(DATA_ARROW_COUNT_ID, 0);
        this.entityData.define(DATA_STINGER_COUNT_ID, 0);
        this.entityData.define(DATA_HEALTH_ID, Float.valueOf(1.0f));
        this.entityData.define(SLEEPING_POS_ID, Optional.empty());
    }

    public static AttributeProvider.Builder createLivingAttributes() {
        return AttributeProvider.builder().add(GenericAttributes.MAX_HEALTH).add(GenericAttributes.KNOCKBACK_RESISTANCE).add(GenericAttributes.MOVEMENT_SPEED).add(GenericAttributes.ARMOR).add(GenericAttributes.ARMOR_TOUGHNESS);
    }

    @Override
    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
        if (!this.isInWater()) {
            this.updateInWaterStateAndDoWaterCurrentPushing();
        }
        if (!this.level.isClientSide && var2 && this.fallDistance > 0.0f) {
            this.removeSoulSpeed();
            this.tryAddSoulSpeed();
        }
        if (!this.level.isClientSide && this.fallDistance > 3.0f && var2) {
            float var5 = MathHelper.ceil(this.fallDistance - 3.0f);
            if (!var3.isAir()) {
                double var6 = Math.min((double)(0.2f + var5 / 15.0f), 2.5);
                int var8 = (int)(150.0 * var6);
                ((WorldServer)this.level).sendParticles(new ParticleParamBlock(Particles.BLOCK, var3), this.getX(), this.getY(), this.getZ(), var8, 0.0, 0.0, 0.0, 0.15f);
            }
        }
        super.checkFallDamage(var0, var2, var3, var4);
    }

    public boolean canBreatheUnderwater() {
        return this.getMobType() == EnumMonsterType.UNDEAD;
    }

    public float getSwimAmount(float var0) {
        return MathHelper.lerp(var0, this.swimAmountO, this.swimAmount);
    }

    @Override
    public void baseTick() {
        this.oAttackAnim = this.attackAnim;
        if (this.firstTick) {
            this.getSleepingPos().ifPresent(this::setPosToBed);
        }
        if (this.canSpawnSoulSpeedParticle()) {
            this.spawnSoulSpeedParticle();
        }
        super.baseTick();
        this.level.getProfiler().push("livingEntityBaseTick");
        if (this.fireImmune() || this.level.isClientSide) {
            this.clearFire();
        }
        if (this.isAlive()) {
            BlockPosition var1;
            double var3;
            double var12;
            boolean var0 = this instanceof EntityHuman;
            if (this.isInWall()) {
                this.hurt(DamageSource.IN_WALL, 1.0f);
            } else if (var0 && !this.level.getWorldBorder().isWithinBounds(this.getBoundingBox()) && (var12 = this.level.getWorldBorder().getDistanceToBorder(this) + this.level.getWorldBorder().getDamageSafeZone()) < 0.0 && (var3 = this.level.getWorldBorder().getDamagePerBlock()) > 0.0) {
                this.hurt(DamageSource.IN_WALL, Math.max(1, MathHelper.floor(-var12 * var3)));
            }
            if (this.isEyeInFluid(TagsFluid.WATER) && !this.level.getBlockState(new BlockPosition(this.getX(), this.getEyeY(), this.getZ())).is(Blocks.BUBBLE_COLUMN)) {
                boolean var13;
                boolean bl = var13 = !this.canBreatheUnderwater() && !MobEffectUtil.hasWaterBreathing(this) && (!var0 || !((EntityHuman)this).getAbilities().invulnerable);
                if (var13) {
                    this.setAirSupply(this.decreaseAirSupply(this.getAirSupply()));
                    if (this.getAirSupply() == -20) {
                        this.setAirSupply(0);
                        Vec3D var2 = this.getDeltaMovement();
                        for (int var32 = 0; var32 < 8; ++var32) {
                            double var4 = this.random.nextDouble() - this.random.nextDouble();
                            double var6 = this.random.nextDouble() - this.random.nextDouble();
                            double var8 = this.random.nextDouble() - this.random.nextDouble();
                            this.level.addParticle(Particles.BUBBLE, this.getX() + var4, this.getY() + var6, this.getZ() + var8, var2.x, var2.y, var2.z);
                        }
                        this.hurt(DamageSource.DROWN, 2.0f);
                    }
                }
                if (!this.level.isClientSide && this.isPassenger() && this.getVehicle() != null && !this.getVehicle().rideableUnderWater()) {
                    this.stopRiding();
                }
            } else if (this.getAirSupply() < this.getMaxAirSupply()) {
                this.setAirSupply(this.increaseAirSupply(this.getAirSupply()));
            }
            if (!this.level.isClientSide && !Objects.equal((Object)this.lastPos, (Object)(var1 = this.blockPosition()))) {
                this.lastPos = var1;
                this.onChangedBlock(var1);
            }
        }
        if (this.isAlive() && (this.isInWaterRainOrBubble() || this.isInPowderSnow)) {
            if (!this.level.isClientSide && this.wasOnFire) {
                this.playEntityOnFireExtinguishedSound();
            }
            this.clearFire();
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.invulnerableTime > 0 && !(this instanceof EntityPlayer)) {
            --this.invulnerableTime;
        }
        if (this.isDeadOrDying() && this.level.shouldTickDeath(this)) {
            this.tickDeath();
        }
        if (this.lastHurtByPlayerTime > 0) {
            --this.lastHurtByPlayerTime;
        } else {
            this.lastHurtByPlayer = null;
        }
        if (this.lastHurtMob != null && !this.lastHurtMob.isAlive()) {
            this.lastHurtMob = null;
        }
        if (this.lastHurtByMob != null) {
            if (!this.lastHurtByMob.isAlive()) {
                this.setLastHurtByMob(null);
            } else if (this.tickCount - this.lastHurtByMobTimestamp > 100) {
                this.setLastHurtByMob(null);
            }
        }
        this.tickEffects();
        this.animStepO = this.animStep;
        this.yBodyRotO = this.yBodyRot;
        this.yHeadRotO = this.yHeadRot;
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.level.getProfiler().pop();
    }

    public boolean canSpawnSoulSpeedParticle() {
        return this.tickCount % 5 == 0 && this.getDeltaMovement().x != 0.0 && this.getDeltaMovement().z != 0.0 && !this.isSpectator() && EnchantmentManager.hasSoulSpeed(this) && this.onSoulSpeedBlock();
    }

    protected void spawnSoulSpeedParticle() {
        Vec3D var0 = this.getDeltaMovement();
        this.level.addParticle(Particles.SOUL, this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + 0.1, this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), var0.x * -0.2, 0.1, var0.z * -0.2);
        float var1 = this.random.nextFloat() * 0.4f + this.random.nextFloat() > 0.9f ? 0.6f : 0.0f;
        this.playSound(SoundEffects.SOUL_ESCAPE, var1, 0.6f + this.random.nextFloat() * 0.4f);
    }

    protected boolean onSoulSpeedBlock() {
        return this.level.getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).is(TagsBlock.SOUL_SPEED_BLOCKS);
    }

    @Override
    protected float getBlockSpeedFactor() {
        if (this.onSoulSpeedBlock() && EnchantmentManager.getEnchantmentLevel(Enchantments.SOUL_SPEED, this) > 0) {
            return 1.0f;
        }
        return super.getBlockSpeedFactor();
    }

    protected boolean shouldRemoveSoulSpeed(IBlockData var0) {
        return !var0.isAir() || this.isFallFlying();
    }

    protected void removeSoulSpeed() {
        AttributeModifiable var0 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
        if (var0 == null) {
            return;
        }
        if (var0.getModifier(SPEED_MODIFIER_SOUL_SPEED_UUID) != null) {
            var0.removeModifier(SPEED_MODIFIER_SOUL_SPEED_UUID);
        }
    }

    protected void tryAddSoulSpeed() {
        int var02;
        if (!this.getBlockStateOn().isAir() && (var02 = EnchantmentManager.getEnchantmentLevel(Enchantments.SOUL_SPEED, this)) > 0 && this.onSoulSpeedBlock()) {
            AttributeModifiable var1 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
            if (var1 == null) {
                return;
            }
            var1.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_SOUL_SPEED_UUID, "Soul speed boost", (double)(0.03f * (1.0f + (float)var02 * 0.35f)), AttributeModifier.Operation.ADDITION));
            if (this.getRandom().nextFloat() < 0.04f) {
                ItemStack var2 = this.getItemBySlot(EnumItemSlot.FEET);
                var2.hurtAndBreak(1, this, var0 -> var0.broadcastBreakEvent(EnumItemSlot.FEET));
            }
        }
    }

    protected void removeFrost() {
        AttributeModifiable var0 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
        if (var0 == null) {
            return;
        }
        if (var0.getModifier(SPEED_MODIFIER_POWDER_SNOW_UUID) != null) {
            var0.removeModifier(SPEED_MODIFIER_POWDER_SNOW_UUID);
        }
    }

    protected void tryAddFrost() {
        int var0;
        if (!this.getBlockStateOn().isAir() && (var0 = this.getTicksFrozen()) > 0) {
            AttributeModifiable var1 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
            if (var1 == null) {
                return;
            }
            float var2 = -0.05f * this.getPercentFrozen();
            var1.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_POWDER_SNOW_UUID, "Powder snow slow", (double)var2, AttributeModifier.Operation.ADDITION));
        }
    }

    protected void onChangedBlock(BlockPosition var0) {
        int var1 = EnchantmentManager.getEnchantmentLevel(Enchantments.FROST_WALKER, this);
        if (var1 > 0) {
            EnchantmentFrostWalker.onEntityMoved(this, this.level, var0, var1);
        }
        if (this.shouldRemoveSoulSpeed(this.getBlockStateOn())) {
            this.removeSoulSpeed();
        }
        this.tryAddSoulSpeed();
    }

    public boolean isBaby() {
        return false;
    }

    public float getScale() {
        return this.isBaby() ? 0.5f : 1.0f;
    }

    protected boolean isAffectedByFluids() {
        return true;
    }

    @Override
    public boolean rideableUnderWater() {
        return false;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 20 && !this.level.isClientSide()) {
            this.level.broadcastEntityEvent(this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected boolean shouldDropExperience() {
        return !this.isBaby();
    }

    protected boolean shouldDropLoot() {
        return !this.isBaby();
    }

    protected int decreaseAirSupply(int var0) {
        int var1 = EnchantmentManager.getRespiration(this);
        if (var1 > 0 && this.random.nextInt(var1 + 1) > 0) {
            return var0;
        }
        return var0 - 1;
    }

    protected int increaseAirSupply(int var0) {
        return Math.min(var0 + 4, this.getMaxAirSupply());
    }

    protected int getExperienceReward(EntityHuman var0) {
        return 0;
    }

    protected boolean isAlwaysExperienceDropper() {
        return false;
    }

    public Random getRandom() {
        return this.random;
    }

    @Nullable
    public EntityLiving getLastHurtByMob() {
        return this.lastHurtByMob;
    }

    public int getLastHurtByMobTimestamp() {
        return this.lastHurtByMobTimestamp;
    }

    public void setLastHurtByPlayer(@Nullable EntityHuman var0) {
        this.lastHurtByPlayer = var0;
        this.lastHurtByPlayerTime = this.tickCount;
    }

    public void setLastHurtByMob(@Nullable EntityLiving var0) {
        this.lastHurtByMob = var0;
        this.lastHurtByMobTimestamp = this.tickCount;
    }

    @Nullable
    public EntityLiving getLastHurtMob() {
        return this.lastHurtMob;
    }

    public int getLastHurtMobTimestamp() {
        return this.lastHurtMobTimestamp;
    }

    public void setLastHurtMob(Entity var0) {
        this.lastHurtMob = var0 instanceof EntityLiving ? (EntityLiving)var0 : null;
        this.lastHurtMobTimestamp = this.tickCount;
    }

    public int getNoActionTime() {
        return this.noActionTime;
    }

    public void setNoActionTime(int var0) {
        this.noActionTime = var0;
    }

    public boolean shouldDiscardFriction() {
        return this.discardFriction;
    }

    public void setDiscardFriction(boolean var0) {
        this.discardFriction = var0;
    }

    protected void equipEventAndSound(ItemStack var0) {
        SoundEffect var1 = var0.getEquipSound();
        if (var0.isEmpty() || var1 == null || this.isSpectator()) {
            return;
        }
        this.gameEvent(GameEvent.EQUIP);
        this.playSound(var1, 1.0f, 1.0f);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        DataResult<NBTBase> var12;
        var0.putFloat("Health", this.getHealth());
        var0.putShort("HurtTime", (short)this.hurtTime);
        var0.putInt("HurtByTimestamp", this.lastHurtByMobTimestamp);
        var0.putShort("DeathTime", (short)this.deathTime);
        var0.putFloat("AbsorptionAmount", this.getAbsorptionAmount());
        var0.put("Attributes", this.getAttributes().save());
        if (!this.activeEffects.isEmpty()) {
            var12 = new DataResult<NBTBase>();
            for (MobEffect var3 : this.activeEffects.values()) {
                var12.add(var3.save(new NBTTagCompound()));
            }
            var0.put("ActiveEffects", (NBTBase)var12);
        }
        var0.putBoolean("FallFlying", this.isFallFlying());
        this.getSleepingPos().ifPresent(var1 -> {
            var0.putInt("SleepingX", var1.getX());
            var0.putInt("SleepingY", var1.getY());
            var0.putInt("SleepingZ", var1.getZ());
        });
        var12 = this.brain.serializeStart(DynamicOpsNBT.INSTANCE);
        var12.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("Brain", (NBTBase)var1));
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        Object var1;
        this.setAbsorptionAmount(var0.getFloat("AbsorptionAmount"));
        if (var0.contains("Attributes", 9) && this.level != null && !this.level.isClientSide) {
            this.getAttributes().load(var0.getList("Attributes", 10));
        }
        if (var0.contains("ActiveEffects", 9)) {
            var1 = var0.getList("ActiveEffects", 10);
            for (int var2 = 0; var2 < ((NBTTagList)var1).size(); ++var2) {
                NBTTagCompound var3 = ((NBTTagList)var1).getCompound(var2);
                MobEffect var4 = MobEffect.load(var3);
                if (var4 == null) continue;
                this.activeEffects.put(var4.getEffect(), var4);
            }
        }
        if (var0.contains("Health", 99)) {
            this.setHealth(var0.getFloat("Health"));
        }
        this.hurtTime = var0.getShort("HurtTime");
        this.deathTime = var0.getShort("DeathTime");
        this.lastHurtByMobTimestamp = var0.getInt("HurtByTimestamp");
        if (var0.contains("Team", 8)) {
            boolean var3;
            var1 = var0.getString("Team");
            ScoreboardTeam var2 = this.level.getScoreboard().getPlayerTeam((String)var1);
            boolean bl = var3 = var2 != null && this.level.getScoreboard().addPlayerToTeam(this.getStringUUID(), var2);
            if (!var3) {
                LOGGER.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", var1);
            }
        }
        if (var0.getBoolean("FallFlying")) {
            this.setSharedFlag(7, true);
        }
        if (var0.contains("SleepingX", 99) && var0.contains("SleepingY", 99) && var0.contains("SleepingZ", 99)) {
            var1 = new BlockPosition(var0.getInt("SleepingX"), var0.getInt("SleepingY"), var0.getInt("SleepingZ"));
            this.setSleepingPos((BlockPosition)var1);
            this.entityData.set(DATA_POSE, EntityPose.SLEEPING);
            if (!this.firstTick) {
                this.setPosToBed((BlockPosition)var1);
            }
        }
        if (var0.contains("Brain", 10)) {
            this.brain = this.makeBrain(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var0.get("Brain")));
        }
    }

    protected void tickEffects() {
        Iterator<MobEffectList> var0 = this.activeEffects.keySet().iterator();
        try {
            while (var0.hasNext()) {
                MobEffectList var1 = var0.next();
                MobEffect var2 = this.activeEffects.get(var1);
                if (!var2.tick(this, () -> this.onEffectUpdated(var2, true, null))) {
                    if (this.level.isClientSide) continue;
                    var0.remove();
                    this.onEffectRemoved(var2);
                    continue;
                }
                if (var2.getDuration() % 600 != 0) continue;
                this.onEffectUpdated(var2, false, null);
            }
        }
        catch (ConcurrentModificationException var1) {
            // empty catch block
        }
        if (this.effectsDirty) {
            if (!this.level.isClientSide) {
                this.updateInvisibilityStatus();
                this.updateGlowingStatus();
            }
            this.effectsDirty = false;
        }
        int var1 = this.entityData.get(DATA_EFFECT_COLOR_ID);
        boolean var2 = this.entityData.get(DATA_EFFECT_AMBIENCE_ID);
        if (var1 > 0) {
            boolean var3 = this.isInvisible() ? this.random.nextInt(15) == 0 : this.random.nextBoolean();
            if (var2) {
                var3 &= this.random.nextInt(5) == 0;
            }
            if (var3 && var1 > 0) {
                double var4 = (double)(var1 >> 16 & 0xFF) / 255.0;
                double var6 = (double)(var1 >> 8 & 0xFF) / 255.0;
                double var8 = (double)(var1 >> 0 & 0xFF) / 255.0;
                this.level.addParticle(var2 ? Particles.AMBIENT_ENTITY_EFFECT : Particles.ENTITY_EFFECT, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), var4, var6, var8);
            }
        }
    }

    protected void updateInvisibilityStatus() {
        if (this.activeEffects.isEmpty()) {
            this.removeEffectParticles();
            this.setInvisible(false);
        } else {
            Collection<MobEffect> var0 = this.activeEffects.values();
            this.entityData.set(DATA_EFFECT_AMBIENCE_ID, EntityLiving.areAllEffectsAmbient(var0));
            this.entityData.set(DATA_EFFECT_COLOR_ID, PotionUtil.getColor(var0));
            this.setInvisible(this.hasEffect(MobEffects.INVISIBILITY));
        }
    }

    private void updateGlowingStatus() {
        boolean var0 = this.isCurrentlyGlowing();
        if (this.getSharedFlag(6) != var0) {
            this.setSharedFlag(6, var0);
        }
    }

    public double getVisibilityPercent(@Nullable Entity var0) {
        double var1 = 1.0;
        if (this.isDiscrete()) {
            var1 *= 0.8;
        }
        if (this.isInvisible()) {
            float var3 = this.getArmorCoverPercentage();
            if (var3 < 0.1f) {
                var3 = 0.1f;
            }
            var1 *= 0.7 * (double)var3;
        }
        if (var0 != null) {
            ItemStack var3 = this.getItemBySlot(EnumItemSlot.HEAD);
            EntityTypes<?> var4 = var0.getType();
            if (var4 == EntityTypes.SKELETON && var3.is(Items.SKELETON_SKULL) || var4 == EntityTypes.ZOMBIE && var3.is(Items.ZOMBIE_HEAD) || var4 == EntityTypes.CREEPER && var3.is(Items.CREEPER_HEAD)) {
                var1 *= 0.5;
            }
        }
        return var1;
    }

    public boolean canAttack(EntityLiving var0) {
        if (var0 instanceof EntityHuman && this.level.getDifficulty() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        return var0.canBeSeenAsEnemy();
    }

    public boolean canAttack(EntityLiving var0, PathfinderTargetCondition var1) {
        return var1.test(this, var0);
    }

    public boolean canBeSeenAsEnemy() {
        return !this.isInvulnerable() && this.canBeSeenByAnyone();
    }

    public boolean canBeSeenByAnyone() {
        return !this.isSpectator() && this.isAlive();
    }

    public static boolean areAllEffectsAmbient(Collection<MobEffect> var0) {
        for (MobEffect var2 : var0) {
            if (!var2.isVisible() || var2.isAmbient()) continue;
            return false;
        }
        return true;
    }

    protected void removeEffectParticles() {
        this.entityData.set(DATA_EFFECT_AMBIENCE_ID, false);
        this.entityData.set(DATA_EFFECT_COLOR_ID, 0);
    }

    public boolean removeAllEffects() {
        if (this.level.isClientSide) {
            return false;
        }
        Iterator<MobEffect> var0 = this.activeEffects.values().iterator();
        boolean var1 = false;
        while (var0.hasNext()) {
            this.onEffectRemoved(var0.next());
            var0.remove();
            var1 = true;
        }
        return var1;
    }

    public Collection<MobEffect> getActiveEffects() {
        return this.activeEffects.values();
    }

    public Map<MobEffectList, MobEffect> getActiveEffectsMap() {
        return this.activeEffects;
    }

    public boolean hasEffect(MobEffectList var0) {
        return this.activeEffects.containsKey(var0);
    }

    @Nullable
    public MobEffect getEffect(MobEffectList var0) {
        return this.activeEffects.get(var0);
    }

    public final boolean addEffect(MobEffect var0) {
        return this.addEffect(var0, null);
    }

    public boolean addEffect(MobEffect var0, @Nullable Entity var1) {
        if (!this.canBeAffected(var0)) {
            return false;
        }
        MobEffect var2 = this.activeEffects.get(var0.getEffect());
        if (var2 == null) {
            this.activeEffects.put(var0.getEffect(), var0);
            this.onEffectAdded(var0, var1);
            return true;
        }
        if (var2.update(var0)) {
            this.onEffectUpdated(var2, true, var1);
            return true;
        }
        return false;
    }

    public boolean canBeAffected(MobEffect var0) {
        MobEffectList var1;
        return this.getMobType() != EnumMonsterType.UNDEAD || (var1 = var0.getEffect()) != MobEffects.REGENERATION && var1 != MobEffects.POISON;
    }

    public void forceAddEffect(MobEffect var0, @Nullable Entity var1) {
        if (!this.canBeAffected(var0)) {
            return;
        }
        MobEffect var2 = this.activeEffects.put(var0.getEffect(), var0);
        if (var2 == null) {
            this.onEffectAdded(var0, var1);
        } else {
            this.onEffectUpdated(var0, true, var1);
        }
    }

    public boolean isInvertedHealAndHarm() {
        return this.getMobType() == EnumMonsterType.UNDEAD;
    }

    @Nullable
    public MobEffect removeEffectNoUpdate(@Nullable MobEffectList var0) {
        return this.activeEffects.remove(var0);
    }

    public boolean removeEffect(MobEffectList var0) {
        MobEffect var1 = this.removeEffectNoUpdate(var0);
        if (var1 != null) {
            this.onEffectRemoved(var1);
            return true;
        }
        return false;
    }

    protected void onEffectAdded(MobEffect var0, @Nullable Entity var1) {
        this.effectsDirty = true;
        if (!this.level.isClientSide) {
            var0.getEffect().addAttributeModifiers(this, this.getAttributes(), var0.getAmplifier());
        }
    }

    protected void onEffectUpdated(MobEffect var0, boolean var1, @Nullable Entity var2) {
        this.effectsDirty = true;
        if (var1 && !this.level.isClientSide) {
            MobEffectList var3 = var0.getEffect();
            var3.removeAttributeModifiers(this, this.getAttributes(), var0.getAmplifier());
            var3.addAttributeModifiers(this, this.getAttributes(), var0.getAmplifier());
        }
    }

    protected void onEffectRemoved(MobEffect var0) {
        this.effectsDirty = true;
        if (!this.level.isClientSide) {
            var0.getEffect().removeAttributeModifiers(this, this.getAttributes(), var0.getAmplifier());
        }
    }

    public void heal(float var0) {
        float var1 = this.getHealth();
        if (var1 > 0.0f) {
            this.setHealth(var1 + var0);
        }
    }

    public float getHealth() {
        return this.entityData.get(DATA_HEALTH_ID).floatValue();
    }

    public void setHealth(float var0) {
        this.entityData.set(DATA_HEALTH_ID, Float.valueOf(MathHelper.clamp(var0, 0.0f, this.getMaxHealth())));
    }

    public boolean isDeadOrDying() {
        return this.getHealth() <= 0.0f;
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        boolean var7;
        Object var72;
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        if (this.level.isClientSide) {
            return false;
        }
        if (this.isDeadOrDying()) {
            return false;
        }
        if (var0.isFire() && this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return false;
        }
        if (this.isSleeping() && !this.level.isClientSide) {
            this.stopSleeping();
        }
        this.noActionTime = 0;
        float var2 = var1;
        boolean var3 = false;
        float var4 = 0.0f;
        if (var1 > 0.0f && this.isDamageSourceBlocked(var0)) {
            Entity var5;
            this.hurtCurrentlyUsedShield(var1);
            var4 = var1;
            var1 = 0.0f;
            if (!var0.isProjectile() && (var5 = var0.getDirectEntity()) instanceof EntityLiving) {
                this.blockUsingShield((EntityLiving)var5);
            }
            var3 = true;
        }
        this.animationSpeed = 1.5f;
        boolean var5 = true;
        if ((float)this.invulnerableTime > 10.0f) {
            if (var1 <= this.lastHurt) {
                return false;
            }
            this.actuallyHurt(var0, var1 - this.lastHurt);
            this.lastHurt = var1;
            var5 = false;
        } else {
            this.lastHurt = var1;
            this.invulnerableTime = 20;
            this.actuallyHurt(var0, var1);
            this.hurtTime = this.hurtDuration = 10;
        }
        if (var0.isDamageHelmet() && !this.getItemBySlot(EnumItemSlot.HEAD).isEmpty()) {
            this.hurtHelmet(var0, var1);
            var1 *= 0.75f;
        }
        this.hurtDir = 0.0f;
        Entity var6 = var0.getEntity();
        if (var6 != null) {
            if (var6 instanceof EntityLiving && !var0.isNoAggro()) {
                this.setLastHurtByMob((EntityLiving)var6);
            }
            if (var6 instanceof EntityHuman) {
                this.lastHurtByPlayerTime = 100;
                this.lastHurtByPlayer = (EntityHuman)var6;
            } else if (var6 instanceof EntityWolf && ((EntityTameableAnimal)(var72 = (EntityWolf)var6)).isTame()) {
                this.lastHurtByPlayerTime = 100;
                EntityLiving var8 = ((EntityTameableAnimal)var72).getOwner();
                this.lastHurtByPlayer = var8 != null && var8.getType() == EntityTypes.PLAYER ? (EntityHuman)var8 : null;
            }
        }
        if (var5) {
            if (var3) {
                this.level.broadcastEntityEvent(this, (byte)29);
            } else if (var0 instanceof EntityDamageSource && ((EntityDamageSource)var0).isThorns()) {
                this.level.broadcastEntityEvent(this, (byte)33);
            } else {
                int var73 = var0 == DamageSource.DROWN ? 36 : (var0.isFire() ? 37 : (var0 == DamageSource.SWEET_BERRY_BUSH ? 44 : (var0 == DamageSource.FREEZE ? 57 : 2)));
                this.level.broadcastEntityEvent(this, (byte)var73);
            }
            if (var0 != DamageSource.DROWN && (!var3 || var1 > 0.0f)) {
                this.markHurt();
            }
            if (var6 != null) {
                double var74 = var6.getX() - this.getX();
                double var9 = var6.getZ() - this.getZ();
                while (var74 * var74 + var9 * var9 < 1.0E-4) {
                    var74 = (Math.random() - Math.random()) * 0.01;
                    var9 = (Math.random() - Math.random()) * 0.01;
                }
                this.hurtDir = (float)(MathHelper.atan2(var9, var74) * 57.2957763671875 - (double)this.getYRot());
                this.knockback(0.4f, var74, var9);
            } else {
                this.hurtDir = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.isDeadOrDying()) {
            if (!this.checkTotemDeathProtection(var0)) {
                var72 = this.getDeathSound();
                if (var5 && var72 != null) {
                    this.playSound((SoundEffect)var72, this.getSoundVolume(), this.getVoicePitch());
                }
                this.die(var0);
            }
        } else if (var5) {
            this.playHurtSound(var0);
        }
        boolean bl = var7 = !var3 || var1 > 0.0f;
        if (var7) {
            this.lastDamageSource = var0;
            this.lastDamageStamp = this.level.getGameTime();
        }
        if (this instanceof EntityPlayer) {
            CriterionTriggers.ENTITY_HURT_PLAYER.trigger((EntityPlayer)this, var0, var2, var1, var3);
            if (var4 > 0.0f && var4 < 3.4028235E37f) {
                ((EntityPlayer)this).awardStat(StatisticList.DAMAGE_BLOCKED_BY_SHIELD, Math.round(var4 * 10.0f));
            }
        }
        if (var6 instanceof EntityPlayer) {
            CriterionTriggers.PLAYER_HURT_ENTITY.trigger((EntityPlayer)var6, this, var0, var2, var1, var3);
        }
        return var7;
    }

    protected void blockUsingShield(EntityLiving var0) {
        var0.blockedByShield(this);
    }

    protected void blockedByShield(EntityLiving var0) {
        var0.knockback(0.5, var0.getX() - this.getX(), var0.getZ() - this.getZ());
    }

    private boolean checkTotemDeathProtection(DamageSource var0) {
        if (var0.isBypassInvul()) {
            return false;
        }
        ItemStack var1 = null;
        for (EnumHand var6 : EnumHand.values()) {
            ItemStack var2 = this.getItemInHand(var6);
            if (!var2.is(Items.TOTEM_OF_UNDYING)) continue;
            var1 = var2.copy();
            var2.shrink(1);
            break;
        }
        if (var1 != null) {
            if (this instanceof EntityPlayer) {
                EntityPlayer var3 = (EntityPlayer)this;
                var3.awardStat(StatisticList.ITEM_USED.get(Items.TOTEM_OF_UNDYING));
                CriterionTriggers.USED_TOTEM.trigger(var3, var1);
            }
            this.setHealth(1.0f);
            this.removeAllEffects();
            this.addEffect(new MobEffect(MobEffects.REGENERATION, 900, 1));
            this.addEffect(new MobEffect(MobEffects.ABSORPTION, 100, 1));
            this.addEffect(new MobEffect(MobEffects.FIRE_RESISTANCE, 800, 0));
            this.level.broadcastEntityEvent(this, (byte)35);
        }
        return var1 != null;
    }

    @Nullable
    public DamageSource getLastDamageSource() {
        if (this.level.getGameTime() - this.lastDamageStamp > 40L) {
            this.lastDamageSource = null;
        }
        return this.lastDamageSource;
    }

    protected void playHurtSound(DamageSource var0) {
        SoundEffect var1 = this.getHurtSound(var0);
        if (var1 != null) {
            this.playSound(var1, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public boolean isDamageSourceBlocked(DamageSource var0) {
        Object var3;
        Entity var1 = var0.getDirectEntity();
        boolean var2 = false;
        if (var1 instanceof EntityArrow && ((EntityArrow)(var3 = (EntityArrow)var1)).getPierceLevel() > 0) {
            var2 = true;
        }
        if (!var0.isBypassArmor() && this.isBlocking() && !var2 && (var3 = var0.getSourcePosition()) != null) {
            Vec3D var4 = this.getViewVector(1.0f);
            Vec3D var5 = ((Vec3D)var3).vectorTo(this.position()).normalize();
            var5 = new Vec3D(var5.x, 0.0, var5.z);
            if (var5.dot(var4) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private void breakItem(ItemStack var0) {
        if (!var0.isEmpty()) {
            if (!this.isSilent()) {
                this.level.playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.ITEM_BREAK, this.getSoundSource(), 0.8f, 0.8f + this.level.random.nextFloat() * 0.4f, false);
            }
            this.spawnItemParticles(var0, 5);
        }
    }

    public void die(DamageSource var0) {
        if (this.isRemoved() || this.dead) {
            return;
        }
        Entity var1 = var0.getEntity();
        EntityLiving var2 = this.getKillCredit();
        if (this.deathScore >= 0 && var2 != null) {
            var2.awardKillScore(this, this.deathScore, var0);
        }
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        if (!this.level.isClientSide && this.hasCustomName()) {
            LOGGER.info("Named entity {} died: {}", (Object)this, (Object)this.getCombatTracker().getDeathMessage().getString());
        }
        this.dead = true;
        this.getCombatTracker().recheckStatus();
        if (this.level instanceof WorldServer) {
            if (var1 != null) {
                var1.killed((WorldServer)this.level, this);
            }
            this.dropAllDeathLoot(var0);
            this.createWitherRose(var2);
        }
        this.level.broadcastEntityEvent(this, (byte)3);
        this.setPose(EntityPose.DYING);
    }

    protected void createWitherRose(@Nullable EntityLiving var0) {
        if (this.level.isClientSide) {
            return;
        }
        boolean var1 = false;
        if (var0 instanceof EntityWither) {
            Object var2;
            if (this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                var2 = this.blockPosition();
                IBlockData var3 = Blocks.WITHER_ROSE.defaultBlockState();
                if (this.level.getBlockState((BlockPosition)var2).isAir() && var3.canSurvive(this.level, (BlockPosition)var2)) {
                    this.level.setBlock((BlockPosition)var2, var3, 3);
                    var1 = true;
                }
            }
            if (!var1) {
                var2 = new EntityItem(this.level, this.getX(), this.getY(), this.getZ(), new ItemStack(Items.WITHER_ROSE));
                this.level.addFreshEntity((Entity)var2);
            }
        }
    }

    protected void dropAllDeathLoot(DamageSource var0) {
        boolean var3;
        Entity var1 = var0.getEntity();
        int var2 = var1 instanceof EntityHuman ? EnchantmentManager.getMobLooting((EntityLiving)var1) : 0;
        boolean bl = var3 = this.lastHurtByPlayerTime > 0;
        if (this.shouldDropLoot() && this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.dropFromLootTable(var0, var3);
            this.dropCustomDeathLoot(var0, var2, var3);
        }
        this.dropEquipment();
        this.dropExperience();
    }

    protected void dropEquipment() {
    }

    protected void dropExperience() {
        if (this.level instanceof WorldServer && (this.isAlwaysExperienceDropper() || this.lastHurtByPlayerTime > 0 && this.shouldDropExperience() && this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT))) {
            EntityExperienceOrb.award((WorldServer)this.level, this.position(), this.getExperienceReward(this.lastHurtByPlayer));
        }
    }

    protected void dropCustomDeathLoot(DamageSource var0, int var1, boolean var2) {
    }

    public MinecraftKey getLootTable() {
        return this.getType().getDefaultLootTable();
    }

    protected void dropFromLootTable(DamageSource var0, boolean var1) {
        MinecraftKey var2 = this.getLootTable();
        LootTable var3 = this.level.getServer().getLootTables().get(var2);
        LootTableInfo.Builder var4 = this.createLootContext(var1, var0);
        var3.getRandomItems(var4.create(LootContextParameterSets.ENTITY), this::spawnAtLocation);
    }

    protected LootTableInfo.Builder createLootContext(boolean var0, DamageSource var1) {
        LootTableInfo.Builder var2 = new LootTableInfo.Builder((WorldServer)this.level).withRandom(this.random).withParameter(LootContextParameters.THIS_ENTITY, this).withParameter(LootContextParameters.ORIGIN, this.position()).withParameter(LootContextParameters.DAMAGE_SOURCE, var1).withOptionalParameter(LootContextParameters.KILLER_ENTITY, var1.getEntity()).withOptionalParameter(LootContextParameters.DIRECT_KILLER_ENTITY, var1.getDirectEntity());
        if (var0 && this.lastHurtByPlayer != null) {
            var2 = var2.withParameter(LootContextParameters.LAST_DAMAGE_PLAYER, this.lastHurtByPlayer).withLuck(this.lastHurtByPlayer.getLuck());
        }
        return var2;
    }

    public void knockback(double var0, double var2, double var4) {
        if ((var0 *= 1.0 - this.getAttributeValue(GenericAttributes.KNOCKBACK_RESISTANCE)) <= 0.0) {
            return;
        }
        this.hasImpulse = true;
        Vec3D var6 = this.getDeltaMovement();
        Vec3D var7 = new Vec3D(var2, 0.0, var4).normalize().scale(var0);
        this.setDeltaMovement(var6.x / 2.0 - var7.x, this.onGround ? Math.min(0.4, var6.y / 2.0 + var0) : var6.y, var6.z / 2.0 - var7.z);
    }

    @Nullable
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.GENERIC_HURT;
    }

    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.GENERIC_DEATH;
    }

    private SoundEffect getFallDamageSound(int var0) {
        return var0 > 4 ? this.getFallSounds().big() : this.getFallSounds().small();
    }

    public a getFallSounds() {
        return new a(SoundEffects.GENERIC_SMALL_FALL, SoundEffects.GENERIC_BIG_FALL);
    }

    protected SoundEffect getDrinkingSound(ItemStack var0) {
        return var0.getDrinkingSound();
    }

    public SoundEffect getEatingSound(ItemStack var0) {
        return var0.getEatingSound();
    }

    @Override
    public void setOnGround(boolean var0) {
        super.setOnGround(var0);
        if (var0) {
            this.lastClimbablePos = Optional.empty();
        }
    }

    public Optional<BlockPosition> getLastClimbablePos() {
        return this.lastClimbablePos;
    }

    public boolean onClimbable() {
        if (this.isSpectator()) {
            return false;
        }
        BlockPosition var0 = this.blockPosition();
        IBlockData var1 = this.getFeetBlockState();
        if (var1.is(TagsBlock.CLIMBABLE)) {
            this.lastClimbablePos = Optional.of(var0);
            return true;
        }
        if (var1.getBlock() instanceof BlockTrapdoor && this.trapdoorUsableAsLadder(var0, var1)) {
            this.lastClimbablePos = Optional.of(var0);
            return true;
        }
        return false;
    }

    private boolean trapdoorUsableAsLadder(BlockPosition var0, IBlockData var1) {
        IBlockData var2;
        return var1.getValue(BlockTrapdoor.OPEN) != false && (var2 = this.level.getBlockState(var0.below())).is(Blocks.LADDER) && var2.getValue(BlockLadder.FACING) == var1.getValue(BlockTrapdoor.FACING);
    }

    @Override
    public boolean isAlive() {
        return !this.isRemoved() && this.getHealth() > 0.0f;
    }

    @Override
    public boolean causeFallDamage(float var0, float var1, DamageSource var2) {
        boolean var3 = super.causeFallDamage(var0, var1, var2);
        int var4 = this.calculateFallDamage(var0, var1);
        if (var4 > 0) {
            this.playSound(this.getFallDamageSound(var4), 1.0f, 1.0f);
            this.playBlockFallSound();
            this.hurt(var2, var4);
            return true;
        }
        return var3;
    }

    protected int calculateFallDamage(float var0, float var1) {
        MobEffect var2 = this.getEffect(MobEffects.JUMP);
        float var3 = var2 == null ? 0.0f : (float)(var2.getAmplifier() + 1);
        return MathHelper.ceil((var0 - 3.0f - var3) * var1);
    }

    protected void playBlockFallSound() {
        int var2;
        int var1;
        if (this.isSilent()) {
            return;
        }
        int var0 = MathHelper.floor(this.getX());
        IBlockData var3 = this.level.getBlockState(new BlockPosition(var0, var1 = MathHelper.floor(this.getY() - (double)0.2f), var2 = MathHelper.floor(this.getZ())));
        if (!var3.isAir()) {
            SoundEffectType var4 = var3.getSoundType();
            this.playSound(var4.getFallSound(), var4.getVolume() * 0.5f, var4.getPitch() * 0.75f);
        }
    }

    @Override
    public void animateHurt() {
        this.hurtTime = this.hurtDuration = 10;
        this.hurtDir = 0.0f;
    }

    public int getArmorValue() {
        return MathHelper.floor(this.getAttributeValue(GenericAttributes.ARMOR));
    }

    protected void hurtArmor(DamageSource var0, float var1) {
    }

    protected void hurtHelmet(DamageSource var0, float var1) {
    }

    protected void hurtCurrentlyUsedShield(float var0) {
    }

    protected float getDamageAfterArmorAbsorb(DamageSource var0, float var1) {
        if (!var0.isBypassArmor()) {
            this.hurtArmor(var0, var1);
            var1 = CombatMath.getDamageAfterAbsorb(var1, this.getArmorValue(), (float)this.getAttributeValue(GenericAttributes.ARMOR_TOUGHNESS));
        }
        return var1;
    }

    protected float getDamageAfterMagicAbsorb(DamageSource var0, float var1) {
        int var2;
        int var3;
        float var4;
        float var5;
        float var6;
        if (var0.isBypassMagic()) {
            return var1;
        }
        if (this.hasEffect(MobEffects.DAMAGE_RESISTANCE) && var0 != DamageSource.OUT_OF_WORLD && (var6 = (var5 = var1) - (var1 = Math.max((var4 = var1 * (float)(var3 = 25 - (var2 = (this.getEffect(MobEffects.DAMAGE_RESISTANCE).getAmplifier() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && var6 < 3.4028235E37f) {
            if (this instanceof EntityPlayer) {
                ((EntityPlayer)this).awardStat(StatisticList.DAMAGE_RESISTED, Math.round(var6 * 10.0f));
            } else if (var0.getEntity() instanceof EntityPlayer) {
                ((EntityPlayer)var0.getEntity()).awardStat(StatisticList.DAMAGE_DEALT_RESISTED, Math.round(var6 * 10.0f));
            }
        }
        if (var1 <= 0.0f) {
            return 0.0f;
        }
        var2 = EnchantmentManager.getDamageProtection(this.getArmorSlots(), var0);
        if (var2 > 0) {
            var1 = CombatMath.getDamageAfterMagicAbsorb(var1, var2);
        }
        return var1;
    }

    protected void actuallyHurt(DamageSource var0, float var1) {
        if (this.isInvulnerableTo(var0)) {
            return;
        }
        var1 = this.getDamageAfterArmorAbsorb(var0, var1);
        float var2 = var1 = this.getDamageAfterMagicAbsorb(var0, var1);
        var1 = Math.max(var1 - this.getAbsorptionAmount(), 0.0f);
        this.setAbsorptionAmount(this.getAbsorptionAmount() - (var2 - var1));
        float var3 = var2 - var1;
        if (var3 > 0.0f && var3 < 3.4028235E37f && var0.getEntity() instanceof EntityPlayer) {
            ((EntityPlayer)var0.getEntity()).awardStat(StatisticList.DAMAGE_DEALT_ABSORBED, Math.round(var3 * 10.0f));
        }
        if (var1 == 0.0f) {
            return;
        }
        float var4 = this.getHealth();
        this.setHealth(var4 - var1);
        this.getCombatTracker().recordDamage(var0, var4, var1);
        this.setAbsorptionAmount(this.getAbsorptionAmount() - var1);
        this.gameEvent(GameEvent.ENTITY_DAMAGED, var0.getEntity());
    }

    public CombatTracker getCombatTracker() {
        return this.combatTracker;
    }

    @Nullable
    public EntityLiving getKillCredit() {
        if (this.combatTracker.getKiller() != null) {
            return this.combatTracker.getKiller();
        }
        if (this.lastHurtByPlayer != null) {
            return this.lastHurtByPlayer;
        }
        if (this.lastHurtByMob != null) {
            return this.lastHurtByMob;
        }
        return null;
    }

    public final float getMaxHealth() {
        return (float)this.getAttributeValue(GenericAttributes.MAX_HEALTH);
    }

    public final int getArrowCount() {
        return this.entityData.get(DATA_ARROW_COUNT_ID);
    }

    public final void setArrowCount(int var0) {
        this.entityData.set(DATA_ARROW_COUNT_ID, var0);
    }

    public final int getStingerCount() {
        return this.entityData.get(DATA_STINGER_COUNT_ID);
    }

    public final void setStingerCount(int var0) {
        this.entityData.set(DATA_STINGER_COUNT_ID, var0);
    }

    private int getCurrentSwingDuration() {
        if (MobEffectUtil.hasDigSpeed(this)) {
            return 6 - (1 + MobEffectUtil.getDigSpeedAmplification(this));
        }
        if (this.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            return 6 + (1 + this.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) * 2;
        }
        return 6;
    }

    public void swing(EnumHand var0) {
        this.swing(var0, false);
    }

    public void swing(EnumHand var0, boolean var1) {
        if (!this.swinging || this.swingTime >= this.getCurrentSwingDuration() / 2 || this.swingTime < 0) {
            this.swingTime = -1;
            this.swinging = true;
            this.swingingArm = var0;
            if (this.level instanceof WorldServer) {
                PacketPlayOutAnimation var2 = new PacketPlayOutAnimation(this, var0 == EnumHand.MAIN_HAND ? 0 : 3);
                ChunkProviderServer var3 = ((WorldServer)this.level).getChunkSource();
                if (var1) {
                    var3.broadcastAndSend(this, var2);
                } else {
                    var3.broadcast(this, var2);
                }
            }
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        switch (var0) {
            case 2: 
            case 33: 
            case 36: 
            case 37: 
            case 44: 
            case 57: {
                DamageSource var1;
                SoundEffect var2;
                this.animationSpeed = 1.5f;
                this.invulnerableTime = 20;
                this.hurtTime = this.hurtDuration = 10;
                this.hurtDir = 0.0f;
                if (var0 == 33) {
                    this.playSound(SoundEffects.THORNS_HIT, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                }
                if ((var2 = this.getHurtSound(var1 = var0 == 37 ? DamageSource.ON_FIRE : (var0 == 36 ? DamageSource.DROWN : (var0 == 44 ? DamageSource.SWEET_BERRY_BUSH : (var0 == 57 ? DamageSource.FREEZE : DamageSource.GENERIC))))) != null) {
                    this.playSound(var2, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                }
                this.hurt(DamageSource.GENERIC, 0.0f);
                this.lastDamageSource = var1;
                this.lastDamageStamp = this.level.getGameTime();
                break;
            }
            case 3: {
                SoundEffect var1 = this.getDeathSound();
                if (var1 != null) {
                    this.playSound(var1, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.setHealth(0.0f);
                this.die(DamageSource.GENERIC);
                break;
            }
            case 30: {
                this.playSound(SoundEffects.SHIELD_BREAK, 0.8f, 0.8f + this.level.random.nextFloat() * 0.4f);
                break;
            }
            case 29: {
                this.playSound(SoundEffects.SHIELD_BLOCK, 1.0f, 0.8f + this.level.random.nextFloat() * 0.4f);
                break;
            }
            case 46: {
                int var1 = 128;
                for (int var2 = 0; var2 < 128; ++var2) {
                    double var3 = (double)var2 / 127.0;
                    float var5 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float var6 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float var7 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    double var8 = MathHelper.lerp(var3, this.xo, this.getX()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    double var10 = MathHelper.lerp(var3, this.yo, this.getY()) + this.random.nextDouble() * (double)this.getBbHeight();
                    double var12 = MathHelper.lerp(var3, this.zo, this.getZ()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    this.level.addParticle(Particles.PORTAL, var8, var10, var12, var5, var6, var7);
                }
                break;
            }
            case 47: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.MAINHAND));
                break;
            }
            case 48: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.OFFHAND));
                break;
            }
            case 49: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.HEAD));
                break;
            }
            case 50: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.CHEST));
                break;
            }
            case 51: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.LEGS));
                break;
            }
            case 52: {
                this.breakItem(this.getItemBySlot(EnumItemSlot.FEET));
                break;
            }
            case 54: {
                BlockHoney.showJumpParticles(this);
                break;
            }
            case 55: {
                this.swapHandItems();
                break;
            }
            case 60: {
                this.makePoofParticles();
                break;
            }
            default: {
                super.handleEntityEvent(var0);
            }
        }
    }

    private void makePoofParticles() {
        for (int var0 = 0; var0 < 20; ++var0) {
            double var1 = this.random.nextGaussian() * 0.02;
            double var3 = this.random.nextGaussian() * 0.02;
            double var5 = this.random.nextGaussian() * 0.02;
            this.level.addParticle(Particles.POOF, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), var1, var3, var5);
        }
    }

    private void swapHandItems() {
        ItemStack var0 = this.getItemBySlot(EnumItemSlot.OFFHAND);
        this.setItemSlot(EnumItemSlot.OFFHAND, this.getItemBySlot(EnumItemSlot.MAINHAND));
        this.setItemSlot(EnumItemSlot.MAINHAND, var0);
    }

    @Override
    protected void outOfWorld() {
        this.hurt(DamageSource.OUT_OF_WORLD, 4.0f);
    }

    protected void updateSwingTime() {
        int var0 = this.getCurrentSwingDuration();
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime >= var0) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
        this.attackAnim = (float)this.swingTime / (float)var0;
    }

    @Nullable
    public AttributeModifiable getAttribute(AttributeBase var0) {
        return this.getAttributes().getInstance(var0);
    }

    public double getAttributeValue(AttributeBase var0) {
        return this.getAttributes().getValue(var0);
    }

    public double getAttributeBaseValue(AttributeBase var0) {
        return this.getAttributes().getBaseValue(var0);
    }

    public AttributeMapBase getAttributes() {
        return this.attributes;
    }

    public EnumMonsterType getMobType() {
        return EnumMonsterType.UNDEFINED;
    }

    public ItemStack getMainHandItem() {
        return this.getItemBySlot(EnumItemSlot.MAINHAND);
    }

    public ItemStack getOffhandItem() {
        return this.getItemBySlot(EnumItemSlot.OFFHAND);
    }

    public boolean isHolding(Item var0) {
        return this.isHolding((ItemStack var1) -> var1.is(var0));
    }

    public boolean isHolding(Predicate<ItemStack> var0) {
        return var0.test(this.getMainHandItem()) || var0.test(this.getOffhandItem());
    }

    public ItemStack getItemInHand(EnumHand var0) {
        if (var0 == EnumHand.MAIN_HAND) {
            return this.getItemBySlot(EnumItemSlot.MAINHAND);
        }
        if (var0 == EnumHand.OFF_HAND) {
            return this.getItemBySlot(EnumItemSlot.OFFHAND);
        }
        throw new IllegalArgumentException("Invalid hand " + var0);
    }

    public void setItemInHand(EnumHand var0, ItemStack var1) {
        if (var0 == EnumHand.MAIN_HAND) {
            this.setItemSlot(EnumItemSlot.MAINHAND, var1);
        } else if (var0 == EnumHand.OFF_HAND) {
            this.setItemSlot(EnumItemSlot.OFFHAND, var1);
        } else {
            throw new IllegalArgumentException("Invalid hand " + var0);
        }
    }

    public boolean hasItemInSlot(EnumItemSlot var0) {
        return !this.getItemBySlot(var0).isEmpty();
    }

    @Override
    public abstract Iterable<ItemStack> getArmorSlots();

    public abstract ItemStack getItemBySlot(EnumItemSlot var1);

    @Override
    public abstract void setItemSlot(EnumItemSlot var1, ItemStack var2);

    protected void verifyEquippedItem(ItemStack var0) {
        NBTTagCompound var1 = var0.getTag();
        if (var1 != null) {
            var0.getItem().verifyTagAfterLoad(var1);
        }
    }

    public float getArmorCoverPercentage() {
        Iterable<ItemStack> var0 = this.getArmorSlots();
        int var1 = 0;
        int var2 = 0;
        for (ItemStack var4 : var0) {
            if (!var4.isEmpty()) {
                ++var2;
            }
            ++var1;
        }
        return var1 > 0 ? (float)var2 / (float)var1 : 0.0f;
    }

    @Override
    public void setSprinting(boolean var0) {
        super.setSprinting(var0);
        AttributeModifiable var1 = this.getAttribute(GenericAttributes.MOVEMENT_SPEED);
        if (var1.getModifier(SPEED_MODIFIER_SPRINTING_UUID) != null) {
            var1.removeModifier(SPEED_MODIFIER_SPRINTING);
        }
        if (var0) {
            var1.addTransientModifier(SPEED_MODIFIER_SPRINTING);
        }
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        if (this.isBaby()) {
            return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f;
        }
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    protected boolean isImmobile() {
        return this.isDeadOrDying();
    }

    @Override
    public void push(Entity var0) {
        if (!this.isSleeping()) {
            super.push(var0);
        }
    }

    private void dismountVehicle(Entity var0) {
        Vec3D var1;
        if (this.isRemoved()) {
            var1 = this.position();
        } else if (var0.isRemoved() || this.level.getBlockState(var0.blockPosition()).is(TagsBlock.PORTALS)) {
            double var2 = Math.max(this.getY(), var0.getY());
            var1 = new Vec3D(this.getX(), var2, this.getZ());
        } else {
            var1 = var0.getDismountLocationForPassenger(this);
        }
        this.dismountTo(var1.x, var1.y, var1.z);
    }

    @Override
    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    protected float getJumpPower() {
        return 0.42f * this.getBlockJumpFactor();
    }

    public double getJumpBoostPower() {
        return this.hasEffect(MobEffects.JUMP) ? (double)(0.1f * (float)(this.getEffect(MobEffects.JUMP).getAmplifier() + 1)) : 0.0;
    }

    protected void jumpFromGround() {
        double var0 = (double)this.getJumpPower() + this.getJumpBoostPower();
        Vec3D var2 = this.getDeltaMovement();
        this.setDeltaMovement(var2.x, var0, var2.z);
        if (this.isSprinting()) {
            float var3 = this.getYRot() * ((float)Math.PI / 180);
            this.setDeltaMovement(this.getDeltaMovement().add(-MathHelper.sin(var3) * 0.2f, 0.0, MathHelper.cos(var3) * 0.2f));
        }
        this.hasImpulse = true;
    }

    protected void goDownInWater() {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04f, 0.0));
    }

    protected void jumpInLiquid(TagKey<FluidType> var0) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.04f, 0.0));
    }

    protected float getWaterSlowDown() {
        return 0.8f;
    }

    public boolean canStandOnFluid(Fluid var0) {
        return false;
    }

    public void travel(Vec3D var0) {
        if (this.isEffectiveAi() || this.isControlledByLocalInstance()) {
            boolean var3;
            double var1 = 0.08;
            boolean bl = var3 = this.getDeltaMovement().y <= 0.0;
            if (var3 && this.hasEffect(MobEffects.SLOW_FALLING)) {
                var1 = 0.01;
                this.resetFallDistance();
            }
            Fluid var4 = this.level.getFluidState(this.blockPosition());
            if (this.isInWater() && this.isAffectedByFluids() && !this.canStandOnFluid(var4)) {
                double var5 = this.getY();
                float var7 = this.isSprinting() ? 0.9f : this.getWaterSlowDown();
                float var8 = 0.02f;
                float var9 = EnchantmentManager.getDepthStrider(this);
                if (var9 > 3.0f) {
                    var9 = 3.0f;
                }
                if (!this.onGround) {
                    var9 *= 0.5f;
                }
                if (var9 > 0.0f) {
                    var7 += (0.54600006f - var7) * var9 / 3.0f;
                    var8 += (this.getSpeed() - var8) * var9 / 3.0f;
                }
                if (this.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                    var7 = 0.96f;
                }
                this.moveRelative(var8, var0);
                this.move(EnumMoveType.SELF, this.getDeltaMovement());
                Vec3D var10 = this.getDeltaMovement();
                if (this.horizontalCollision && this.onClimbable()) {
                    var10 = new Vec3D(var10.x, 0.2, var10.z);
                }
                this.setDeltaMovement(var10.multiply(var7, 0.8f, var7));
                Vec3D var11 = this.getFluidFallingAdjustedMovement(var1, var3, this.getDeltaMovement());
                this.setDeltaMovement(var11);
                if (this.horizontalCollision && this.isFree(var11.x, var11.y + (double)0.6f - this.getY() + var5, var11.z)) {
                    this.setDeltaMovement(var11.x, 0.3f, var11.z);
                }
            } else if (this.isInLava() && this.isAffectedByFluids() && !this.canStandOnFluid(var4)) {
                Vec3D var7;
                double var5 = this.getY();
                this.moveRelative(0.02f, var0);
                this.move(EnumMoveType.SELF, this.getDeltaMovement());
                if (this.getFluidHeight(TagsFluid.LAVA) <= this.getFluidJumpThreshold()) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.8f, 0.5));
                    var7 = this.getFluidFallingAdjustedMovement(var1, var3, this.getDeltaMovement());
                    this.setDeltaMovement(var7);
                } else {
                    this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
                }
                if (!this.isNoGravity()) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -var1 / 4.0, 0.0));
                }
                var7 = this.getDeltaMovement();
                if (this.horizontalCollision && this.isFree(var7.x, var7.y + (double)0.6f - this.getY() + var5, var7.z)) {
                    this.setDeltaMovement(var7.x, 0.3f, var7.z);
                }
            } else if (this.isFallFlying()) {
                double var18;
                float var20;
                double var16;
                Vec3D var5 = this.getDeltaMovement();
                if (var5.y > -0.5) {
                    this.fallDistance = 1.0f;
                }
                Vec3D var6 = this.getLookAngle();
                float var7 = this.getXRot() * ((float)Math.PI / 180);
                double var8 = Math.sqrt(var6.x * var6.x + var6.z * var6.z);
                double var10 = var5.horizontalDistance();
                double var12 = var6.length();
                double var14 = Math.cos(var7);
                var14 = var14 * var14 * Math.min(1.0, var12 / 0.4);
                var5 = this.getDeltaMovement().add(0.0, var1 * (-1.0 + var14 * 0.75), 0.0);
                if (var5.y < 0.0 && var8 > 0.0) {
                    var16 = var5.y * -0.1 * var14;
                    var5 = var5.add(var6.x * var16 / var8, var16, var6.z * var16 / var8);
                }
                if (var7 < 0.0f && var8 > 0.0) {
                    var16 = var10 * (double)(-MathHelper.sin(var7)) * 0.04;
                    var5 = var5.add(-var6.x * var16 / var8, var16 * 3.2, -var6.z * var16 / var8);
                }
                if (var8 > 0.0) {
                    var5 = var5.add((var6.x / var8 * var10 - var5.x) * 0.1, 0.0, (var6.z / var8 * var10 - var5.z) * 0.1);
                }
                this.setDeltaMovement(var5.multiply(0.99f, 0.98f, 0.99f));
                this.move(EnumMoveType.SELF, this.getDeltaMovement());
                if (this.horizontalCollision && !this.level.isClientSide && (var20 = (float)((var18 = var10 - (var16 = this.getDeltaMovement().horizontalDistance())) * 10.0 - 3.0)) > 0.0f) {
                    this.playSound(this.getFallDamageSound((int)var20), 1.0f, 1.0f);
                    this.hurt(DamageSource.FLY_INTO_WALL, var20);
                }
                if (this.onGround && !this.level.isClientSide) {
                    this.setSharedFlag(7, false);
                }
            } else {
                BlockPosition var5 = this.getBlockPosBelowThatAffectsMyMovement();
                float var6 = this.level.getBlockState(var5).getBlock().getFriction();
                float var7 = this.onGround ? var6 * 0.91f : 0.91f;
                Vec3D var8 = this.handleRelativeFrictionAndCalculateMovement(var0, var6);
                double var9 = var8.y;
                if (this.hasEffect(MobEffects.LEVITATION)) {
                    var9 += (0.05 * (double)(this.getEffect(MobEffects.LEVITATION).getAmplifier() + 1) - var8.y) * 0.2;
                    this.resetFallDistance();
                } else if (!this.level.isClientSide || this.level.hasChunkAt(var5)) {
                    if (!this.isNoGravity()) {
                        var9 -= var1;
                    }
                } else {
                    var9 = this.getY() > (double)this.level.getMinBuildHeight() ? -0.1 : 0.0;
                }
                if (this.shouldDiscardFriction()) {
                    this.setDeltaMovement(var8.x, var9, var8.z);
                } else {
                    this.setDeltaMovement(var8.x * (double)var7, var9 * (double)0.98f, var8.z * (double)var7);
                }
            }
        }
        this.calculateEntityAnimation(this, this instanceof EntityBird);
    }

    public void calculateEntityAnimation(EntityLiving var0, boolean var1) {
        double var6;
        double var4;
        var0.animationSpeedOld = var0.animationSpeed;
        double var2 = var0.getX() - var0.xo;
        float var8 = (float)Math.sqrt(var2 * var2 + (var4 = var1 ? var0.getY() - var0.yo : 0.0) * var4 + (var6 = var0.getZ() - var0.zo) * var6) * 4.0f;
        if (var8 > 1.0f) {
            var8 = 1.0f;
        }
        var0.animationSpeed += (var8 - var0.animationSpeed) * 0.4f;
        var0.animationPosition += var0.animationSpeed;
    }

    public Vec3D handleRelativeFrictionAndCalculateMovement(Vec3D var0, float var1) {
        this.moveRelative(this.getFrictionInfluencedSpeed(var1), var0);
        this.setDeltaMovement(this.handleOnClimbable(this.getDeltaMovement()));
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        Vec3D var2 = this.getDeltaMovement();
        if ((this.horizontalCollision || this.jumping) && (this.onClimbable() || this.getFeetBlockState().is(Blocks.POWDER_SNOW) && PowderSnowBlock.canEntityWalkOnPowderSnow(this))) {
            var2 = new Vec3D(var2.x, 0.2, var2.z);
        }
        return var2;
    }

    public Vec3D getFluidFallingAdjustedMovement(double var0, boolean var2, Vec3D var3) {
        if (!this.isNoGravity() && !this.isSprinting()) {
            double var4 = var2 && Math.abs(var3.y - 0.005) >= 0.003 && Math.abs(var3.y - var0 / 16.0) < 0.003 ? -0.003 : var3.y - var0 / 16.0;
            return new Vec3D(var3.x, var4, var3.z);
        }
        return var3;
    }

    private Vec3D handleOnClimbable(Vec3D var0) {
        if (this.onClimbable()) {
            this.resetFallDistance();
            float var1 = 0.15f;
            double var2 = MathHelper.clamp(var0.x, (double)-0.15f, (double)0.15f);
            double var4 = MathHelper.clamp(var0.z, (double)-0.15f, (double)0.15f);
            double var6 = Math.max(var0.y, (double)-0.15f);
            if (var6 < 0.0 && !this.getFeetBlockState().is(Blocks.SCAFFOLDING) && this.isSuppressingSlidingDownLadder() && this instanceof EntityHuman) {
                var6 = 0.0;
            }
            var0 = new Vec3D(var2, var6, var4);
        }
        return var0;
    }

    private float getFrictionInfluencedSpeed(float var0) {
        if (this.onGround) {
            return this.getSpeed() * (0.21600002f / (var0 * var0 * var0));
        }
        return this.flyingSpeed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float var0) {
        this.speed = var0;
    }

    public boolean doHurtTarget(Entity var0) {
        this.setLastHurtMob(var0);
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        this.updatingUsingItem();
        this.updateSwimAmount();
        if (!this.level.isClientSide) {
            int var1;
            int var0 = this.getArrowCount();
            if (var0 > 0) {
                if (this.removeArrowTime <= 0) {
                    this.removeArrowTime = 20 * (30 - var0);
                }
                --this.removeArrowTime;
                if (this.removeArrowTime <= 0) {
                    this.setArrowCount(var0 - 1);
                }
            }
            if ((var1 = this.getStingerCount()) > 0) {
                if (this.removeStingerTime <= 0) {
                    this.removeStingerTime = 20 * (30 - var1);
                }
                --this.removeStingerTime;
                if (this.removeStingerTime <= 0) {
                    this.setStingerCount(var1 - 1);
                }
            }
            this.detectEquipmentUpdates();
            if (this.tickCount % 20 == 0) {
                this.getCombatTracker().recheckStatus();
            }
            if (this.isSleeping() && !this.checkBedExists()) {
                this.stopSleeping();
            }
        }
        this.aiStep();
        double var0 = this.getX() - this.xo;
        double var2 = this.getZ() - this.zo;
        float var4 = (float)(var0 * var0 + var2 * var2);
        float var5 = this.yBodyRot;
        float var6 = 0.0f;
        this.oRun = this.run;
        float var7 = 0.0f;
        if (var4 > 0.0025000002f) {
            var7 = 1.0f;
            var6 = (float)Math.sqrt(var4) * 3.0f;
            float var8 = (float)MathHelper.atan2(var2, var0) * 57.295776f - 90.0f;
            float var9 = MathHelper.abs(MathHelper.wrapDegrees(this.getYRot()) - var8);
            var5 = 95.0f < var9 && var9 < 265.0f ? var8 - 180.0f : var8;
        }
        if (this.attackAnim > 0.0f) {
            var5 = this.getYRot();
        }
        if (!this.onGround) {
            var7 = 0.0f;
        }
        this.run += (var7 - this.run) * 0.3f;
        this.level.getProfiler().push("headTurn");
        var6 = this.tickHeadTurn(var5, var6);
        this.level.getProfiler().pop();
        this.level.getProfiler().push("rangeChecks");
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO < -180.0f) {
            this.yBodyRotO -= 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO >= 180.0f) {
            this.yBodyRotO += 360.0f;
        }
        while (this.getXRot() - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.getXRot() - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yHeadRot - this.yHeadRotO < -180.0f) {
            this.yHeadRotO -= 360.0f;
        }
        while (this.yHeadRot - this.yHeadRotO >= 180.0f) {
            this.yHeadRotO += 360.0f;
        }
        this.level.getProfiler().pop();
        this.animStep += var6;
        this.fallFlyTicks = this.isFallFlying() ? ++this.fallFlyTicks : 0;
        if (this.isSleeping()) {
            this.setXRot(0.0f);
        }
    }

    public void detectEquipmentUpdates() {
        Map<EnumItemSlot, ItemStack> var0 = this.collectEquipmentChanges();
        if (var0 != null) {
            this.handleHandSwap(var0);
            if (!var0.isEmpty()) {
                this.handleEquipmentChanges(var0);
            }
        }
    }

    @Nullable
    private Map<EnumItemSlot, ItemStack> collectEquipmentChanges() {
        EnumMap var0 = null;
        block4: for (EnumItemSlot var4 : EnumItemSlot.values()) {
            ItemStack var5;
            switch (var4.getType()) {
                case HAND: {
                    var5 = this.getLastHandItem(var4);
                    break;
                }
                case ARMOR: {
                    var5 = this.getLastArmorItem(var4);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            ItemStack var6 = this.getItemBySlot(var4);
            if (ItemStack.matches(var6, var5)) continue;
            if (var0 == null) {
                var0 = Maps.newEnumMap(EnumItemSlot.class);
            }
            var0.put(var4, var6);
            if (!var5.isEmpty()) {
                this.getAttributes().removeAttributeModifiers(var5.getAttributeModifiers(var4));
            }
            if (var6.isEmpty()) continue;
            this.getAttributes().addTransientAttributeModifiers(var6.getAttributeModifiers(var4));
        }
        return var0;
    }

    private void handleHandSwap(Map<EnumItemSlot, ItemStack> var0) {
        ItemStack var1 = var0.get((Object)EnumItemSlot.MAINHAND);
        ItemStack var2 = var0.get((Object)EnumItemSlot.OFFHAND);
        if (var1 != null && var2 != null && ItemStack.matches(var1, this.getLastHandItem(EnumItemSlot.OFFHAND)) && ItemStack.matches(var2, this.getLastHandItem(EnumItemSlot.MAINHAND))) {
            ((WorldServer)this.level).getChunkSource().broadcast(this, new PacketPlayOutEntityStatus(this, 55));
            var0.remove((Object)EnumItemSlot.MAINHAND);
            var0.remove((Object)EnumItemSlot.OFFHAND);
            this.setLastHandItem(EnumItemSlot.MAINHAND, var1.copy());
            this.setLastHandItem(EnumItemSlot.OFFHAND, var2.copy());
        }
    }

    private void handleEquipmentChanges(Map<EnumItemSlot, ItemStack> var0) {
        ArrayList var12 = Lists.newArrayListWithCapacity((int)var0.size());
        var0.forEach((var1, var2) -> {
            ItemStack var3 = var2.copy();
            var12.add(Pair.of((Object)var1, (Object)var3));
            switch (var1.getType()) {
                case HAND: {
                    this.setLastHandItem((EnumItemSlot)((Object)var1), var3);
                    break;
                }
                case ARMOR: {
                    this.setLastArmorItem((EnumItemSlot)((Object)var1), var3);
                }
            }
        });
        ((WorldServer)this.level).getChunkSource().broadcast(this, new PacketPlayOutEntityEquipment(this.getId(), var12));
    }

    private ItemStack getLastArmorItem(EnumItemSlot var0) {
        return this.lastArmorItemStacks.get(var0.getIndex());
    }

    private void setLastArmorItem(EnumItemSlot var0, ItemStack var1) {
        this.lastArmorItemStacks.set(var0.getIndex(), var1);
    }

    private ItemStack getLastHandItem(EnumItemSlot var0) {
        return this.lastHandItemStacks.get(var0.getIndex());
    }

    private void setLastHandItem(EnumItemSlot var0, ItemStack var1) {
        this.lastHandItemStacks.set(var0.getIndex(), var1);
    }

    protected float tickHeadTurn(float var0, float var1) {
        boolean var4;
        float var2 = MathHelper.wrapDegrees(var0 - this.yBodyRot);
        this.yBodyRot += var2 * 0.3f;
        float var3 = MathHelper.wrapDegrees(this.getYRot() - this.yBodyRot);
        boolean bl = var4 = var3 < -90.0f || var3 >= 90.0f;
        if (var3 < -75.0f) {
            var3 = -75.0f;
        }
        if (var3 >= 75.0f) {
            var3 = 75.0f;
        }
        this.yBodyRot = this.getYRot() - var3;
        if (var3 * var3 > 2500.0f) {
            this.yBodyRot += var3 * 0.2f;
        }
        if (var4) {
            var1 *= -1.0f;
        }
        return var1;
    }

    public void aiStep() {
        int var9;
        if (this.noJumpDelay > 0) {
            --this.noJumpDelay;
        }
        if (this.isControlledByLocalInstance()) {
            this.lerpSteps = 0;
            this.setPacketCoordinates(this.getX(), this.getY(), this.getZ());
        }
        if (this.lerpSteps > 0) {
            double var0 = this.getX() + (this.lerpX - this.getX()) / (double)this.lerpSteps;
            double var2 = this.getY() + (this.lerpY - this.getY()) / (double)this.lerpSteps;
            double var4 = this.getZ() + (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
            double var6 = MathHelper.wrapDegrees(this.lerpYRot - (double)this.getYRot());
            this.setYRot(this.getYRot() + (float)var6 / (float)this.lerpSteps);
            this.setXRot(this.getXRot() + (float)(this.lerpXRot - (double)this.getXRot()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.setPos(var0, var2, var4);
            this.setRot(this.getYRot(), this.getXRot());
        } else if (!this.isEffectiveAi()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
        if (this.lerpHeadSteps > 0) {
            this.yHeadRot += (float)MathHelper.wrapDegrees(this.lyHeadRot - (double)this.yHeadRot) / (float)this.lerpHeadSteps;
            --this.lerpHeadSteps;
        }
        Vec3D var0 = this.getDeltaMovement();
        double var1 = var0.x;
        double var3 = var0.y;
        double var5 = var0.z;
        if (Math.abs(var0.x) < 0.003) {
            var1 = 0.0;
        }
        if (Math.abs(var0.y) < 0.003) {
            var3 = 0.0;
        }
        if (Math.abs(var0.z) < 0.003) {
            var5 = 0.0;
        }
        this.setDeltaMovement(var1, var3, var5);
        this.level.getProfiler().push("ai");
        if (this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        } else if (this.isEffectiveAi()) {
            this.level.getProfiler().push("newAi");
            this.serverAiStep();
            this.level.getProfiler().pop();
        }
        this.level.getProfiler().pop();
        this.level.getProfiler().push("jump");
        if (this.jumping && this.isAffectedByFluids()) {
            double var7 = this.isInLava() ? this.getFluidHeight(TagsFluid.LAVA) : this.getFluidHeight(TagsFluid.WATER);
            var9 = this.isInWater() && var7 > 0.0 ? 1 : 0;
            double var10 = this.getFluidJumpThreshold();
            if (var9 != 0 && (!this.onGround || var7 > var10)) {
                this.jumpInLiquid(TagsFluid.WATER);
            } else if (this.isInLava() && (!this.onGround || var7 > var10)) {
                this.jumpInLiquid(TagsFluid.LAVA);
            } else if ((this.onGround || var9 != 0 && var7 <= var10) && this.noJumpDelay == 0) {
                this.jumpFromGround();
                this.noJumpDelay = 10;
            }
        } else {
            this.noJumpDelay = 0;
        }
        this.level.getProfiler().pop();
        this.level.getProfiler().push("travel");
        this.xxa *= 0.98f;
        this.zza *= 0.98f;
        this.updateFallFlying();
        AxisAlignedBB var7 = this.getBoundingBox();
        this.travel(new Vec3D(this.xxa, this.yya, this.zza));
        this.level.getProfiler().pop();
        this.level.getProfiler().push("freezing");
        boolean var8 = this.getType().is(TagsEntity.FREEZE_HURTS_EXTRA_TYPES);
        if (!this.level.isClientSide && !this.isDeadOrDying()) {
            var9 = this.getTicksFrozen();
            if (this.isInPowderSnow && this.canFreeze()) {
                this.setTicksFrozen(Math.min(this.getTicksRequiredToFreeze(), var9 + 1));
            } else {
                this.setTicksFrozen(Math.max(0, var9 - 2));
            }
        }
        this.removeFrost();
        this.tryAddFrost();
        if (!this.level.isClientSide && this.tickCount % 40 == 0 && this.isFullyFrozen() && this.canFreeze()) {
            var9 = var8 ? 5 : 1;
            this.hurt(DamageSource.FREEZE, var9);
        }
        this.level.getProfiler().pop();
        this.level.getProfiler().push("push");
        if (this.autoSpinAttackTicks > 0) {
            --this.autoSpinAttackTicks;
            this.checkAutoSpinAttack(var7, this.getBoundingBox());
        }
        this.pushEntities();
        this.level.getProfiler().pop();
        if (!this.level.isClientSide && this.isSensitiveToWater() && this.isInWaterRainOrBubble()) {
            this.hurt(DamageSource.DROWN, 1.0f);
        }
    }

    public boolean isSensitiveToWater() {
        return false;
    }

    private void updateFallFlying() {
        boolean var02 = this.getSharedFlag(7);
        if (var02 && !this.onGround && !this.isPassenger() && !this.hasEffect(MobEffects.LEVITATION)) {
            ItemStack var1 = this.getItemBySlot(EnumItemSlot.CHEST);
            if (var1.is(Items.ELYTRA) && ItemElytra.isFlyEnabled(var1)) {
                var02 = true;
                int var2 = this.fallFlyTicks + 1;
                if (!this.level.isClientSide && var2 % 10 == 0) {
                    int var3 = var2 / 10;
                    if (var3 % 2 == 0) {
                        var1.hurtAndBreak(1, this, var0 -> var0.broadcastBreakEvent(EnumItemSlot.CHEST));
                    }
                    this.gameEvent(GameEvent.ELYTRA_FREE_FALL);
                }
            } else {
                var02 = false;
            }
        } else {
            var02 = false;
        }
        if (!this.level.isClientSide) {
            this.setSharedFlag(7, var02);
        }
    }

    protected void serverAiStep() {
    }

    protected void pushEntities() {
        List<Entity> var0 = this.level.getEntities(this, this.getBoundingBox(), IEntitySelector.pushableBy(this));
        if (!var0.isEmpty()) {
            int var2;
            int var1 = this.level.getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
            if (var1 > 0 && var0.size() > var1 - 1 && this.random.nextInt(4) == 0) {
                var2 = 0;
                for (int var3 = 0; var3 < var0.size(); ++var3) {
                    if (var0.get(var3).isPassenger()) continue;
                    ++var2;
                }
                if (var2 > var1 - 1) {
                    this.hurt(DamageSource.CRAMMING, 6.0f);
                }
            }
            for (var2 = 0; var2 < var0.size(); ++var2) {
                Entity var3 = var0.get(var2);
                this.doPush(var3);
            }
        }
    }

    protected void checkAutoSpinAttack(AxisAlignedBB var0, AxisAlignedBB var1) {
        AxisAlignedBB var2 = var0.minmax(var1);
        List<Entity> var3 = this.level.getEntities(this, var2);
        if (!var3.isEmpty()) {
            for (int var4 = 0; var4 < var3.size(); ++var4) {
                Entity var5 = var3.get(var4);
                if (!(var5 instanceof EntityLiving)) continue;
                this.doAutoAttackOnTouch((EntityLiving)var5);
                this.autoSpinAttackTicks = 0;
                this.setDeltaMovement(this.getDeltaMovement().scale(-0.2));
                break;
            }
        } else if (this.horizontalCollision) {
            this.autoSpinAttackTicks = 0;
        }
        if (!this.level.isClientSide && this.autoSpinAttackTicks <= 0) {
            this.setLivingEntityFlag(4, false);
        }
    }

    protected void doPush(Entity var0) {
        var0.push(this);
    }

    protected void doAutoAttackOnTouch(EntityLiving var0) {
    }

    public boolean isAutoSpinAttack() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 4) != 0;
    }

    @Override
    public void stopRiding() {
        Entity var0 = this.getVehicle();
        super.stopRiding();
        if (var0 != null && var0 != this.getVehicle() && !this.level.isClientSide) {
            this.dismountVehicle(var0);
        }
    }

    @Override
    public void rideTick() {
        super.rideTick();
        this.oRun = this.run;
        this.run = 0.0f;
        this.resetFallDistance();
    }

    @Override
    public void lerpTo(double var0, double var2, double var4, float var6, float var7, int var8, boolean var9) {
        this.lerpX = var0;
        this.lerpY = var2;
        this.lerpZ = var4;
        this.lerpYRot = var6;
        this.lerpXRot = var7;
        this.lerpSteps = var8;
    }

    @Override
    public void lerpHeadTo(float var0, int var1) {
        this.lyHeadRot = var0;
        this.lerpHeadSteps = var1;
    }

    public void setJumping(boolean var0) {
        this.jumping = var0;
    }

    public void onItemPickup(EntityItem var0) {
        EntityHuman var1;
        EntityHuman entityHuman = var1 = var0.getThrower() != null ? this.level.getPlayerByUUID(var0.getThrower()) : null;
        if (var1 instanceof EntityPlayer) {
            CriterionTriggers.ITEM_PICKED_UP_BY_ENTITY.trigger((EntityPlayer)var1, var0.getItem(), this);
        }
    }

    public void take(Entity var0, int var1) {
        if (!var0.isRemoved() && !this.level.isClientSide && (var0 instanceof EntityItem || var0 instanceof EntityArrow || var0 instanceof EntityExperienceOrb)) {
            ((WorldServer)this.level).getChunkSource().broadcast(var0, new PacketPlayOutCollect(var0.getId(), this.getId(), var1));
        }
    }

    public boolean hasLineOfSight(Entity var0) {
        if (var0.level != this.level) {
            return false;
        }
        Vec3D var1 = new Vec3D(this.getX(), this.getEyeY(), this.getZ());
        Vec3D var2 = new Vec3D(var0.getX(), var0.getEyeY(), var0.getZ());
        if (var2.distanceTo(var1) > 128.0) {
            return false;
        }
        return this.level.clip(new RayTrace(var1, var2, RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, this)).getType() == MovingObjectPosition.EnumMovingObjectType.MISS;
    }

    @Override
    public float getViewYRot(float var0) {
        if (var0 == 1.0f) {
            return this.yHeadRot;
        }
        return MathHelper.lerp(var0, this.yHeadRotO, this.yHeadRot);
    }

    public float getAttackAnim(float var0) {
        float var1 = this.attackAnim - this.oAttackAnim;
        if (var1 < 0.0f) {
            var1 += 1.0f;
        }
        return this.oAttackAnim + var1 * var0;
    }

    public boolean isEffectiveAi() {
        return !this.level.isClientSide;
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    @Override
    public boolean isPushable() {
        return this.isAlive() && !this.isSpectator() && !this.onClimbable();
    }

    @Override
    public float getYHeadRot() {
        return this.yHeadRot;
    }

    @Override
    public void setYHeadRot(float var0) {
        this.yHeadRot = var0;
    }

    @Override
    public void setYBodyRot(float var0) {
        this.yBodyRot = var0;
    }

    @Override
    protected Vec3D getRelativePortalPosition(EnumDirection.EnumAxis var0, BlockUtil.Rectangle var1) {
        return EntityLiving.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(var0, var1));
    }

    public static Vec3D resetForwardDirectionOfRelativePortalPosition(Vec3D var0) {
        return new Vec3D(var0.x, var0.y, 0.0);
    }

    public float getAbsorptionAmount() {
        return this.absorptionAmount;
    }

    public void setAbsorptionAmount(float var0) {
        if (var0 < 0.0f) {
            var0 = 0.0f;
        }
        this.absorptionAmount = var0;
    }

    public void onEnterCombat() {
    }

    public void onLeaveCombat() {
    }

    protected void updateEffectVisibility() {
        this.effectsDirty = true;
    }

    public abstract EnumMainHand getMainArm();

    public boolean isUsingItem() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 1) > 0;
    }

    public EnumHand getUsedItemHand() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 2) > 0 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
    }

    private void updatingUsingItem() {
        if (this.isUsingItem()) {
            if (ItemStack.isSameIgnoreDurability(this.getItemInHand(this.getUsedItemHand()), this.useItem)) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                this.updateUsingItem(this.useItem);
            } else {
                this.stopUsingItem();
            }
        }
    }

    protected void updateUsingItem(ItemStack var0) {
        var0.onUseTick(this.level, this, this.getUseItemRemainingTicks());
        if (this.shouldTriggerItemUseEffects()) {
            this.triggerItemUseEffects(var0, 5);
        }
        if (--this.useItemRemaining == 0 && !this.level.isClientSide && !var0.useOnRelease()) {
            this.completeUsingItem();
        }
    }

    private boolean shouldTriggerItemUseEffects() {
        int var0 = this.getUseItemRemainingTicks();
        FoodInfo var1 = this.useItem.getItem().getFoodProperties();
        boolean var2 = var1 != null && var1.isFastFood();
        return (var2 |= var0 <= this.useItem.getUseDuration() - 7) && var0 % 4 == 0;
    }

    private void updateSwimAmount() {
        this.swimAmountO = this.swimAmount;
        this.swimAmount = this.isVisuallySwimming() ? Math.min(1.0f, this.swimAmount + 0.09f) : Math.max(0.0f, this.swimAmount - 0.09f);
    }

    protected void setLivingEntityFlag(int var0, boolean var1) {
        int var2 = this.entityData.get(DATA_LIVING_ENTITY_FLAGS).byteValue();
        var2 = var1 ? (var2 |= var0) : (var2 &= ~var0);
        this.entityData.set(DATA_LIVING_ENTITY_FLAGS, (byte)var2);
    }

    public void startUsingItem(EnumHand var0) {
        ItemStack var1 = this.getItemInHand(var0);
        if (var1.isEmpty() || this.isUsingItem()) {
            return;
        }
        this.useItem = var1;
        this.useItemRemaining = var1.getUseDuration();
        if (!this.level.isClientSide) {
            this.setLivingEntityFlag(1, true);
            this.setLivingEntityFlag(2, var0 == EnumHand.OFF_HAND);
        }
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (SLEEPING_POS_ID.equals(var0)) {
            if (this.level.isClientSide) {
                this.getSleepingPos().ifPresent(this::setPosToBed);
            }
        } else if (DATA_LIVING_ENTITY_FLAGS.equals(var0) && this.level.isClientSide) {
            if (this.isUsingItem() && this.useItem.isEmpty()) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                if (!this.useItem.isEmpty()) {
                    this.useItemRemaining = this.useItem.getUseDuration();
                }
            } else if (!this.isUsingItem() && !this.useItem.isEmpty()) {
                this.useItem = ItemStack.EMPTY;
                this.useItemRemaining = 0;
            }
        }
    }

    @Override
    public void lookAt(ArgumentAnchor.Anchor var0, Vec3D var1) {
        super.lookAt(var0, var1);
        this.yHeadRotO = this.yHeadRot;
        this.yBodyRotO = this.yBodyRot = this.yHeadRot;
    }

    protected void triggerItemUseEffects(ItemStack var0, int var1) {
        if (var0.isEmpty() || !this.isUsingItem()) {
            return;
        }
        if (var0.getUseAnimation() == EnumAnimation.DRINK) {
            this.playSound(this.getDrinkingSound(var0), 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
        }
        if (var0.getUseAnimation() == EnumAnimation.EAT) {
            this.spawnItemParticles(var0, var1);
            this.playSound(this.getEatingSound(var0), 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    private void spawnItemParticles(ItemStack var0, int var1) {
        for (int var2 = 0; var2 < var1; ++var2) {
            Vec3D var3 = new Vec3D(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            var3 = var3.xRot(-this.getXRot() * ((float)Math.PI / 180));
            var3 = var3.yRot(-this.getYRot() * ((float)Math.PI / 180));
            double var4 = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
            Vec3D var6 = new Vec3D(((double)this.random.nextFloat() - 0.5) * 0.3, var4, 0.6);
            var6 = var6.xRot(-this.getXRot() * ((float)Math.PI / 180));
            var6 = var6.yRot(-this.getYRot() * ((float)Math.PI / 180));
            var6 = var6.add(this.getX(), this.getEyeY(), this.getZ());
            this.level.addParticle(new ParticleParamItem(Particles.ITEM, var0), var6.x, var6.y, var6.z, var3.x, var3.y + 0.05, var3.z);
        }
    }

    protected void completeUsingItem() {
        if (this.level.isClientSide && !this.isUsingItem()) {
            return;
        }
        EnumHand var0 = this.getUsedItemHand();
        if (!this.useItem.equals(this.getItemInHand(var0))) {
            this.releaseUsingItem();
            return;
        }
        if (!this.useItem.isEmpty() && this.isUsingItem()) {
            this.triggerItemUseEffects(this.useItem, 16);
            ItemStack var1 = this.useItem.finishUsingItem(this.level, this);
            if (var1 != this.useItem) {
                this.setItemInHand(var0, var1);
            }
            this.stopUsingItem();
        }
    }

    public ItemStack getUseItem() {
        return this.useItem;
    }

    public int getUseItemRemainingTicks() {
        return this.useItemRemaining;
    }

    public int getTicksUsingItem() {
        if (this.isUsingItem()) {
            return this.useItem.getUseDuration() - this.getUseItemRemainingTicks();
        }
        return 0;
    }

    public void releaseUsingItem() {
        if (!this.useItem.isEmpty()) {
            this.useItem.releaseUsing(this.level, this, this.getUseItemRemainingTicks());
            if (this.useItem.useOnRelease()) {
                this.updatingUsingItem();
            }
        }
        this.stopUsingItem();
    }

    public void stopUsingItem() {
        if (!this.level.isClientSide) {
            this.setLivingEntityFlag(1, false);
        }
        this.useItem = ItemStack.EMPTY;
        this.useItemRemaining = 0;
    }

    public boolean isBlocking() {
        if (!this.isUsingItem() || this.useItem.isEmpty()) {
            return false;
        }
        Item var0 = this.useItem.getItem();
        if (var0.getUseAnimation(this.useItem) != EnumAnimation.BLOCK) {
            return false;
        }
        return var0.getUseDuration(this.useItem) - this.useItemRemaining >= 5;
    }

    public boolean isSuppressingSlidingDownLadder() {
        return this.isShiftKeyDown();
    }

    public boolean isFallFlying() {
        return this.getSharedFlag(7);
    }

    @Override
    public boolean isVisuallySwimming() {
        return super.isVisuallySwimming() || !this.isFallFlying() && this.getPose() == EntityPose.FALL_FLYING;
    }

    public int getFallFlyingTicks() {
        return this.fallFlyTicks;
    }

    public boolean randomTeleport(double var0, double var2, double var4, boolean var6) {
        double var7 = this.getX();
        double var9 = this.getY();
        double var11 = this.getZ();
        double var13 = var2;
        boolean var15 = false;
        World var17 = this.level;
        BlockPosition var16 = new BlockPosition(var0, var13, var4);
        if (var17.hasChunkAt(var16)) {
            boolean var18 = false;
            while (!var18 && var16.getY() > var17.getMinBuildHeight()) {
                BlockPosition var19 = var16.below();
                IBlockData var20 = var17.getBlockState(var19);
                if (var20.getMaterial().blocksMotion()) {
                    var18 = true;
                    continue;
                }
                var13 -= 1.0;
                var16 = var19;
            }
            if (var18) {
                this.teleportTo(var0, var13, var4);
                if (var17.noCollision(this) && !var17.containsAnyLiquid(this.getBoundingBox())) {
                    var15 = true;
                }
            }
        }
        if (!var15) {
            this.teleportTo(var7, var9, var11);
            return false;
        }
        if (var6) {
            var17.broadcastEntityEvent(this, (byte)46);
        }
        if (this instanceof EntityCreature) {
            ((EntityCreature)this).getNavigation().stop();
        }
        return true;
    }

    public boolean isAffectedByPotions() {
        return true;
    }

    public boolean attackable() {
        return true;
    }

    public void setRecordPlayingNearby(BlockPosition var0, boolean var1) {
    }

    public boolean canTakeItem(ItemStack var0) {
        return false;
    }

    @Override
    public Packet<?> getAddEntityPacket() {
        return new PacketPlayOutSpawnEntityLiving(this);
    }

    @Override
    public EntitySize getDimensions(EntityPose var0) {
        return var0 == EntityPose.SLEEPING ? SLEEPING_DIMENSIONS : super.getDimensions(var0).scale(this.getScale());
    }

    public ImmutableList<EntityPose> getDismountPoses() {
        return ImmutableList.of((Object)((Object)EntityPose.STANDING));
    }

    public AxisAlignedBB getLocalBoundsForPose(EntityPose var0) {
        EntitySize var1 = this.getDimensions(var0);
        return new AxisAlignedBB(-var1.width / 2.0f, 0.0, -var1.width / 2.0f, var1.width / 2.0f, var1.height, var1.width / 2.0f);
    }

    public Optional<BlockPosition> getSleepingPos() {
        return this.entityData.get(SLEEPING_POS_ID);
    }

    public void setSleepingPos(BlockPosition var0) {
        this.entityData.set(SLEEPING_POS_ID, Optional.of(var0));
    }

    public void clearSleepingPos() {
        this.entityData.set(SLEEPING_POS_ID, Optional.empty());
    }

    public boolean isSleeping() {
        return this.getSleepingPos().isPresent();
    }

    public void startSleeping(BlockPosition var0) {
        IBlockData var1;
        if (this.isPassenger()) {
            this.stopRiding();
        }
        if ((var1 = this.level.getBlockState(var0)).getBlock() instanceof BlockBed) {
            this.level.setBlock(var0, (IBlockData)var1.setValue(BlockBed.OCCUPIED, true), 3);
        }
        this.setPose(EntityPose.SLEEPING);
        this.setPosToBed(var0);
        this.setSleepingPos(var0);
        this.setDeltaMovement(Vec3D.ZERO);
        this.hasImpulse = true;
    }

    private void setPosToBed(BlockPosition var0) {
        this.setPos((double)var0.getX() + 0.5, (double)var0.getY() + 0.6875, (double)var0.getZ() + 0.5);
    }

    private boolean checkBedExists() {
        return this.getSleepingPos().map(var0 -> this.level.getBlockState((BlockPosition)var0).getBlock() instanceof BlockBed).orElse(false);
    }

    public void stopSleeping() {
        this.getSleepingPos().filter(this.level::hasChunkAt).ifPresent(var0 -> {
            IBlockData var1 = this.level.getBlockState((BlockPosition)var0);
            if (var1.getBlock() instanceof BlockBed) {
                this.level.setBlock((BlockPosition)var0, (IBlockData)var1.setValue(BlockBed.OCCUPIED, false), 3);
                Vec3D var2 = BlockBed.findStandUpPosition(this.getType(), this.level, var0, this.getYRot()).orElseGet(() -> {
                    BlockPosition var1 = var0.above();
                    return new Vec3D((double)var1.getX() + 0.5, (double)var1.getY() + 0.1, (double)var1.getZ() + 0.5);
                });
                Vec3D var3 = Vec3D.atBottomCenterOf(var0).subtract(var2).normalize();
                float var4 = (float)MathHelper.wrapDegrees(MathHelper.atan2(var3.z, var3.x) * 57.2957763671875 - 90.0);
                this.setPos(var2.x, var2.y, var2.z);
                this.setYRot(var4);
                this.setXRot(0.0f);
            }
        });
        Vec3D var02 = this.position();
        this.setPose(EntityPose.STANDING);
        this.setPos(var02.x, var02.y, var02.z);
        this.clearSleepingPos();
    }

    @Nullable
    public EnumDirection getBedOrientation() {
        BlockPosition var0 = this.getSleepingPos().orElse(null);
        return var0 != null ? BlockBed.getBedOrientation(this.level, var0) : null;
    }

    @Override
    public boolean isInWall() {
        return !this.isSleeping() && super.isInWall();
    }

    @Override
    protected final float getEyeHeight(EntityPose var0, EntitySize var1) {
        return var0 == EntityPose.SLEEPING ? 0.2f : this.getStandingEyeHeight(var0, var1);
    }

    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return super.getEyeHeight(var0, var1);
    }

    public ItemStack getProjectile(ItemStack var0) {
        return ItemStack.EMPTY;
    }

    public ItemStack eat(World var0, ItemStack var1) {
        if (var1.isEdible()) {
            var0.gameEvent((Entity)this, GameEvent.EAT, this.eyeBlockPosition());
            var0.playSound(null, this.getX(), this.getY(), this.getZ(), this.getEatingSound(var1), SoundCategory.NEUTRAL, 1.0f, 1.0f + (var0.random.nextFloat() - var0.random.nextFloat()) * 0.4f);
            this.addEatEffect(var1, var0, this);
            if (!(this instanceof EntityHuman) || !((EntityHuman)this).getAbilities().instabuild) {
                var1.shrink(1);
            }
            this.gameEvent(GameEvent.EAT);
        }
        return var1;
    }

    private void addEatEffect(ItemStack var0, World var1, EntityLiving var2) {
        Item var3 = var0.getItem();
        if (var3.isEdible()) {
            List<Pair<MobEffect, Float>> var4 = var3.getFoodProperties().getEffects();
            for (Pair<MobEffect, Float> var6 : var4) {
                if (var1.isClientSide || var6.getFirst() == null || !(var1.random.nextFloat() < ((Float)var6.getSecond()).floatValue())) continue;
                var2.addEffect(new MobEffect((MobEffect)var6.getFirst()));
            }
        }
    }

    private static byte entityEventForEquipmentBreak(EnumItemSlot var0) {
        switch (var0) {
            case MAINHAND: {
                return 47;
            }
            case OFFHAND: {
                return 48;
            }
            case HEAD: {
                return 49;
            }
            case CHEST: {
                return 50;
            }
            case FEET: {
                return 52;
            }
            case LEGS: {
                return 51;
            }
        }
        return 47;
    }

    public void broadcastBreakEvent(EnumItemSlot var0) {
        this.level.broadcastEntityEvent(this, EntityLiving.entityEventForEquipmentBreak(var0));
    }

    public void broadcastBreakEvent(EnumHand var0) {
        this.broadcastBreakEvent(var0 == EnumHand.MAIN_HAND ? EnumItemSlot.MAINHAND : EnumItemSlot.OFFHAND);
    }

    @Override
    public AxisAlignedBB getBoundingBoxForCulling() {
        if (this.getItemBySlot(EnumItemSlot.HEAD).is(Items.DRAGON_HEAD)) {
            float var0 = 0.5f;
            return this.getBoundingBox().inflate(0.5, 0.5, 0.5);
        }
        return super.getBoundingBoxForCulling();
    }

    public static EnumItemSlot getEquipmentSlotForItem(ItemStack var0) {
        Item var1 = var0.getItem();
        if (var0.is(Items.CARVED_PUMPKIN) || var1 instanceof ItemBlock && ((ItemBlock)var1).getBlock() instanceof BlockSkullAbstract) {
            return EnumItemSlot.HEAD;
        }
        if (var1 instanceof ItemArmor) {
            return ((ItemArmor)var1).getSlot();
        }
        if (var0.is(Items.ELYTRA)) {
            return EnumItemSlot.CHEST;
        }
        if (var0.is(Items.SHIELD)) {
            return EnumItemSlot.OFFHAND;
        }
        return EnumItemSlot.MAINHAND;
    }

    private static SlotAccess createEquipmentSlotAccess(EntityLiving var0, EnumItemSlot var12) {
        if (var12 == EnumItemSlot.HEAD || var12 == EnumItemSlot.MAINHAND || var12 == EnumItemSlot.OFFHAND) {
            return SlotAccess.forEquipmentSlot(var0, var12);
        }
        return SlotAccess.forEquipmentSlot(var0, var12, var1 -> var1.isEmpty() || EntityInsentient.getEquipmentSlotForItem(var1) == var12);
    }

    @Nullable
    private static EnumItemSlot getEquipmentSlot(int var0) {
        if (var0 == 100 + EnumItemSlot.HEAD.getIndex()) {
            return EnumItemSlot.HEAD;
        }
        if (var0 == 100 + EnumItemSlot.CHEST.getIndex()) {
            return EnumItemSlot.CHEST;
        }
        if (var0 == 100 + EnumItemSlot.LEGS.getIndex()) {
            return EnumItemSlot.LEGS;
        }
        if (var0 == 100 + EnumItemSlot.FEET.getIndex()) {
            return EnumItemSlot.FEET;
        }
        if (var0 == 98) {
            return EnumItemSlot.MAINHAND;
        }
        if (var0 == 99) {
            return EnumItemSlot.OFFHAND;
        }
        return null;
    }

    @Override
    public SlotAccess getSlot(int var0) {
        EnumItemSlot var1 = EntityLiving.getEquipmentSlot(var0);
        if (var1 != null) {
            return EntityLiving.createEquipmentSlotAccess(this, var1);
        }
        return super.getSlot(var0);
    }

    @Override
    public boolean canFreeze() {
        if (this.isSpectator()) {
            return false;
        }
        boolean var0 = !this.getItemBySlot(EnumItemSlot.HEAD).is(TagsItem.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EnumItemSlot.CHEST).is(TagsItem.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EnumItemSlot.LEGS).is(TagsItem.FREEZE_IMMUNE_WEARABLES) && !this.getItemBySlot(EnumItemSlot.FEET).is(TagsItem.FREEZE_IMMUNE_WEARABLES);
        return var0 && super.canFreeze();
    }

    @Override
    public boolean isCurrentlyGlowing() {
        return !this.level.isClientSide() && this.hasEffect(MobEffects.GLOWING) || super.isCurrentlyGlowing();
    }

    public void recreateFromPacket(PacketPlayOutSpawnEntityLiving var0) {
        double var1 = var0.getX();
        double var3 = var0.getY();
        double var5 = var0.getZ();
        float var7 = (float)(var0.getyRot() * 360) / 256.0f;
        float var8 = (float)(var0.getxRot() * 360) / 256.0f;
        this.setPacketCoordinates(var1, var3, var5);
        this.yBodyRot = (float)(var0.getyHeadRot() * 360) / 256.0f;
        this.yHeadRot = (float)(var0.getyHeadRot() * 360) / 256.0f;
        this.yBodyRotO = this.yBodyRot;
        this.yHeadRotO = this.yHeadRot;
        this.setId(var0.getId());
        this.setUUID(var0.getUUID());
        this.absMoveTo(var1, var3, var5, var7, var8);
        this.setDeltaMovement((float)var0.getXd() / 8000.0f, (float)var0.getYd() / 8000.0f, (float)var0.getZd() / 8000.0f);
    }

    public record a(SoundEffect small, SoundEffect big) {
    }
}

