/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.ComparisonChain;
import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityLiving;
import org.slf4j.Logger;

public class MobEffect
implements Comparable<MobEffect> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MobEffectList effect;
    private int duration;
    private int amplifier;
    private boolean ambient;
    private boolean noCounter;
    private boolean visible;
    private boolean showIcon;
    @Nullable
    private MobEffect hiddenEffect;

    public MobEffect(MobEffectList var0) {
        this(var0, 0, 0);
    }

    public MobEffect(MobEffectList var0, int var1) {
        this(var0, var1, 0);
    }

    public MobEffect(MobEffectList var0, int var1, int var2) {
        this(var0, var1, var2, false, true);
    }

    public MobEffect(MobEffectList var0, int var1, int var2, boolean var3, boolean var4) {
        this(var0, var1, var2, var3, var4, var4);
    }

    public MobEffect(MobEffectList var0, int var1, int var2, boolean var3, boolean var4, boolean var5) {
        this(var0, var1, var2, var3, var4, var5, null);
    }

    public MobEffect(MobEffectList var0, int var1, int var2, boolean var3, boolean var4, boolean var5, @Nullable MobEffect var6) {
        this.effect = var0;
        this.duration = var1;
        this.amplifier = var2;
        this.ambient = var3;
        this.visible = var4;
        this.showIcon = var5;
        this.hiddenEffect = var6;
    }

    public MobEffect(MobEffect var0) {
        this.effect = var0.effect;
        this.setDetailsFrom(var0);
    }

    void setDetailsFrom(MobEffect var0) {
        this.duration = var0.duration;
        this.amplifier = var0.amplifier;
        this.ambient = var0.ambient;
        this.visible = var0.visible;
        this.showIcon = var0.showIcon;
    }

    public boolean update(MobEffect var0) {
        if (this.effect != var0.effect) {
            LOGGER.warn("This method should only be called for matching effects!");
        }
        boolean var1 = false;
        if (var0.amplifier > this.amplifier) {
            if (var0.duration < this.duration) {
                MobEffect var2 = this.hiddenEffect;
                this.hiddenEffect = new MobEffect(this);
                this.hiddenEffect.hiddenEffect = var2;
            }
            this.amplifier = var0.amplifier;
            this.duration = var0.duration;
            var1 = true;
        } else if (var0.duration > this.duration) {
            if (var0.amplifier == this.amplifier) {
                this.duration = var0.duration;
                var1 = true;
            } else if (this.hiddenEffect == null) {
                this.hiddenEffect = new MobEffect(var0);
            } else {
                this.hiddenEffect.update(var0);
            }
        }
        if (!var0.ambient && this.ambient || var1) {
            this.ambient = var0.ambient;
            var1 = true;
        }
        if (var0.visible != this.visible) {
            this.visible = var0.visible;
            var1 = true;
        }
        if (var0.showIcon != this.showIcon) {
            this.showIcon = var0.showIcon;
            var1 = true;
        }
        return var1;
    }

    public MobEffectList getEffect() {
        return this.effect;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean showIcon() {
        return this.showIcon;
    }

    public boolean tick(EntityLiving var0, Runnable var1) {
        if (this.duration > 0) {
            if (this.effect.isDurationEffectTick(this.duration, this.amplifier)) {
                this.applyEffect(var0);
            }
            this.tickDownDuration();
            if (this.duration == 0 && this.hiddenEffect != null) {
                this.setDetailsFrom(this.hiddenEffect);
                this.hiddenEffect = this.hiddenEffect.hiddenEffect;
                var1.run();
            }
        }
        return this.duration > 0;
    }

    private int tickDownDuration() {
        if (this.hiddenEffect != null) {
            this.hiddenEffect.tickDownDuration();
        }
        return --this.duration;
    }

    public void applyEffect(EntityLiving var0) {
        if (this.duration > 0) {
            this.effect.applyEffectTick(var0, this.amplifier);
        }
    }

    public String getDescriptionId() {
        return this.effect.getDescriptionId();
    }

    public String toString() {
        String var0 = this.amplifier > 0 ? this.getDescriptionId() + " x " + (this.amplifier + 1) + ", Duration: " + this.duration : this.getDescriptionId() + ", Duration: " + this.duration;
        if (!this.visible) {
            var0 = var0 + ", Particles: false";
        }
        if (!this.showIcon) {
            var0 = var0 + ", Show Icon: false";
        }
        return var0;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof MobEffect) {
            MobEffect var1 = (MobEffect)var0;
            return this.duration == var1.duration && this.amplifier == var1.amplifier && this.ambient == var1.ambient && this.effect.equals(var1.effect);
        }
        return false;
    }

    public int hashCode() {
        int var0 = this.effect.hashCode();
        var0 = 31 * var0 + this.duration;
        var0 = 31 * var0 + this.amplifier;
        var0 = 31 * var0 + (this.ambient ? 1 : 0);
        return var0;
    }

    public NBTTagCompound save(NBTTagCompound var0) {
        var0.putByte("Id", (byte)MobEffectList.getId(this.getEffect()));
        this.writeDetailsTo(var0);
        return var0;
    }

    private void writeDetailsTo(NBTTagCompound var0) {
        var0.putByte("Amplifier", (byte)this.getAmplifier());
        var0.putInt("Duration", this.getDuration());
        var0.putBoolean("Ambient", this.isAmbient());
        var0.putBoolean("ShowParticles", this.isVisible());
        var0.putBoolean("ShowIcon", this.showIcon());
        if (this.hiddenEffect != null) {
            NBTTagCompound var1 = new NBTTagCompound();
            this.hiddenEffect.save(var1);
            var0.put("HiddenEffect", var1);
        }
    }

    @Nullable
    public static MobEffect load(NBTTagCompound var0) {
        byte var1 = var0.getByte("Id");
        MobEffectList var2 = MobEffectList.byId(var1);
        if (var2 == null) {
            return null;
        }
        return MobEffect.loadSpecifiedEffect(var2, var0);
    }

    private static MobEffect loadSpecifiedEffect(MobEffectList var0, NBTTagCompound var1) {
        byte var2 = var1.getByte("Amplifier");
        int var3 = var1.getInt("Duration");
        boolean var4 = var1.getBoolean("Ambient");
        boolean var5 = true;
        if (var1.contains("ShowParticles", 1)) {
            var5 = var1.getBoolean("ShowParticles");
        }
        boolean var6 = var5;
        if (var1.contains("ShowIcon", 1)) {
            var6 = var1.getBoolean("ShowIcon");
        }
        MobEffect var7 = null;
        if (var1.contains("HiddenEffect", 10)) {
            var7 = MobEffect.loadSpecifiedEffect(var0, var1.getCompound("HiddenEffect"));
        }
        return new MobEffect(var0, var3, var2 < 0 ? (byte)0 : var2, var4, var5, var6, var7);
    }

    public void setNoCounter(boolean var0) {
        this.noCounter = var0;
    }

    public boolean isNoCounter() {
        return this.noCounter;
    }

    @Override
    public int compareTo(MobEffect var0) {
        int var1 = 32147;
        if (this.getDuration() > 32147 && var0.getDuration() > 32147 || this.isAmbient() && var0.isAmbient()) {
            return ComparisonChain.start().compare(Boolean.valueOf(this.isAmbient()), Boolean.valueOf(var0.isAmbient())).compare(this.getEffect().getColor(), var0.getEffect().getColor()).result();
        }
        return ComparisonChain.start().compare(Boolean.valueOf(this.isAmbient()), Boolean.valueOf(var0.isAmbient())).compare(this.getDuration(), var0.getDuration()).compare(this.getEffect().getColor(), var0.getEffect().getColor()).result();
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((MobEffect)object);
    }
}

