/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import javax.annotation.Nullable;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3D;

public class EntityDamageSource
extends DamageSource {
    protected final Entity entity;
    private boolean isThorns;

    public EntityDamageSource(String var0, Entity var1) {
        super(var0);
        this.entity = var1;
    }

    public EntityDamageSource setThorns() {
        this.isThorns = true;
        return this;
    }

    public boolean isThorns() {
        return this.isThorns;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public IChatBaseComponent getLocalizedDeathMessage(EntityLiving var0) {
        ItemStack var1 = this.entity instanceof EntityLiving ? ((EntityLiving)this.entity).getMainHandItem() : ItemStack.EMPTY;
        String var2 = "death.attack." + this.msgId;
        if (!var1.isEmpty() && var1.hasCustomHoverName()) {
            return new ChatMessage(var2 + ".item", var0.getDisplayName(), this.entity.getDisplayName(), var1.getDisplayName());
        }
        return new ChatMessage(var2, var0.getDisplayName(), this.entity.getDisplayName());
    }

    @Override
    public boolean scalesWithDifficulty() {
        return this.entity instanceof EntityLiving && !(this.entity instanceof EntityHuman);
    }

    @Override
    @Nullable
    public Vec3D getSourcePosition() {
        return this.entity.position();
    }

    @Override
    public String toString() {
        return "EntityDamageSource (" + this.entity + ")";
    }
}

