/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class CombatTracker {
    public static final int RESET_DAMAGE_STATUS_TIME = 100;
    public static final int RESET_COMBAT_STATUS_TIME = 300;
    private final List<CombatEntry> entries = Lists.newArrayList();
    private final EntityLiving mob;
    private int lastDamageTime;
    private int combatStartTime;
    private int combatEndTime;
    private boolean inCombat;
    private boolean takingDamage;
    @Nullable
    private String nextLocation;

    public CombatTracker(EntityLiving var0) {
        this.mob = var0;
    }

    public void prepareForDamage() {
        this.resetPreparedStatus();
        Optional<BlockPosition> var0 = this.mob.getLastClimbablePos();
        if (var0.isPresent()) {
            IBlockData var1 = this.mob.level.getBlockState(var0.get());
            this.nextLocation = var1.is(Blocks.LADDER) || var1.is(TagsBlock.TRAPDOORS) ? "ladder" : (var1.is(Blocks.VINE) ? "vines" : (var1.is(Blocks.WEEPING_VINES) || var1.is(Blocks.WEEPING_VINES_PLANT) ? "weeping_vines" : (var1.is(Blocks.TWISTING_VINES) || var1.is(Blocks.TWISTING_VINES_PLANT) ? "twisting_vines" : (var1.is(Blocks.SCAFFOLDING) ? "scaffolding" : "other_climbable"))));
        } else if (this.mob.isInWater()) {
            this.nextLocation = "water";
        }
    }

    public void recordDamage(DamageSource var0, float var1, float var2) {
        this.recheckStatus();
        this.prepareForDamage();
        CombatEntry var3 = new CombatEntry(var0, this.mob.tickCount, var1, var2, this.nextLocation, this.mob.fallDistance);
        this.entries.add(var3);
        this.lastDamageTime = this.mob.tickCount;
        this.takingDamage = true;
        if (var3.isCombatRelated() && !this.inCombat && this.mob.isAlive()) {
            this.inCombat = true;
            this.combatEndTime = this.combatStartTime = this.mob.tickCount;
            this.mob.onEnterCombat();
        }
    }

    public IChatBaseComponent getDeathMessage() {
        IChatBaseComponent var2;
        if (this.entries.isEmpty()) {
            return new ChatMessage("death.attack.generic", this.mob.getDisplayName());
        }
        CombatEntry var0 = this.getMostSignificantFall();
        CombatEntry var1 = this.entries.get(this.entries.size() - 1);
        IChatBaseComponent var3 = var1.getAttackerName();
        Entity var4 = var1.getSource().getEntity();
        if (var0 != null && var1.getSource() == DamageSource.FALL) {
            IChatBaseComponent var5 = var0.getAttackerName();
            if (var0.getSource() == DamageSource.FALL || var0.getSource() == DamageSource.OUT_OF_WORLD) {
                var2 = new ChatMessage("death.fell.accident." + this.getFallLocation(var0), this.mob.getDisplayName());
            } else if (var5 != null && !var5.equals(var3)) {
                ItemStack var7;
                Entity var6 = var0.getSource().getEntity();
                ItemStack itemStack = var7 = var6 instanceof EntityLiving ? ((EntityLiving)var6).getMainHandItem() : ItemStack.EMPTY;
                var2 = !var7.isEmpty() && var7.hasCustomHoverName() ? new ChatMessage("death.fell.assist.item", this.mob.getDisplayName(), var5, var7.getDisplayName()) : new ChatMessage("death.fell.assist", this.mob.getDisplayName(), var5);
            } else if (var3 != null) {
                ItemStack var6;
                ItemStack itemStack = var6 = var4 instanceof EntityLiving ? ((EntityLiving)var4).getMainHandItem() : ItemStack.EMPTY;
                var2 = !var6.isEmpty() && var6.hasCustomHoverName() ? new ChatMessage("death.fell.finish.item", this.mob.getDisplayName(), var3, var6.getDisplayName()) : new ChatMessage("death.fell.finish", this.mob.getDisplayName(), var3);
            } else {
                var2 = new ChatMessage("death.fell.killer", this.mob.getDisplayName());
            }
        } else {
            var2 = var1.getSource().getLocalizedDeathMessage(this.mob);
        }
        return var2;
    }

    @Nullable
    public EntityLiving getKiller() {
        EntityLiving var0 = null;
        EntityHuman var1 = null;
        float var2 = 0.0f;
        float var3 = 0.0f;
        for (CombatEntry var5 : this.entries) {
            if (var5.getSource().getEntity() instanceof EntityHuman && (var1 == null || var5.getDamage() > var3)) {
                var3 = var5.getDamage();
                var1 = (EntityHuman)var5.getSource().getEntity();
            }
            if (!(var5.getSource().getEntity() instanceof EntityLiving) || var0 != null && !(var5.getDamage() > var2)) continue;
            var2 = var5.getDamage();
            var0 = (EntityLiving)var5.getSource().getEntity();
        }
        if (var1 != null && var3 >= var2 / 3.0f) {
            return var1;
        }
        return var0;
    }

    @Nullable
    private CombatEntry getMostSignificantFall() {
        CombatEntry var0 = null;
        CombatEntry var1 = null;
        float var2 = 0.0f;
        float var3 = 0.0f;
        for (int var4 = 0; var4 < this.entries.size(); ++var4) {
            CombatEntry var6;
            CombatEntry var5 = this.entries.get(var4);
            CombatEntry combatEntry = var6 = var4 > 0 ? this.entries.get(var4 - 1) : null;
            if ((var5.getSource() == DamageSource.FALL || var5.getSource() == DamageSource.OUT_OF_WORLD) && var5.getFallDistance() > 0.0f && (var0 == null || var5.getFallDistance() > var3)) {
                var0 = var4 > 0 ? var6 : var5;
                var3 = var5.getFallDistance();
            }
            if (var5.getLocation() == null || var1 != null && !(var5.getDamage() > var2)) continue;
            var1 = var5;
            var2 = var5.getDamage();
        }
        if (var3 > 5.0f && var0 != null) {
            return var0;
        }
        if (var2 > 5.0f && var1 != null) {
            return var1;
        }
        return null;
    }

    private String getFallLocation(CombatEntry var0) {
        return var0.getLocation() == null ? "generic" : var0.getLocation();
    }

    public boolean isTakingDamage() {
        this.recheckStatus();
        return this.takingDamage;
    }

    public boolean isInCombat() {
        this.recheckStatus();
        return this.inCombat;
    }

    public int getCombatDuration() {
        if (this.inCombat) {
            return this.mob.tickCount - this.combatStartTime;
        }
        return this.combatEndTime - this.combatStartTime;
    }

    private void resetPreparedStatus() {
        this.nextLocation = null;
    }

    public void recheckStatus() {
        int var0;
        int n2 = var0 = this.inCombat ? 300 : 100;
        if (this.takingDamage && (!this.mob.isAlive() || this.mob.tickCount - this.lastDamageTime > var0)) {
            boolean var1 = this.inCombat;
            this.takingDamage = false;
            this.inCombat = false;
            this.combatEndTime = this.mob.tickCount;
            if (var1) {
                this.mob.onLeaveCombat();
            }
            this.entries.clear();
        }
    }

    public EntityLiving getMob() {
        return this.mob;
    }

    @Nullable
    public CombatEntry getLastEntry() {
        if (this.entries.isEmpty()) {
            return null;
        }
        return this.entries.get(this.entries.size() - 1);
    }

    public int getKillerId() {
        EntityLiving var0 = this.getKiller();
        return var0 == null ? -1 : var0.getId();
    }
}

