/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.serialize;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.LongSerializationPolicy;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;
import net.minecraft.SystemUtils;
import net.minecraft.util.profiling.jfr.Percentiles;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import net.minecraft.util.profiling.jfr.stats.ChunkGenStat;
import net.minecraft.util.profiling.jfr.stats.CpuLoadStat;
import net.minecraft.util.profiling.jfr.stats.FileIOStat;
import net.minecraft.util.profiling.jfr.stats.GcHeapStat;
import net.minecraft.util.profiling.jfr.stats.NetworkPacketSummary;
import net.minecraft.util.profiling.jfr.stats.ThreadAllocationStat;
import net.minecraft.util.profiling.jfr.stats.TickTimeStat;
import net.minecraft.util.profiling.jfr.stats.TimedStatSummary;
import net.minecraft.world.level.chunk.ChunkStatus;

public class JfrResultJsonSerializer {
    private static final String BYTES_PER_SECOND = "bytesPerSecond";
    private static final String COUNT = "count";
    private static final String DURATION_NANOS_TOTAL = "durationNanosTotal";
    private static final String TOTAL_BYTES = "totalBytes";
    private static final String COUNT_PER_SECOND = "countPerSecond";
    final Gson gson = new GsonBuilder().setPrettyPrinting().setLongSerializationPolicy(LongSerializationPolicy.DEFAULT).create();

    public String format(JfrStatsResult var0) {
        JsonObject var1 = new JsonObject();
        var1.addProperty("startedEpoch", (Number)var0.recordingStarted().toEpochMilli());
        var1.addProperty("endedEpoch", (Number)var0.recordingEnded().toEpochMilli());
        var1.addProperty("durationMs", (Number)var0.recordingDuration().toMillis());
        Duration var2 = var0.worldCreationDuration();
        if (var2 != null) {
            var1.addProperty("worldGenDurationMs", (Number)var2.toMillis());
        }
        var1.add("heap", this.heap(var0.heapSummary()));
        var1.add("cpuPercent", this.cpu(var0.cpuLoadStats()));
        var1.add("network", this.network(var0));
        var1.add("fileIO", this.fileIO(var0));
        var1.add("serverTick", this.serverTicks(var0.tickTimes()));
        var1.add("threadAllocation", this.threadAllocations(var0.threadAllocationSummary()));
        var1.add("chunkGen", this.chunkGen(var0.chunkGenSummary()));
        return this.gson.toJson((JsonElement)var1);
    }

    private JsonElement heap(GcHeapStat.a var0) {
        JsonObject var1 = new JsonObject();
        var1.addProperty("allocationRateBytesPerSecond", (Number)var0.allocationRateBytesPerSecond());
        var1.addProperty("gcCount", (Number)var0.totalGCs());
        var1.addProperty("gcOverHeadPercent", (Number)Float.valueOf(var0.gcOverHead()));
        var1.addProperty("gcTotalDurationMs", (Number)var0.gcTotalDuration().toMillis());
        return var1;
    }

    private JsonElement chunkGen(List<Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>>> var02) {
        JsonObject var12 = new JsonObject();
        var12.addProperty(DURATION_NANOS_TOTAL, (Number)var02.stream().mapToDouble(var0 -> ((TimedStatSummary)var0.getSecond()).totalDuration().toNanos()).sum());
        JsonArray var22 = SystemUtils.make(new JsonArray(), var1 -> var12.add("status", (JsonElement)var1));
        for (Pair<ChunkStatus, TimedStatSummary<ChunkGenStat>> var4 : var02) {
            TimedStatSummary var5 = (TimedStatSummary)var4.getSecond();
            JsonObject var6 = SystemUtils.make(new JsonObject(), arg_0 -> ((JsonArray)var22).add(arg_0));
            var6.addProperty("state", ((ChunkStatus)var4.getFirst()).getName());
            var6.addProperty(COUNT, (Number)var5.count());
            var6.addProperty(DURATION_NANOS_TOTAL, (Number)var5.totalDuration().toNanos());
            var6.addProperty("durationNanosAvg", (Number)(var5.totalDuration().toNanos() / (long)var5.count()));
            JsonObject var7 = SystemUtils.make(new JsonObject(), var1 -> var6.add("durationNanosPercentiles", (JsonElement)var1));
            var5.percentilesNanos().forEach((var1, var2) -> var7.addProperty("p" + var1, (Number)var2));
            Function<ChunkGenStat, JsonElement> var8 = var0 -> {
                JsonObject var1 = new JsonObject();
                var1.addProperty("durationNanos", (Number)var0.duration().toNanos());
                var1.addProperty("level", var0.level());
                var1.addProperty("chunkPosX", (Number)var0.chunkPos().x);
                var1.addProperty("chunkPosZ", (Number)var0.chunkPos().z);
                var1.addProperty("worldPosX", (Number)var0.worldPos().x);
                var1.addProperty("worldPosZ", (Number)var0.worldPos().z);
                return var1;
            };
            var6.add("fastest", var8.apply((ChunkGenStat)var5.fastest()));
            var6.add("slowest", var8.apply((ChunkGenStat)var5.slowest()));
            var6.add("secondSlowest", (JsonElement)(var5.secondSlowest() != null ? var8.apply((ChunkGenStat)var5.secondSlowest()) : JsonNull.INSTANCE));
        }
        return var12;
    }

    private JsonElement threadAllocations(ThreadAllocationStat.a var0) {
        JsonArray var12 = new JsonArray();
        var0.allocationsPerSecondByThread().forEach((var1, var22) -> var12.add((JsonElement)SystemUtils.make(new JsonObject(), var2 -> {
            var2.addProperty("thread", var1);
            var2.addProperty(BYTES_PER_SECOND, (Number)var22);
        })));
        return var12;
    }

    private JsonElement serverTicks(List<TickTimeStat> var02) {
        if (var02.isEmpty()) {
            return JsonNull.INSTANCE;
        }
        JsonObject var12 = new JsonObject();
        double[] var22 = var02.stream().mapToDouble(var0 -> (double)var0.currentAverage().toNanos() / 1000000.0).toArray();
        DoubleSummaryStatistics var3 = DoubleStream.of(var22).summaryStatistics();
        var12.addProperty("minMs", (Number)var3.getMin());
        var12.addProperty("averageMs", (Number)var3.getAverage());
        var12.addProperty("maxMs", (Number)var3.getMax());
        Map<Integer, Double> var4 = Percentiles.evaluate(var22);
        var4.forEach((var1, var2) -> var12.addProperty("p" + var1, (Number)var2));
        return var12;
    }

    private JsonElement fileIO(JfrStatsResult var0) {
        JsonObject var1 = new JsonObject();
        var1.add("write", this.fileIoSummary(var0.fileWrites()));
        var1.add("read", this.fileIoSummary(var0.fileReads()));
        return var1;
    }

    private JsonElement fileIoSummary(FileIOStat.a var0) {
        JsonObject var12 = new JsonObject();
        var12.addProperty(TOTAL_BYTES, (Number)var0.totalBytes());
        var12.addProperty(COUNT, (Number)var0.counts());
        var12.addProperty(BYTES_PER_SECOND, (Number)var0.bytesPerSecond());
        var12.addProperty(COUNT_PER_SECOND, (Number)var0.countsPerSecond());
        JsonArray var2 = new JsonArray();
        var12.add("topContributors", (JsonElement)var2);
        var0.topTenContributorsByTotalBytes().forEach(var1 -> {
            JsonObject var2 = new JsonObject();
            var2.add((JsonElement)var2);
            var2.addProperty("path", (String)var1.getFirst());
            var2.addProperty(TOTAL_BYTES, (Number)var1.getSecond());
        });
        return var12;
    }

    private JsonElement network(JfrStatsResult var0) {
        JsonObject var1 = new JsonObject();
        var1.add("sent", this.packets(var0.sentPacketsSummary()));
        var1.add("received", this.packets(var0.receivedPacketsSummary()));
        return var1;
    }

    private JsonElement packets(NetworkPacketSummary var0) {
        JsonObject var12 = new JsonObject();
        var12.addProperty(TOTAL_BYTES, (Number)var0.getTotalSize());
        var12.addProperty(COUNT, (Number)var0.getTotalCount());
        var12.addProperty(BYTES_PER_SECOND, (Number)var0.getSizePerSecond());
        var12.addProperty(COUNT_PER_SECOND, (Number)var0.getCountsPerSecond());
        JsonArray var2 = new JsonArray();
        var12.add("topContributors", (JsonElement)var2);
        var0.largestSizeContributors().forEach(var1 -> {
            JsonObject var2 = new JsonObject();
            var2.add((JsonElement)var2);
            NetworkPacketSummary.b var3 = (NetworkPacketSummary.b)var1.getFirst();
            NetworkPacketSummary.a var4 = (NetworkPacketSummary.a)var1.getSecond();
            var2.addProperty("protocolId", (Number)var3.protocolId());
            var2.addProperty("packetId", (Number)var3.packetId());
            var2.addProperty("packetName", var3.packetName());
            var2.addProperty(TOTAL_BYTES, (Number)var4.totalSize());
            var2.addProperty(COUNT, (Number)var4.totalCount());
        });
        return var12;
    }

    private JsonElement cpu(List<CpuLoadStat> var02) {
        JsonObject var12 = new JsonObject();
        BiFunction<List, ToDoubleFunction, JsonObject> var2 = (var0, var1) -> {
            JsonObject var2 = new JsonObject();
            DoubleSummaryStatistics var3 = var0.stream().mapToDouble(var1).summaryStatistics();
            var2.addProperty("min", (Number)var3.getMin());
            var2.addProperty("average", (Number)var3.getAverage());
            var2.addProperty("max", (Number)var3.getMax());
            return var2;
        };
        var12.add("jvm", (JsonElement)var2.apply(var02, CpuLoadStat::jvm));
        var12.add("userJvm", (JsonElement)var2.apply(var02, CpuLoadStat::userJvm));
        var12.add("system", (JsonElement)var2.apply(var02, CpuLoadStat::system));
        return var12;
    }
}

