/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterVillagerLevelXp
extends DataFix {
    private static final int TRADES_PER_LEVEL = 2;
    private static final int[] LEVEL_XP_THRESHOLDS = new int[]{0, 10, 50, 100, 150};

    public static int getMinXpPerLevel(int var0) {
        return LEVEL_XP_THRESHOLDS[MathHelper.clamp(var0 - 1, 0, LEVEL_XP_THRESHOLDS.length - 1)];
    }

    public DataConverterVillagerLevelXp(Schema var0, boolean var1) {
        super(var0, var1);
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getChoiceType(DataConverterTypes.ENTITY, "minecraft:villager");
        OpticFinder var1 = DSL.namedChoice((String)"minecraft:villager", (Type)var0);
        OpticFinder var2 = var0.findField("Offers");
        Type var3 = var2.type();
        OpticFinder var4 = var3.findField("Recipes");
        List.ListType var52 = (List.ListType)var4.type();
        OpticFinder var6 = var52.getElement().finder();
        return this.fixTypeEverywhereTyped("Villager level and xp rebuild", this.getInputSchema().getType(DataConverterTypes.ENTITY), var5 -> var5.updateTyped(var1, var0, var3 -> {
            Optional var7;
            int var72;
            OpticFinder var6 = (Dynamic)var3.get(DSL.remainderFinder());
            Object var5 = var6.get("VillagerData").get("level").asInt(0);
            Typed<?> var6 = var3;
            if ((var5 == 0 || var5 == 1) && (var5 = MathHelper.clamp((var72 = var3.getOptionalTyped(var2).flatMap(var1 -> var1.getOptionalTyped(var4)).map(var1 -> var1.getAllTyped(var6).size()).orElse(0).intValue()) / 2, 1, 5)) > 1) {
                var6 = DataConverterVillagerLevelXp.addLevel(var6, var5);
            }
            if (!(var7 = var6.get("Xp").asNumber().result()).isPresent()) {
                var6 = DataConverterVillagerLevelXp.addXpFromLevel(var6, var5);
            }
            return var6;
        }));
    }

    private static Typed<?> addLevel(Typed<?> var0, int var1) {
        return var0.update(DSL.remainderFinder(), var12 -> var12.update("VillagerData", var1 -> var1.set("level", var1.createInt(var1))));
    }

    private static Typed<?> addXpFromLevel(Typed<?> var0, int var12) {
        int var2 = DataConverterVillagerLevelXp.getMinXpPerLevel(var12);
        return var0.update(DSL.remainderFinder(), var1 -> var1.set("Xp", var1.createInt(var2)));
    }
}

