/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.util.CryptographyException;

public class MinecraftEncryption {
    private static final String SYMMETRIC_ALGORITHM = "AES";
    private static final int SYMMETRIC_BITS = 128;
    private static final String ASYMMETRIC_ALGORITHM = "RSA";
    private static final int ASYMMETRIC_BITS = 1024;
    private static final String BYTE_ENCODING = "ISO_8859_1";
    private static final String HASH_ALGORITHM = "SHA-1";

    public static SecretKey generateSecretKey() throws CryptographyException {
        try {
            KeyGenerator var0 = KeyGenerator.getInstance(SYMMETRIC_ALGORITHM);
            var0.init(128);
            return var0.generateKey();
        }
        catch (Exception var0) {
            throw new CryptographyException(var0);
        }
    }

    public static KeyPair generateKeyPair() throws CryptographyException {
        try {
            KeyPairGenerator var0 = KeyPairGenerator.getInstance(ASYMMETRIC_ALGORITHM);
            var0.initialize(1024);
            return var0.generateKeyPair();
        }
        catch (Exception var0) {
            throw new CryptographyException(var0);
        }
    }

    public static byte[] digestData(String var0, PublicKey var1, SecretKey var2) throws CryptographyException {
        try {
            return MinecraftEncryption.digestData(var0.getBytes(BYTE_ENCODING), var2.getEncoded(), var1.getEncoded());
        }
        catch (Exception var3) {
            throw new CryptographyException(var3);
        }
    }

    private static byte[] digestData(byte[] ... var0) throws Exception {
        MessageDigest var1 = MessageDigest.getInstance(HASH_ALGORITHM);
        for (byte[] var5 : var0) {
            var1.update(var5);
        }
        return var1.digest();
    }

    public static PublicKey byteToPublicKey(byte[] var0) throws CryptographyException {
        try {
            X509EncodedKeySpec var1 = new X509EncodedKeySpec(var0);
            KeyFactory var2 = KeyFactory.getInstance(ASYMMETRIC_ALGORITHM);
            return var2.generatePublic(var1);
        }
        catch (Exception var1) {
            throw new CryptographyException(var1);
        }
    }

    public static SecretKey decryptByteToSecretKey(PrivateKey var0, byte[] var1) throws CryptographyException {
        byte[] var2 = MinecraftEncryption.decryptUsingKey(var0, var1);
        try {
            return new SecretKeySpec(var2, SYMMETRIC_ALGORITHM);
        }
        catch (Exception var3) {
            throw new CryptographyException(var3);
        }
    }

    public static byte[] encryptUsingKey(Key var0, byte[] var1) throws CryptographyException {
        return MinecraftEncryption.cipherData(1, var0, var1);
    }

    public static byte[] decryptUsingKey(Key var0, byte[] var1) throws CryptographyException {
        return MinecraftEncryption.cipherData(2, var0, var1);
    }

    private static byte[] cipherData(int var0, Key var1, byte[] var2) throws CryptographyException {
        try {
            return MinecraftEncryption.setupCipher(var0, var1.getAlgorithm(), var1).doFinal(var2);
        }
        catch (Exception var3) {
            throw new CryptographyException(var3);
        }
    }

    private static Cipher setupCipher(int var0, String var1, Key var2) throws Exception {
        Cipher var3 = Cipher.getInstance(var1);
        var3.init(var0, var2);
        return var3;
    }

    public static Cipher getCipher(int var0, Key var1) throws CryptographyException {
        try {
            Cipher var2 = Cipher.getInstance("AES/CFB8/NoPadding");
            var2.init(var0, var1, new IvParameterSpec(var1.getEncoded()));
            return var2;
        }
        catch (Exception var2) {
            throw new CryptographyException(var2);
        }
    }
}

