/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public class TagNetworkSerialization {
    public static Map<ResourceKey<? extends IRegistry<?>>, a> serializeTagsToNetwork(IRegistryCustom var02) {
        return var02.networkSafeRegistries().map(var0 -> Pair.of(var0.key(), (Object)TagNetworkSerialization.serializeToNetwork(var0.value()))).filter(var0 -> !((a)var0.getSecond()).isEmpty()).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    private static <T> a serializeToNetwork(IRegistry<T> var0) {
        HashMap<MinecraftKey, IntList> var1 = new HashMap<MinecraftKey, IntList>();
        var0.getTags().forEach(var2 -> {
            HolderSet var3 = (HolderSet)var2.getSecond();
            IntArrayList var4 = new IntArrayList(var3.size());
            for (Holder var6 : var3) {
                if (var6.kind() != Holder.b.REFERENCE) {
                    throw new IllegalStateException("Can't serialize unregistered value " + var6);
                }
                var4.add(var0.getId(var6.value()));
            }
            var1.put(((TagKey)var2.getFirst()).location(), (IntList)var4);
        });
        return new a(var1);
    }

    public static <T> void deserializeTagsFromNetwork(ResourceKey<? extends IRegistry<T>> var0, IRegistry<T> var1, a var2, b<T> var32) {
        var2.tags.forEach((var3, var4) -> {
            TagKey var5 = TagKey.create(var0, var3);
            List var6 = var4.intStream().mapToObj(var1::getHolder).flatMap(Optional::stream).toList();
            var32.accept(var5, var6);
        });
    }

    public static final class a {
        final Map<MinecraftKey, IntList> tags;

        a(Map<MinecraftKey, IntList> var0) {
            this.tags = var0;
        }

        public void write(PacketDataSerializer var0) {
            var0.writeMap(this.tags, PacketDataSerializer::writeResourceLocation, PacketDataSerializer::writeIntIdList);
        }

        public static a read(PacketDataSerializer var0) {
            return new a(var0.readMap(PacketDataSerializer::readResourceLocation, PacketDataSerializer::readIntIdList));
        }

        public boolean isEmpty() {
            return this.tags.isEmpty();
        }
    }

    @FunctionalInterface
    public static interface b<T> {
        public void accept(TagKey<T> var1, List<Holder<T>> var2);
    }
}

