/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;

public class Tag<T> {
    private static final Tag<?> EMPTY = new Tag(List.of());
    final List<T> elements;

    public Tag(Collection<T> var0) {
        this.elements = List.copyOf(var0);
    }

    public List<T> getValues() {
        return this.elements;
    }

    public static <T> Tag<T> empty() {
        return EMPTY;
    }

    static class f
    implements d {
        private final MinecraftKey id;

        public f(MinecraftKey var0) {
            this.id = var0;
        }

        @Override
        public <T> boolean build(Function<MinecraftKey, Tag<T>> var0, Function<MinecraftKey, T> var1, Consumer<T> var2) {
            Tag<T> var3 = var0.apply(this.id);
            if (var3 != null) {
                var3.elements.forEach(var2);
            }
            return true;
        }

        @Override
        public void serializeTo(JsonArray var0) {
            JsonObject var1 = new JsonObject();
            var1.addProperty("id", "#" + this.id);
            var1.addProperty("required", Boolean.valueOf(false));
            var0.add((JsonElement)var1);
        }

        public String toString() {
            return "#" + this.id + "?";
        }

        @Override
        public void visitOptionalDependencies(Consumer<MinecraftKey> var0) {
            var0.accept(this.id);
        }

        @Override
        public boolean verifyIfPresent(Predicate<MinecraftKey> var0, Predicate<MinecraftKey> var1) {
            return true;
        }
    }

    static class g
    implements d {
        private final MinecraftKey id;

        public g(MinecraftKey var0) {
            this.id = var0;
        }

        @Override
        public <T> boolean build(Function<MinecraftKey, Tag<T>> var0, Function<MinecraftKey, T> var1, Consumer<T> var2) {
            Tag<T> var3 = var0.apply(this.id);
            if (var3 == null) {
                return false;
            }
            var3.elements.forEach(var2);
            return true;
        }

        @Override
        public void serializeTo(JsonArray var0) {
            var0.add("#" + this.id);
        }

        public String toString() {
            return "#" + this.id;
        }

        @Override
        public boolean verifyIfPresent(Predicate<MinecraftKey> var0, Predicate<MinecraftKey> var1) {
            return var1.test(this.id);
        }

        @Override
        public void visitRequiredDependencies(Consumer<MinecraftKey> var0) {
            var0.accept(this.id);
        }
    }

    static class e
    implements d {
        private final MinecraftKey id;

        public e(MinecraftKey var0) {
            this.id = var0;
        }

        @Override
        public <T> boolean build(Function<MinecraftKey, Tag<T>> var0, Function<MinecraftKey, T> var1, Consumer<T> var2) {
            T var3 = var1.apply(this.id);
            if (var3 != null) {
                var2.accept(var3);
            }
            return true;
        }

        @Override
        public void serializeTo(JsonArray var0) {
            JsonObject var1 = new JsonObject();
            var1.addProperty("id", this.id.toString());
            var1.addProperty("required", Boolean.valueOf(false));
            var0.add((JsonElement)var1);
        }

        @Override
        public boolean verifyIfPresent(Predicate<MinecraftKey> var0, Predicate<MinecraftKey> var1) {
            return true;
        }

        public String toString() {
            return this.id + "?";
        }
    }

    static class c
    implements d {
        private final MinecraftKey id;

        public c(MinecraftKey var0) {
            this.id = var0;
        }

        @Override
        public <T> boolean build(Function<MinecraftKey, Tag<T>> var0, Function<MinecraftKey, T> var1, Consumer<T> var2) {
            T var3 = var1.apply(this.id);
            if (var3 == null) {
                return false;
            }
            var2.accept(var3);
            return true;
        }

        @Override
        public void serializeTo(JsonArray var0) {
            var0.add(this.id.toString());
        }

        @Override
        public boolean verifyIfPresent(Predicate<MinecraftKey> var0, Predicate<MinecraftKey> var1) {
            return var0.test(this.id);
        }

        public String toString() {
            return this.id.toString();
        }
    }

    public static interface d {
        public <T> boolean build(Function<MinecraftKey, Tag<T>> var1, Function<MinecraftKey, T> var2, Consumer<T> var3);

        public void serializeTo(JsonArray var1);

        default public void visitRequiredDependencies(Consumer<MinecraftKey> var0) {
        }

        default public void visitOptionalDependencies(Consumer<MinecraftKey> var0) {
        }

        public boolean verifyIfPresent(Predicate<MinecraftKey> var1, Predicate<MinecraftKey> var2);
    }

    public static class a {
        private final List<b> entries = new ArrayList<b>();

        public static a tag() {
            return new a();
        }

        public a add(b var0) {
            this.entries.add(var0);
            return this;
        }

        public a add(d var0, String var1) {
            return this.add(new b(var0, var1));
        }

        public a addElement(MinecraftKey var0, String var1) {
            return this.add(new c(var0), var1);
        }

        public a addOptionalElement(MinecraftKey var0, String var1) {
            return this.add(new e(var0), var1);
        }

        public a addTag(MinecraftKey var0, String var1) {
            return this.add(new g(var0), var1);
        }

        public a addOptionalTag(MinecraftKey var0, String var1) {
            return this.add(new f(var0), var1);
        }

        public <T> Either<Collection<b>, Tag<T>> build(Function<MinecraftKey, Tag<T>> var0, Function<MinecraftKey, T> var1) {
            ImmutableSet.Builder var2 = ImmutableSet.builder();
            ArrayList<b> var3 = new ArrayList<b>();
            for (b var5 : this.entries) {
                if (var5.entry().build(var0, var1, arg_0 -> ((ImmutableSet.Builder)var2).add(arg_0))) continue;
                var3.add(var5);
            }
            return var3.isEmpty() ? Either.right(new Tag(var2.build())) : Either.left(var3);
        }

        public Stream<b> getEntries() {
            return this.entries.stream();
        }

        public void visitRequiredDependencies(Consumer<MinecraftKey> var0) {
            this.entries.forEach(var1 -> var1.entry.visitRequiredDependencies(var0));
        }

        public void visitOptionalDependencies(Consumer<MinecraftKey> var0) {
            this.entries.forEach(var1 -> var1.entry.visitOptionalDependencies(var0));
        }

        public a addFromJson(JsonObject var0, String var12) {
            JsonArray var2 = ChatDeserializer.getAsJsonArray(var0, "values");
            ArrayList<d> var3 = new ArrayList<d>();
            for (JsonElement var5 : var2) {
                var3.add(a.parseEntry(var5));
            }
            if (ChatDeserializer.getAsBoolean(var0, "replace", false)) {
                this.entries.clear();
            }
            var3.forEach(var1 -> this.entries.add(new b((d)var1, var12)));
            return this;
        }

        private static d parseEntry(JsonElement var0) {
            boolean var2;
            String var1;
            Object var3;
            if (var0.isJsonObject()) {
                var3 = var0.getAsJsonObject();
                var1 = ChatDeserializer.getAsString(var3, "id");
                var2 = ChatDeserializer.getAsBoolean(var3, "required", true);
            } else {
                var1 = ChatDeserializer.convertToString(var0, "id");
                var2 = true;
            }
            if (var1.startsWith("#")) {
                var3 = new MinecraftKey(var1.substring(1));
                return var2 ? new g((MinecraftKey)var3) : new f((MinecraftKey)var3);
            }
            var3 = new MinecraftKey(var1);
            return var2 ? new c((MinecraftKey)var3) : new e((MinecraftKey)var3);
        }

        public JsonObject serializeToJson() {
            JsonObject var0 = new JsonObject();
            JsonArray var1 = new JsonArray();
            for (b var3 : this.entries) {
                var3.entry().serializeTo(var1);
            }
            var0.addProperty("replace", Boolean.valueOf(false));
            var0.add("values", (JsonElement)var1);
            return var0;
        }
    }

    public static final class b
    extends Record {
        final d entry;
        private final String source;

        public b(d var0, String var1) {
            this.entry = var0;
            this.source = var1;
        }

        @Override
        public String toString() {
            return this.entry + " (from " + this.source + ")";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "entry;source", "entry", "source"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "entry;source", "entry", "source"}, this, var0);
        }

        public d entry() {
            return this.entry;
        }

        public String source() {
            return this.source;
        }
    }
}

