/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon.thread;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.rcon.RemoteStatusReply;
import net.minecraft.server.rcon.StatusChallengeUtils;
import net.minecraft.server.rcon.thread.RemoteConnectionThread;
import org.slf4j.Logger;

public class RemoteStatusListener
extends RemoteConnectionThread {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String GAME_TYPE = "SMP";
    private static final String GAME_ID = "MINECRAFT";
    private static final long CHALLENGE_CHECK_INTERVAL = 30000L;
    private static final long RESPONSE_CACHE_TIME = 5000L;
    private long lastChallengeCheck;
    private final int port;
    private final int serverPort;
    private final int maxPlayers;
    private final String serverName;
    private final String worldName;
    private DatagramSocket socket;
    private final byte[] buffer = new byte[1460];
    private String hostIp;
    private String serverIp;
    private final Map<SocketAddress, RemoteStatusChallenge> validChallenges;
    private final RemoteStatusReply rulesResponse;
    private long lastRulesResponse;
    private final IMinecraftServer serverInterface;

    private RemoteStatusListener(IMinecraftServer var0, int var1) {
        super("Query Listener");
        this.serverInterface = var0;
        this.port = var1;
        this.serverIp = var0.getServerIp();
        this.serverPort = var0.getServerPort();
        this.serverName = var0.getServerName();
        this.maxPlayers = var0.getMaxPlayers();
        this.worldName = var0.getLevelIdName();
        this.lastRulesResponse = 0L;
        this.hostIp = "0.0.0.0";
        if (this.serverIp.isEmpty() || this.hostIp.equals(this.serverIp)) {
            this.serverIp = "0.0.0.0";
            try {
                InetAddress var2 = InetAddress.getLocalHost();
                this.hostIp = var2.getHostAddress();
            }
            catch (UnknownHostException var2) {
                LOGGER.warn("Unable to determine local host IP, please set server-ip in server.properties", (Throwable)var2);
            }
        } else {
            this.hostIp = this.serverIp;
        }
        this.rulesResponse = new RemoteStatusReply(1460);
        this.validChallenges = Maps.newHashMap();
    }

    @Nullable
    public static RemoteStatusListener create(IMinecraftServer var0) {
        int var1 = var0.getProperties().queryPort;
        if (0 >= var1 || 65535 < var1) {
            LOGGER.warn("Invalid query port {} found in server.properties (queries disabled)", (Object)var1);
            return null;
        }
        RemoteStatusListener var2 = new RemoteStatusListener(var0, var1);
        if (!var2.start()) {
            return null;
        }
        return var2;
    }

    private void sendTo(byte[] var0, DatagramPacket var1) throws IOException {
        this.socket.send(new DatagramPacket(var0, var0.length, var1.getSocketAddress()));
    }

    private boolean processPacket(DatagramPacket var0) throws IOException {
        byte[] var1 = var0.getData();
        int var2 = var0.getLength();
        SocketAddress var3 = var0.getSocketAddress();
        LOGGER.debug("Packet len {} [{}]", (Object)var2, (Object)var3);
        if (3 > var2 || -2 != var1[0] || -3 != var1[1]) {
            LOGGER.debug("Invalid packet [{}]", (Object)var3);
            return false;
        }
        LOGGER.debug("Packet '{}' [{}]", (Object)StatusChallengeUtils.toHexString(var1[2]), (Object)var3);
        switch (var1[2]) {
            case 9: {
                this.sendChallenge(var0);
                LOGGER.debug("Challenge [{}]", (Object)var3);
                return true;
            }
            case 0: {
                if (!this.validChallenge(var0).booleanValue()) {
                    LOGGER.debug("Invalid challenge [{}]", (Object)var3);
                    return false;
                }
                if (15 == var2) {
                    this.sendTo(this.buildRuleResponse(var0), var0);
                    LOGGER.debug("Rules [{}]", (Object)var3);
                    break;
                }
                RemoteStatusReply var4 = new RemoteStatusReply(1460);
                var4.write(0);
                var4.writeBytes(this.getIdentBytes(var0.getSocketAddress()));
                var4.writeString(this.serverName);
                var4.writeString(GAME_TYPE);
                var4.writeString(this.worldName);
                var4.writeString(Integer.toString(this.serverInterface.getPlayerCount()));
                var4.writeString(Integer.toString(this.maxPlayers));
                var4.writeShort((short)this.serverPort);
                var4.writeString(this.hostIp);
                this.sendTo(var4.toByteArray(), var0);
                LOGGER.debug("Status [{}]", (Object)var3);
            }
        }
        return true;
    }

    private byte[] buildRuleResponse(DatagramPacket var0) throws IOException {
        String[] var3;
        long var1 = SystemUtils.getMillis();
        if (var1 < this.lastRulesResponse + 5000L) {
            byte[] var32 = this.rulesResponse.toByteArray();
            byte[] var4 = this.getIdentBytes(var0.getSocketAddress());
            var32[1] = var4[0];
            var32[2] = var4[1];
            var32[3] = var4[2];
            var32[4] = var4[3];
            return var32;
        }
        this.lastRulesResponse = var1;
        this.rulesResponse.reset();
        this.rulesResponse.write(0);
        this.rulesResponse.writeBytes(this.getIdentBytes(var0.getSocketAddress()));
        this.rulesResponse.writeString("splitnum");
        this.rulesResponse.write(128);
        this.rulesResponse.write(0);
        this.rulesResponse.writeString("hostname");
        this.rulesResponse.writeString(this.serverName);
        this.rulesResponse.writeString("gametype");
        this.rulesResponse.writeString(GAME_TYPE);
        this.rulesResponse.writeString("game_id");
        this.rulesResponse.writeString(GAME_ID);
        this.rulesResponse.writeString("version");
        this.rulesResponse.writeString(this.serverInterface.getServerVersion());
        this.rulesResponse.writeString("plugins");
        this.rulesResponse.writeString(this.serverInterface.getPluginNames());
        this.rulesResponse.writeString("map");
        this.rulesResponse.writeString(this.worldName);
        this.rulesResponse.writeString("numplayers");
        this.rulesResponse.writeString("" + this.serverInterface.getPlayerCount());
        this.rulesResponse.writeString("maxplayers");
        this.rulesResponse.writeString("" + this.maxPlayers);
        this.rulesResponse.writeString("hostport");
        this.rulesResponse.writeString("" + this.serverPort);
        this.rulesResponse.writeString("hostip");
        this.rulesResponse.writeString(this.hostIp);
        this.rulesResponse.write(0);
        this.rulesResponse.write(1);
        this.rulesResponse.writeString("player_");
        this.rulesResponse.write(0);
        for (String var7 : var3 = this.serverInterface.getPlayerNames()) {
            this.rulesResponse.writeString(var7);
        }
        this.rulesResponse.write(0);
        return this.rulesResponse.toByteArray();
    }

    private byte[] getIdentBytes(SocketAddress var0) {
        return this.validChallenges.get(var0).getIdentBytes();
    }

    private Boolean validChallenge(DatagramPacket var0) {
        SocketAddress var1 = var0.getSocketAddress();
        if (!this.validChallenges.containsKey(var1)) {
            return false;
        }
        byte[] var2 = var0.getData();
        return this.validChallenges.get(var1).getChallenge() == StatusChallengeUtils.intFromNetworkByteArray(var2, 7, var0.getLength());
    }

    private void sendChallenge(DatagramPacket var0) throws IOException {
        RemoteStatusChallenge var1 = new RemoteStatusChallenge(var0);
        this.validChallenges.put(var0.getSocketAddress(), var1);
        this.sendTo(var1.getChallengeBytes(), var0);
    }

    private void pruneChallenges() {
        if (!this.running) {
            return;
        }
        long var0 = SystemUtils.getMillis();
        if (var0 < this.lastChallengeCheck + 30000L) {
            return;
        }
        this.lastChallengeCheck = var0;
        this.validChallenges.values().removeIf(var2 -> var2.before(var0));
    }

    @Override
    public void run() {
        LOGGER.info("Query running on {}:{}", (Object)this.serverIp, (Object)this.port);
        this.lastChallengeCheck = SystemUtils.getMillis();
        DatagramPacket var0 = new DatagramPacket(this.buffer, this.buffer.length);
        try {
            while (this.running) {
                try {
                    this.socket.receive(var0);
                    this.pruneChallenges();
                    this.processPacket(var0);
                }
                catch (SocketTimeoutException var1) {
                    this.pruneChallenges();
                }
                catch (PortUnreachableException var1) {
                }
                catch (IOException var1) {
                    this.recoverSocketError(var1);
                }
            }
        }
        finally {
            LOGGER.debug("closeSocket: {}:{}", (Object)this.serverIp, (Object)this.port);
            this.socket.close();
        }
    }

    @Override
    public boolean start() {
        if (this.running) {
            return true;
        }
        if (!this.initSocket()) {
            return false;
        }
        return super.start();
    }

    private void recoverSocketError(Exception var0) {
        if (!this.running) {
            return;
        }
        LOGGER.warn("Unexpected exception", (Throwable)var0);
        if (!this.initSocket()) {
            LOGGER.error("Failed to recover from exception, shutting down!");
            this.running = false;
        }
    }

    private boolean initSocket() {
        try {
            this.socket = new DatagramSocket(this.port, InetAddress.getByName(this.serverIp));
            this.socket.setSoTimeout(500);
            return true;
        }
        catch (Exception var0) {
            LOGGER.warn("Unable to initialise query system on {}:{}", new Object[]{this.serverIp, this.port, var0});
            return false;
        }
    }

    static class RemoteStatusChallenge {
        private final long time = new Date().getTime();
        private final int challenge;
        private final byte[] identBytes;
        private final byte[] challengeBytes;
        private final String ident;

        public RemoteStatusChallenge(DatagramPacket var0) {
            byte[] var1 = var0.getData();
            this.identBytes = new byte[4];
            this.identBytes[0] = var1[3];
            this.identBytes[1] = var1[4];
            this.identBytes[2] = var1[5];
            this.identBytes[3] = var1[6];
            this.ident = new String(this.identBytes, StandardCharsets.UTF_8);
            this.challenge = new Random().nextInt(0x1000000);
            this.challengeBytes = String.format("\t%s%d\u0000", this.ident, this.challenge).getBytes(StandardCharsets.UTF_8);
        }

        public Boolean before(long var0) {
            return this.time < var0;
        }

        public int getChallenge() {
            return this.challenge;
        }

        public byte[] getChallengeBytes() {
            return this.challengeBytes;
        }

        public byte[] getIdentBytes() {
            return this.identBytes;
        }

        public String getIdent() {
            return this.ident;
        }
    }
}

