/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.ExpirableListEntry;

public class GameProfileBanEntry
extends ExpirableListEntry<GameProfile> {
    public GameProfileBanEntry(GameProfile var0) {
        this(var0, (Date)null, (String)null, (Date)null, (String)null);
    }

    public GameProfileBanEntry(GameProfile var0, @Nullable Date var1, @Nullable String var2, @Nullable Date var3, @Nullable String var4) {
        super(var0, var1, var2, var3, var4);
    }

    public GameProfileBanEntry(JsonObject var0) {
        super(GameProfileBanEntry.createGameProfile(var0), var0);
    }

    @Override
    protected void serialize(JsonObject var0) {
        if (this.getUser() == null) {
            return;
        }
        var0.addProperty("uuid", ((GameProfile)this.getUser()).getId() == null ? "" : ((GameProfile)this.getUser()).getId().toString());
        var0.addProperty("name", ((GameProfile)this.getUser()).getName());
        super.serialize(var0);
    }

    @Override
    public IChatBaseComponent getDisplayName() {
        GameProfile var0 = (GameProfile)this.getUser();
        return new ChatComponentText(var0.getName() != null ? var0.getName() : Objects.toString(var0.getId(), "(Unknown)"));
    }

    private static GameProfile createGameProfile(JsonObject var0) {
        UUID var2;
        if (!var0.has("uuid") || !var0.has("name")) {
            return null;
        }
        String var1 = var0.get("uuid").getAsString();
        try {
            var2 = UUID.fromString(var1);
        }
        catch (Throwable var3) {
            return null;
        }
        return new GameProfile(var2, var0.get("name").getAsString());
    }
}

