/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerFallback;

public class ResourceManager
implements IReloadableResourceManager {
    private final Map<String, ResourceManagerFallback> namespacedManagers;
    private final List<IResourcePack> packs;

    public ResourceManager(EnumResourcePackType var0, List<IResourcePack> var12) {
        this.packs = List.copyOf(var12);
        HashMap<String, ResourceManagerFallback> var2 = new HashMap<String, ResourceManagerFallback>();
        for (IResourcePack var4 : var12) {
            for (String var6 : var4.getNamespaces(var0)) {
                var2.computeIfAbsent(var6, var1 -> new ResourceManagerFallback(var0, (String)var1)).add(var4);
            }
        }
        this.namespacedManagers = var2;
    }

    @Override
    public Set<String> getNamespaces() {
        return this.namespacedManagers.keySet();
    }

    @Override
    public IResource getResource(MinecraftKey var0) throws IOException {
        IResourceManager var1 = this.namespacedManagers.get(var0.getNamespace());
        if (var1 != null) {
            return var1.getResource(var0);
        }
        throw new FileNotFoundException(var0.toString());
    }

    @Override
    public boolean hasResource(MinecraftKey var0) {
        IResourceManager var1 = this.namespacedManagers.get(var0.getNamespace());
        if (var1 != null) {
            return var1.hasResource(var0);
        }
        return false;
    }

    @Override
    public List<IResource> getResources(MinecraftKey var0) throws IOException {
        IResourceManager var1 = this.namespacedManagers.get(var0.getNamespace());
        if (var1 != null) {
            return var1.getResources(var0);
        }
        throw new FileNotFoundException(var0.toString());
    }

    @Override
    public Collection<MinecraftKey> listResources(String var0, Predicate<String> var1) {
        HashSet var2 = Sets.newHashSet();
        for (ResourceManagerFallback var4 : this.namespacedManagers.values()) {
            var2.addAll(var4.listResources(var0, var1));
        }
        ArrayList var3 = Lists.newArrayList((Iterable)var2);
        Collections.sort(var3);
        return var3;
    }

    @Override
    public Stream<IResourcePack> listPacks() {
        return this.packs.stream();
    }

    @Override
    public void close() {
        this.packs.forEach(IResourcePack::close);
    }
}

