/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.ResourceProvider;

public interface IResourceManager
extends ResourceProvider {
    public Set<String> getNamespaces();

    public boolean hasResource(MinecraftKey var1);

    public List<IResource> getResources(MinecraftKey var1) throws IOException;

    public Collection<MinecraftKey> listResources(String var1, Predicate<String> var2);

    public Stream<IResourcePack> listPacks();

    public static final class Empty
    extends Enum<Empty>
    implements IResourceManager {
        public static final /* enum */ Empty INSTANCE = new Empty();
        private static final /* synthetic */ Empty[] b;

        public static Empty[] values() {
            return (Empty[])b.clone();
        }

        public static Empty valueOf(String var0) {
            return Enum.valueOf(Empty.class, var0);
        }

        @Override
        public Set<String> getNamespaces() {
            return ImmutableSet.of();
        }

        @Override
        public IResource getResource(MinecraftKey var0) throws IOException {
            throw new FileNotFoundException(var0.toString());
        }

        @Override
        public boolean hasResource(MinecraftKey var0) {
            return false;
        }

        @Override
        public List<IResource> getResources(MinecraftKey var0) {
            return ImmutableList.of();
        }

        @Override
        public Collection<MinecraftKey> listResources(String var0, Predicate<String> var1) {
            return ImmutableSet.of();
        }

        @Override
        public Stream<IResourcePack> listPacks() {
            return Stream.of(new IResourcePack[0]);
        }

        private static /* synthetic */ Empty[] c() {
            return new Empty[]{INSTANCE};
        }

        static {
            b = Empty.c();
        }
    }
}

