/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.ResourceNotFoundException;
import net.minecraft.server.packs.ResourcePackAbstract;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.slf4j.Logger;

public class ResourcePackFolder
extends ResourcePackAbstract {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean ON_WINDOWS = SystemUtils.getPlatform() == SystemUtils.OS.WINDOWS;
    private static final CharMatcher BACKSLASH_MATCHER = CharMatcher.is((char)'\\');

    public ResourcePackFolder(File var0) {
        super(var0);
    }

    public static boolean validatePath(File var0, String var1) throws IOException {
        String var2 = var0.getCanonicalPath();
        if (ON_WINDOWS) {
            var2 = BACKSLASH_MATCHER.replaceFrom((CharSequence)var2, '/');
        }
        return var2.endsWith(var1);
    }

    @Override
    protected InputStream getResource(String var0) throws IOException {
        File var1 = this.getFile(var0);
        if (var1 == null) {
            throw new ResourceNotFoundException(this.file, var0);
        }
        return new FileInputStream(var1);
    }

    @Override
    protected boolean hasResource(String var0) {
        return this.getFile(var0) != null;
    }

    @Nullable
    private File getFile(String var0) {
        try {
            File var1 = new File(this.file, var0);
            if (var1.isFile() && ResourcePackFolder.validatePath(var1, var0)) {
                return var1;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Set<String> getNamespaces(EnumResourcePackType var0) {
        HashSet var1 = Sets.newHashSet();
        File var2 = new File(this.file, var0.getDirectory());
        File[] var3 = var2.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        if (var3 != null) {
            for (File var7 : var3) {
                String var8 = ResourcePackFolder.getRelativePath(var2, var7);
                if (var8.equals(var8.toLowerCase(Locale.ROOT))) {
                    var1.add(var8.substring(0, var8.length() - 1));
                    continue;
                }
                this.logWarning(var8);
            }
        }
        return var1;
    }

    @Override
    public void close() {
    }

    @Override
    public Collection<MinecraftKey> getResources(EnumResourcePackType var0, String var1, String var2, int var3, Predicate<String> var4) {
        File var5 = new File(this.file, var0.getDirectory());
        ArrayList var6 = Lists.newArrayList();
        this.listResources(new File(new File(var5, var1), var2), var3, var1, var6, var2 + "/", var4);
        return var6;
    }

    private void listResources(File var0, int var1, String var2, List<MinecraftKey> var3, String var4, Predicate<String> var5) {
        File[] var6 = var0.listFiles();
        if (var6 != null) {
            for (File var10 : var6) {
                if (var10.isDirectory()) {
                    if (var1 <= 0) continue;
                    this.listResources(var10, var1 - 1, var2, var3, var4 + var10.getName() + "/", var5);
                    continue;
                }
                if (var10.getName().endsWith(".mcmeta") || !var5.test(var10.getName())) continue;
                try {
                    var3.add(new MinecraftKey(var2, var4 + var10.getName()));
                }
                catch (ResourceKeyInvalidException var11) {
                    LOGGER.error(var11.getMessage());
                }
            }
        }
    }
}

