/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.logging.LogUtils;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.login.PacketLoginInCustomPayload;
import net.minecraft.network.protocol.login.PacketLoginInEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.network.protocol.login.PacketLoginInStart;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginOutSetCompression;
import net.minecraft.network.protocol.login.PacketLoginOutSuccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.world.entity.player.EntityHuman;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class LoginListener
implements PacketLoginInListener {
    private static final AtomicInteger UNIQUE_THREAD_ID = new AtomicInteger(0);
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TICKS_BEFORE_LOGIN = 600;
    private static final Random RANDOM = new Random();
    private final byte[] nonce = new byte[4];
    final MinecraftServer server;
    public final NetworkManager connection;
    EnumProtocolState state = EnumProtocolState.HELLO;
    private int tick;
    @Nullable
    GameProfile gameProfile;
    private final String serverId = "";
    @Nullable
    private EntityPlayer delayedAcceptPlayer;

    public LoginListener(MinecraftServer var0, NetworkManager var1) {
        this.server = var0;
        this.connection = var1;
        RANDOM.nextBytes(this.nonce);
    }

    public void tick() {
        EntityPlayer var0;
        if (this.state == EnumProtocolState.READY_TO_ACCEPT) {
            this.handleAcceptedLogin();
        } else if (this.state == EnumProtocolState.DELAY_ACCEPT && (var0 = this.server.getPlayerList().getPlayer(this.gameProfile.getId())) == null) {
            this.state = EnumProtocolState.READY_TO_ACCEPT;
            this.placeNewPlayer(this.delayedAcceptPlayer);
            this.delayedAcceptPlayer = null;
        }
        if (this.tick++ == 600) {
            this.disconnect(new ChatMessage("multiplayer.disconnect.slow_login"));
        }
    }

    @Override
    public NetworkManager getConnection() {
        return this.connection;
    }

    public void disconnect(IChatBaseComponent var0) {
        try {
            LOGGER.info("Disconnecting {}: {}", (Object)this.getUserName(), (Object)var0.getString());
            this.connection.send(new PacketLoginOutDisconnect(var0));
            this.connection.disconnect(var0);
        }
        catch (Exception var1) {
            LOGGER.error("Error whilst disconnecting player", (Throwable)var1);
        }
    }

    public void handleAcceptedLogin() {
        IChatBaseComponent var02;
        if (!this.gameProfile.isComplete()) {
            this.gameProfile = this.createFakeProfile(this.gameProfile);
        }
        if ((var02 = this.server.getPlayerList().canPlayerLogin(this.connection.getRemoteAddress(), this.gameProfile)) != null) {
            this.disconnect(var02);
        } else {
            this.state = EnumProtocolState.ACCEPTED;
            if (this.server.getCompressionThreshold() >= 0 && !this.connection.isMemoryConnection()) {
                this.connection.send(new PacketLoginOutSetCompression(this.server.getCompressionThreshold()), (GenericFutureListener<? extends Future<? super Void>>)((ChannelFutureListener)var0 -> this.connection.setupCompression(this.server.getCompressionThreshold(), true)));
            }
            this.connection.send(new PacketLoginOutSuccess(this.gameProfile));
            EntityPlayer var1 = this.server.getPlayerList().getPlayer(this.gameProfile.getId());
            try {
                EntityPlayer var2 = this.server.getPlayerList().getPlayerForLogin(this.gameProfile);
                if (var1 != null) {
                    this.state = EnumProtocolState.DELAY_ACCEPT;
                    this.delayedAcceptPlayer = var2;
                } else {
                    this.placeNewPlayer(var2);
                }
            }
            catch (Exception var2) {
                LOGGER.error("Couldn't place player in world", (Throwable)var2);
                ChatMessage var3 = new ChatMessage("multiplayer.disconnect.invalid_player_data");
                this.connection.send(new PacketPlayOutKickDisconnect(var3));
                this.connection.disconnect(var3);
            }
        }
    }

    private void placeNewPlayer(EntityPlayer var0) {
        this.server.getPlayerList().placeNewPlayer(this.connection, var0);
    }

    @Override
    public void onDisconnect(IChatBaseComponent var0) {
        LOGGER.info("{} lost connection: {}", (Object)this.getUserName(), (Object)var0.getString());
    }

    public String getUserName() {
        if (this.gameProfile != null) {
            return this.gameProfile + " (" + this.connection.getRemoteAddress() + ")";
        }
        return String.valueOf(this.connection.getRemoteAddress());
    }

    @Override
    public void handleHello(PacketLoginInStart var0) {
        Validate.validState((this.state == EnumProtocolState.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        this.gameProfile = var0.getGameProfile();
        Validate.validState((boolean)LoginListener.isValidUsername(this.gameProfile.getName()), (String)"Invalid characters in username", (Object[])new Object[0]);
        if (this.server.usesAuthentication() && !this.connection.isMemoryConnection()) {
            this.state = EnumProtocolState.KEY;
            this.connection.send(new PacketLoginOutEncryptionBegin("", this.server.getKeyPair().getPublic().getEncoded(), this.nonce));
        } else {
            this.state = EnumProtocolState.READY_TO_ACCEPT;
        }
    }

    public static boolean isValidUsername(String var02) {
        return var02.chars().filter(var0 -> var0 <= 32 || var0 >= 127).findAny().isEmpty();
    }

    @Override
    public void handleKey(PacketLoginInEncryptionBegin var0) {
        String var2;
        Object var3;
        Validate.validState((this.state == EnumProtocolState.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        PrivateKey var1 = this.server.getKeyPair().getPrivate();
        try {
            if (!Arrays.equals(this.nonce, var0.getNonce(var1))) {
                throw new IllegalStateException("Protocol error");
            }
            var3 = var0.getSecretKey(var1);
            Cipher var4 = MinecraftEncryption.getCipher(2, (Key)var3);
            Cipher var5 = MinecraftEncryption.getCipher(1, (Key)var3);
            var2 = new BigInteger(MinecraftEncryption.digestData("", this.server.getKeyPair().getPublic(), (SecretKey)var3)).toString(16);
            this.state = EnumProtocolState.AUTHENTICATING;
            this.connection.setEncryptionKey(var4, var5);
        }
        catch (CryptographyException var32) {
            throw new IllegalStateException("Protocol error", var32);
        }
        var3 = new Thread("User Authenticator #" + UNIQUE_THREAD_ID.incrementAndGet()){

            @Override
            public void run() {
                GameProfile var0 = LoginListener.this.gameProfile;
                try {
                    LoginListener.this.gameProfile = LoginListener.this.server.getSessionService().hasJoinedServer(new GameProfile(null, var0.getName()), var2, this.getAddress());
                    if (LoginListener.this.gameProfile != null) {
                        LOGGER.info("UUID of player {} is {}", (Object)LoginListener.this.gameProfile.getName(), (Object)LoginListener.this.gameProfile.getId());
                        LoginListener.this.state = EnumProtocolState.READY_TO_ACCEPT;
                    } else if (LoginListener.this.server.isSingleplayer()) {
                        LOGGER.warn("Failed to verify username but will let them in anyway!");
                        LoginListener.this.gameProfile = LoginListener.this.createFakeProfile(var0);
                        LoginListener.this.state = EnumProtocolState.READY_TO_ACCEPT;
                    } else {
                        LoginListener.this.disconnect(new ChatMessage("multiplayer.disconnect.unverified_username"));
                        LOGGER.error("Username '{}' tried to join with an invalid session", (Object)var0.getName());
                    }
                }
                catch (AuthenticationUnavailableException var1) {
                    if (LoginListener.this.server.isSingleplayer()) {
                        LOGGER.warn("Authentication servers are down but will let them in anyway!");
                        LoginListener.this.gameProfile = LoginListener.this.createFakeProfile(var0);
                        LoginListener.this.state = EnumProtocolState.READY_TO_ACCEPT;
                    }
                    LoginListener.this.disconnect(new ChatMessage("multiplayer.disconnect.authservers_down"));
                    LOGGER.error("Couldn't verify username because servers are unavailable");
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress var0 = LoginListener.this.connection.getRemoteAddress();
                return LoginListener.this.server.getPreventProxyConnections() && var0 instanceof InetSocketAddress ? ((InetSocketAddress)var0).getAddress() : null;
            }
        };
        ((Thread)var3).setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        ((Thread)var3).start();
    }

    @Override
    public void handleCustomQueryPacket(PacketLoginInCustomPayload var0) {
        this.disconnect(new ChatMessage("multiplayer.disconnect.unexpected_query_response"));
    }

    protected GameProfile createFakeProfile(GameProfile var0) {
        UUID var1 = EntityHuman.createPlayerUUID(var0.getName());
        return new GameProfile(var1, var0.getName());
    }

    static final class EnumProtocolState
    extends Enum<EnumProtocolState> {
        public static final /* enum */ EnumProtocolState HELLO = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState KEY = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState AUTHENTICATING = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState NEGOTIATING = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState READY_TO_ACCEPT = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState DELAY_ACCEPT = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState ACCEPTED = new EnumProtocolState();
        private static final /* synthetic */ EnumProtocolState[] h;

        public static EnumProtocolState[] values() {
            return (EnumProtocolState[])h.clone();
        }

        public static EnumProtocolState valueOf(String var0) {
            return Enum.valueOf(EnumProtocolState.class, var0);
        }

        private static /* synthetic */ EnumProtocolState[] a() {
            return new EnumProtocolState[]{HELLO, KEY, AUTHENTICATING, NEGOTIATING, READY_TO_ACCEPT, DELAY_ACCEPT, ACCEPTED};
        }

        static {
            h = EnumProtocolState.a();
        }
    }
}

