/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.Objects;
import net.minecraft.server.level.TicketType;

public final class Ticket<T>
implements Comparable<Ticket<?>> {
    private final TicketType<T> type;
    private final int ticketLevel;
    public final T key;
    private long createdTick;

    protected Ticket(TicketType<T> var0, int var1, T var2) {
        this.type = var0;
        this.ticketLevel = var1;
        this.key = var2;
    }

    @Override
    public int compareTo(Ticket<?> var0) {
        int var1 = Integer.compare(this.ticketLevel, var0.ticketLevel);
        if (var1 != 0) {
            return var1;
        }
        int var2 = Integer.compare(System.identityHashCode(this.type), System.identityHashCode(var0.type));
        if (var2 != 0) {
            return var2;
        }
        return this.type.getComparator().compare(this.key, var0.key);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof Ticket)) {
            return false;
        }
        Ticket var1 = (Ticket)var0;
        return this.ticketLevel == var1.ticketLevel && Objects.equals(this.type, var1.type) && Objects.equals(this.key, var1.key);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.ticketLevel, this.key);
    }

    public String toString() {
        return "Ticket[" + this.type + " " + this.ticketLevel + " (" + this.key + ")] at " + this.createdTick;
    }

    public TicketType<T> getType() {
        return this.type;
    }

    public int getTicketLevel() {
        return this.ticketLevel;
    }

    protected void setCreatedTick(long var0) {
        this.createdTick = var0;
    }

    protected boolean timedOut(long var0) {
        long var2 = this.type.timeout();
        return var2 != 0L && var0 - this.createdTick > var2;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((Ticket)object);
    }
}

