/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;

public class BlockPosition2D {
    private static final long COORD_BITS = 32L;
    private static final long COORD_MASK = 0xFFFFFFFFL;
    private static final int HASH_A = 1664525;
    private static final int HASH_C = 1013904223;
    private static final int HASH_Z_XOR = -559038737;
    public final int x;
    public final int z;

    public BlockPosition2D(int var0, int var1) {
        this.x = var0;
        this.z = var1;
    }

    public BlockPosition2D(BlockPosition var0) {
        this.x = var0.getX();
        this.z = var0.getZ();
    }

    public ChunkCoordIntPair toChunkPos() {
        return new ChunkCoordIntPair(SectionPosition.blockToSectionCoord(this.x), SectionPosition.blockToSectionCoord(this.z));
    }

    public long toLong() {
        return BlockPosition2D.asLong(this.x, this.z);
    }

    public static long asLong(int var0, int var1) {
        return (long)var0 & 0xFFFFFFFFL | ((long)var1 & 0xFFFFFFFFL) << 32;
    }

    public String toString() {
        return "[" + this.x + ", " + this.z + "]";
    }

    public int hashCode() {
        int var0 = 1664525 * this.x + 1013904223;
        int var1 = 1664525 * (this.z ^ 0xDEADBEEF) + 1013904223;
        return var0 ^ var1;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof BlockPosition2D) {
            BlockPosition2D var1 = (BlockPosition2D)var0;
            return this.x == var1.x && this.z == var1.z;
        }
        return false;
    }
}

