/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.storage.WorldNBTStorage;
import org.slf4j.Logger;

public class DedicatedPlayerList
extends PlayerList {
    private static final Logger LOGGER = LogUtils.getLogger();

    public DedicatedPlayerList(DedicatedServer var0, IRegistryCustom.Dimension var1, WorldNBTStorage var2) {
        super(var0, var1, var2, var0.getProperties().maxPlayers);
        DedicatedServerProperties var3 = var0.getProperties();
        this.setViewDistance(var3.viewDistance);
        this.setSimulationDistance(var3.simulationDistance);
        super.setUsingWhiteList(var3.whiteList.get());
        this.loadUserBanList();
        this.saveUserBanList();
        this.loadIpBanList();
        this.saveIpBanList();
        this.loadOps();
        this.loadWhiteList();
        this.saveOps();
        if (!this.getWhiteList().getFile().exists()) {
            this.saveWhiteList();
        }
    }

    @Override
    public void setUsingWhiteList(boolean var0) {
        super.setUsingWhiteList(var0);
        this.getServer().storeUsingWhiteList(var0);
    }

    @Override
    public void op(GameProfile var0) {
        super.op(var0);
        this.saveOps();
    }

    @Override
    public void deop(GameProfile var0) {
        super.deop(var0);
        this.saveOps();
    }

    @Override
    public void reloadWhiteList() {
        this.loadWhiteList();
    }

    private void saveIpBanList() {
        try {
            this.getIpBans().save();
        }
        catch (IOException var0) {
            LOGGER.warn("Failed to save ip banlist: ", (Throwable)var0);
        }
    }

    private void saveUserBanList() {
        try {
            this.getBans().save();
        }
        catch (IOException var0) {
            LOGGER.warn("Failed to save user banlist: ", (Throwable)var0);
        }
    }

    private void loadIpBanList() {
        try {
            this.getIpBans().load();
        }
        catch (IOException var0) {
            LOGGER.warn("Failed to load ip banlist: ", (Throwable)var0);
        }
    }

    private void loadUserBanList() {
        try {
            this.getBans().load();
        }
        catch (IOException var0) {
            LOGGER.warn("Failed to load user banlist: ", (Throwable)var0);
        }
    }

    private void loadOps() {
        try {
            this.getOps().load();
        }
        catch (Exception var0) {
            LOGGER.warn("Failed to load operators list: ", (Throwable)var0);
        }
    }

    private void saveOps() {
        try {
            this.getOps().save();
        }
        catch (Exception var0) {
            LOGGER.warn("Failed to save operators list: ", (Throwable)var0);
        }
    }

    private void loadWhiteList() {
        try {
            this.getWhiteList().load();
        }
        catch (Exception var0) {
            LOGGER.warn("Failed to load white-list: ", (Throwable)var0);
        }
    }

    private void saveWhiteList() {
        try {
            this.getWhiteList().save();
        }
        catch (Exception var0) {
            LOGGER.warn("Failed to save white-list: ", (Throwable)var0);
        }
    }

    @Override
    public boolean isWhiteListed(GameProfile var0) {
        return !this.isUsingWhitelist() || this.isOp(var0) || this.getWhiteList().isWhiteListed(var0);
    }

    @Override
    public DedicatedServer getServer() {
        return (DedicatedServer)super.getServer();
    }

    @Override
    public boolean canBypassPlayerLimit(GameProfile var0) {
        return this.getOps().canBypassPlayerLimit(var0);
    }

    @Override
    public /* synthetic */ MinecraftServer getServer() {
        return this.getServer();
    }
}

