/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;

public class PlaceFeatureCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)new ChatMessage("commands.placefeature.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("placefeature").requires(var0 -> var0.hasPermission(2))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("feature", ResourceKeyArgument.key(IRegistry.CONFIGURED_FEATURE_REGISTRY)).executes(var0 -> PlaceFeatureCommand.placeFeature((CommandListenerWrapper)var0.getSource(), ResourceKeyArgument.getConfiguredFeature((CommandContext<CommandListenerWrapper>)var0, "feature"), new BlockPosition(((CommandListenerWrapper)var0.getSource()).getPosition())))).then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).executes(var0 -> PlaceFeatureCommand.placeFeature((CommandListenerWrapper)var0.getSource(), ResourceKeyArgument.getConfiguredFeature((CommandContext<CommandListenerWrapper>)var0, "feature"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"))))));
    }

    public static int placeFeature(CommandListenerWrapper var02, Holder<WorldGenFeatureConfigured<?, ?>> var1, BlockPosition var2) throws CommandSyntaxException {
        WorldServer var3 = var02.getLevel();
        WorldGenFeatureConfigured<?, ?> var4 = var1.value();
        if (!var4.place(var3, var3.getChunkSource().getGenerator(), var3.getRandom(), var2)) {
            throw ERROR_FAILED.create();
        }
        String var5 = var1.unwrapKey().map(var0 -> var0.location().toString()).orElse("[unregistered]");
        var02.sendSuccess(new ChatMessage("commands.placefeature.success", var5, var2.getX(), var2.getY(), var2.getZ()), true);
        return 1;
    }
}

