/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceOrTagLocationArgument;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.commands.CommandLocate;
import net.minecraft.world.level.biome.BiomeBase;

public class CommandLocateBiome {
    private static final DynamicCommandExceptionType ERROR_BIOME_NOT_FOUND = new DynamicCommandExceptionType(var0 -> new ChatMessage("commands.locatebiome.notFound", var0));
    private static final int MAX_SEARCH_RADIUS = 6400;
    private static final int SEARCH_STEP = 8;

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("locatebiome").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("biome", ResourceOrTagLocationArgument.resourceOrTag(IRegistry.BIOME_REGISTRY)).executes(var0 -> CommandLocateBiome.locateBiome((CommandListenerWrapper)var0.getSource(), ResourceOrTagLocationArgument.getBiome((CommandContext<CommandListenerWrapper>)var0, "biome")))));
    }

    private static int locateBiome(CommandListenerWrapper var0, ResourceOrTagLocationArgument.b<BiomeBase> var1) throws CommandSyntaxException {
        BlockPosition var2 = new BlockPosition(var0.getPosition());
        Pair<BlockPosition, Holder<BiomeBase>> var3 = var0.getLevel().findNearestBiome(var1, var2, 6400, 8);
        if (var3 == null) {
            throw ERROR_BIOME_NOT_FOUND.create((Object)var1.asPrintable());
        }
        return CommandLocate.showLocateResult(var0, var1, var2, var3, "commands.locatebiome.success");
    }
}

