/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceOrTagLocationArgument;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.feature.StructureFeature;

public class CommandLocate {
    private static final DynamicCommandExceptionType ERROR_FAILED = new DynamicCommandExceptionType(var0 -> new ChatMessage("commands.locate.failed", var0));
    private static final DynamicCommandExceptionType ERROR_INVALID = new DynamicCommandExceptionType(var0 -> new ChatMessage("commands.locate.invalid", var0));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("locate").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("structure", ResourceOrTagLocationArgument.resourceOrTag(IRegistry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY)).executes(var0 -> CommandLocate.locate((CommandListenerWrapper)var0.getSource(), ResourceOrTagLocationArgument.getStructureFeature((CommandContext<CommandListenerWrapper>)var0, "structure")))));
    }

    private static int locate(CommandListenerWrapper var0, ResourceOrTagLocationArgument.b<StructureFeature<?, ?>> var12) throws CommandSyntaxException {
        IRegistry<StructureFeature<?, ?>> var2 = var0.getLevel().registryAccess().registryOrThrow(IRegistry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY);
        HolderSet var3 = (HolderSet)((Optional)var12.unwrap().map(var1 -> var2.getHolder((ResourceKey<StructureFeature<?, ?>>)var1).map(var0 -> HolderSet.direct(var0)), var2::getTag)).orElseThrow(() -> ERROR_INVALID.create((Object)var12.asPrintable()));
        BlockPosition var4 = new BlockPosition(var0.getPosition());
        WorldServer var5 = var0.getLevel();
        Pair<BlockPosition, Holder<StructureFeature<?, ?>>> var6 = var5.getChunkSource().getGenerator().findNearestMapFeature(var5, var3, var4, 100, false);
        if (var6 == null) {
            throw ERROR_FAILED.create((Object)var12.asPrintable());
        }
        return CommandLocate.showLocateResult(var0, var12, var4, var6, "commands.locate.success");
    }

    public static int showLocateResult(CommandListenerWrapper var02, ResourceOrTagLocationArgument.b<?> var12, BlockPosition var2, Pair<BlockPosition, ? extends Holder<?>> var3, String var4) {
        BlockPosition var5 = (BlockPosition)var3.getFirst();
        String var6 = (String)var12.unwrap().map(var0 -> var0.location().toString(), var1 -> "#" + var1.location() + " (" + ((Holder)var3.getSecond()).unwrapKey().map(var0 -> var0.location().toString()).orElse("[unregistered]") + ")");
        int var7 = MathHelper.floor(CommandLocate.dist(var2.getX(), var2.getZ(), var5.getX(), var5.getZ()));
        IChatMutableComponent var8 = ChatComponentUtils.wrapInSquareBrackets(new ChatMessage("chat.coordinates", var5.getX(), "~", var5.getZ())).withStyle(var1 -> var1.withColor(EnumChatFormat.GREEN).withClickEvent(new ChatClickable(ChatClickable.EnumClickAction.SUGGEST_COMMAND, "/tp @s " + var5.getX() + " ~ " + var5.getZ())).withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, new ChatMessage("chat.coordinates.tooltip"))));
        var02.sendSuccess(new ChatMessage(var4, var6, var8, var7), false);
        return var7;
    }

    private static float dist(int var0, int var1, int var2, int var3) {
        int var4 = var2 - var0;
        int var5 = var3 - var1;
        return MathHelper.sqrt(var4 * var4 + var5 * var5);
    }
}

