/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.CustomFunctionData;

public class CommandFunction {
    public static final SuggestionProvider<CommandListenerWrapper> SUGGEST_FUNCTION = (var0, var1) -> {
        CustomFunctionData var2 = ((CommandListenerWrapper)var0.getSource()).getServer().getFunctions();
        ICompletionProvider.suggestResource(var2.getTagNames(), var1, "#");
        return ICompletionProvider.suggestResource(var2.getFunctionNames(), var1);
    };

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("function").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("name", ArgumentTag.functions()).suggests(SUGGEST_FUNCTION).executes(var0 -> CommandFunction.runFunction((CommandListenerWrapper)var0.getSource(), ArgumentTag.getFunctions((CommandContext<CommandListenerWrapper>)var0, "name")))));
    }

    private static int runFunction(CommandListenerWrapper var0, Collection<CustomFunction> var1) {
        int var2 = 0;
        for (CustomFunction var4 : var1) {
            var2 += var0.getServer().getFunctions().execute(var4, var0.withSuppressedOutput().withMaximumPermission(2));
        }
        if (var1.size() == 1) {
            var0.sendSuccess(new ChatMessage("commands.function.success.single", var2, var1.iterator().next().getId()), true);
        } else {
            var0.sendSuccess(new ChatMessage("commands.function.success.multiple", var2, var1.size()), true);
        }
        return var2;
    }
}

