/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEnchantment;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;

public class CommandEnchant {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(var0 -> new ChatMessage("commands.enchant.failed.entity", var0));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(var0 -> new ChatMessage("commands.enchant.failed.itemless", var0));
    private static final DynamicCommandExceptionType ERROR_INCOMPATIBLE = new DynamicCommandExceptionType(var0 -> new ChatMessage("commands.enchant.failed.incompatible", var0));
    private static final Dynamic2CommandExceptionType ERROR_LEVEL_TOO_HIGH = new Dynamic2CommandExceptionType((var0, var1) -> new ChatMessage("commands.enchant.failed.level", var0, var1));
    private static final SimpleCommandExceptionType ERROR_NOTHING_HAPPENED = new SimpleCommandExceptionType((Message)new ChatMessage("commands.enchant.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("enchant").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("enchantment", ArgumentEnchantment.enchantment()).executes(var0 -> CommandEnchant.enchant((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentEnchantment.getEnchantment((CommandContext<CommandListenerWrapper>)var0, "enchantment"), 1))).then(net.minecraft.commands.CommandDispatcher.argument("level", IntegerArgumentType.integer((int)0)).executes(var0 -> CommandEnchant.enchant((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentEnchantment.getEnchantment((CommandContext<CommandListenerWrapper>)var0, "enchantment"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"level")))))));
    }

    private static int enchant(CommandListenerWrapper var0, Collection<? extends Entity> var1, Enchantment var2, int var3) throws CommandSyntaxException {
        if (var3 > var2.getMaxLevel()) {
            throw ERROR_LEVEL_TOO_HIGH.create((Object)var3, (Object)var2.getMaxLevel());
        }
        int var4 = 0;
        for (Entity entity : var1) {
            if (entity instanceof EntityLiving) {
                EntityLiving var7 = (EntityLiving)entity;
                ItemStack var8 = var7.getMainHandItem();
                if (!var8.isEmpty()) {
                    if (var2.canEnchant(var8) && EnchantmentManager.isEnchantmentCompatible(EnchantmentManager.getEnchantments(var8).keySet(), var2)) {
                        var8.enchant(var2, var3);
                        ++var4;
                        continue;
                    }
                    if (var1.size() != 1) continue;
                    throw ERROR_INCOMPATIBLE.create((Object)var8.getItem().getName(var8).getString());
                }
                if (var1.size() != 1) continue;
                throw ERROR_NO_ITEM.create((Object)var7.getName().getString());
            }
            if (var1.size() != 1) continue;
            throw ERROR_NOT_LIVING_ENTITY.create((Object)entity.getName().getString());
        }
        if (var4 == 0) {
            throw ERROR_NOTHING_HAPPENED.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(new ChatMessage("commands.enchant.success.single", var2.getFullname(var3), var1.iterator().next().getDisplayName()), true);
        } else {
            var0.sendSuccess(new ChatMessage("commands.enchant.success.multiple", var2.getFullname(var3), var1.size()), true);
        }
        return var4;
    }
}

