/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.ticks.TickListServer;

public class CommandClone {
    private static final int MAX_CLONE_AREA = 32768;
    private static final SimpleCommandExceptionType ERROR_OVERLAP = new SimpleCommandExceptionType((Message)new ChatMessage("commands.clone.overlap"));
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((var0, var1) -> new ChatMessage("commands.clone.toobig", var0, var1));
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)new ChatMessage("commands.clone.failed"));
    public static final Predicate<ShapeDetectorBlock> FILTER_AIR = var0 -> !var0.getState().isAir();

    public static void register(CommandDispatcher<CommandListenerWrapper> var03) {
        var03.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("clone").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("begin", ArgumentPosition.blockPos()).then(net.minecraft.commands.CommandDispatcher.argument("end", ArgumentPosition.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("destination", ArgumentPosition.blockPos()).executes(var02 -> CommandClone.clone((CommandListenerWrapper)var02.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "begin"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "end"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "destination"), var0 -> true, Mode.NORMAL))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("replace").executes(var02 -> CommandClone.clone((CommandListenerWrapper)var02.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "begin"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "end"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "destination"), var0 -> true, Mode.NORMAL))).then(net.minecraft.commands.CommandDispatcher.literal("force").executes(var02 -> CommandClone.clone((CommandListenerWrapper)var02.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "begin"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "end"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "destination"), var0 -> true, Mode.FORCE)))).then(net.minecraft.commands.CommandDispatcher.literal("move").executes(var02 -> CommandClone.clone((CommandListenerWrapper)var02.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "begin"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "end"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "destination"), var0 -> true, Mode.MOVE)))).then(net.minecraft.commands.CommandDispatcher.literal("normal").executes(var02 -> CommandClone.clone((CommandListenerWrapper)var02.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "begin"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "end"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var02, "destination"), var0 -> true, Mode.NORMAL))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("masked").executes(var0 -> CommandClone.clone((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "begin"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "end"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "destination"), FILTER_AIR, Mode.NORMAL))).then(net.minecraft.commands.CommandDispatcher.literal("force").executes(var0 -> CommandClone.clone((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "begin"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "end"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "destination"), FILTER_AIR, Mode.FORCE)))).then(net.minecraft.commands.CommandDispatcher.literal("move").executes(var0 -> CommandClone.clone((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "begin"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "end"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "destination"), FILTER_AIR, Mode.MOVE)))).then(net.minecraft.commands.CommandDispatcher.literal("normal").executes(var0 -> CommandClone.clone((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "begin"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "end"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "destination"), FILTER_AIR, Mode.NORMAL))))).then(net.minecraft.commands.CommandDispatcher.literal("filtered").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("filter", ArgumentBlockPredicate.blockPredicate()).executes(var0 -> CommandClone.clone((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "begin"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "end"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "destination"), ArgumentBlockPredicate.getBlockPredicate((CommandContext<CommandListenerWrapper>)var0, "filter"), Mode.NORMAL))).then(net.minecraft.commands.CommandDispatcher.literal("force").executes(var0 -> CommandClone.clone((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "begin"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "end"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "destination"), ArgumentBlockPredicate.getBlockPredicate((CommandContext<CommandListenerWrapper>)var0, "filter"), Mode.FORCE)))).then(net.minecraft.commands.CommandDispatcher.literal("move").executes(var0 -> CommandClone.clone((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "begin"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "end"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "destination"), ArgumentBlockPredicate.getBlockPredicate((CommandContext<CommandListenerWrapper>)var0, "filter"), Mode.MOVE)))).then(net.minecraft.commands.CommandDispatcher.literal("normal").executes(var0 -> CommandClone.clone((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "begin"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "end"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "destination"), ArgumentBlockPredicate.getBlockPredicate((CommandContext<CommandListenerWrapper>)var0, "filter"), Mode.NORMAL)))))))));
    }

    private static int clone(CommandListenerWrapper var0, BlockPosition var1, BlockPosition var2, BlockPosition var3, Predicate<ShapeDetectorBlock> var4, Mode var5) throws CommandSyntaxException {
        Object var21;
        Object var202;
        StructureBoundingBox var6 = StructureBoundingBox.fromCorners(var1, var2);
        BlockPosition var7 = var3.offset(var6.getLength());
        StructureBoundingBox var8 = StructureBoundingBox.fromCorners(var3, var7);
        if (!var5.canOverlap() && var8.intersects(var6)) {
            throw ERROR_OVERLAP.create();
        }
        int var9 = var6.getXSpan() * var6.getYSpan() * var6.getZSpan();
        if (var9 > 32768) {
            throw ERROR_AREA_TOO_LARGE.create((Object)32768, (Object)var9);
        }
        WorldServer var10 = var0.getLevel();
        if (!var10.hasChunksAt(var1, var2) || !var10.hasChunksAt(var3, var7)) {
            throw ArgumentPosition.ERROR_NOT_LOADED.create();
        }
        ArrayList var11 = Lists.newArrayList();
        ArrayList var12 = Lists.newArrayList();
        ArrayList var13 = Lists.newArrayList();
        LinkedList var14 = Lists.newLinkedList();
        BlockPosition var15 = new BlockPosition(var8.minX() - var6.minX(), var8.minY() - var6.minY(), var8.minZ() - var6.minZ());
        for (int var16 = var6.minZ(); var16 <= var6.maxZ(); ++var16) {
            for (int var17 = var6.minY(); var17 <= var6.maxY(); ++var17) {
                for (int var18 = var6.minX(); var18 <= var6.maxX(); ++var18) {
                    Object var19 = new BlockPosition(var18, var17, var16);
                    var202 = ((BlockPosition)var19).offset(var15);
                    var21 = new ShapeDetectorBlock(var10, (BlockPosition)var19, false);
                    IBlockData var22 = ((ShapeDetectorBlock)var21).getState();
                    if (!var4.test((ShapeDetectorBlock)var21)) continue;
                    TileEntity var23 = var10.getBlockEntity((BlockPosition)var19);
                    if (var23 != null) {
                        NBTTagCompound var24 = var23.saveWithoutMetadata();
                        var12.add(new CommandCloneStoredTileEntity((BlockPosition)var202, var22, var24));
                        var14.addLast(var19);
                        continue;
                    }
                    if (var22.isSolidRender(var10, (BlockPosition)var19) || var22.isCollisionShapeFullBlock(var10, (BlockPosition)var19)) {
                        var11.add(new CommandCloneStoredTileEntity((BlockPosition)var202, var22, null));
                        var14.addLast(var19);
                        continue;
                    }
                    var13.add(new CommandCloneStoredTileEntity((BlockPosition)var202, var22, null));
                    var14.addFirst(var19);
                }
            }
        }
        if (var5 == Mode.MOVE) {
            for (BlockPosition var17 : var14) {
                TileEntity var18 = var10.getBlockEntity(var17);
                Clearable.tryClear(var18);
                var10.setBlock(var17, Blocks.BARRIER.defaultBlockState(), 2);
            }
            for (BlockPosition var17 : var14) {
                var10.setBlock(var17, Blocks.AIR.defaultBlockState(), 3);
            }
        }
        ArrayList var16 = Lists.newArrayList();
        var16.addAll(var11);
        var16.addAll(var12);
        var16.addAll(var13);
        List var17 = Lists.reverse((List)var16);
        for (Object var19 : var17) {
            var202 = var10.getBlockEntity(((CommandCloneStoredTileEntity)var19).pos);
            Clearable.tryClear(var202);
            var10.setBlock(((CommandCloneStoredTileEntity)var19).pos, Blocks.BARRIER.defaultBlockState(), 2);
        }
        int var18 = 0;
        for (Object var202 : var16) {
            if (!var10.setBlock(((CommandCloneStoredTileEntity)var202).pos, ((CommandCloneStoredTileEntity)var202).state, 2)) continue;
            ++var18;
        }
        for (Object var202 : var12) {
            var21 = var10.getBlockEntity(((CommandCloneStoredTileEntity)var202).pos);
            if (((CommandCloneStoredTileEntity)var202).tag != null && var21 != null) {
                ((TileEntity)var21).load(((CommandCloneStoredTileEntity)var202).tag);
                ((TileEntity)var21).setChanged();
            }
            var10.setBlock(((CommandCloneStoredTileEntity)var202).pos, ((CommandCloneStoredTileEntity)var202).state, 2);
        }
        for (Object var202 : var17) {
            var10.blockUpdated(((CommandCloneStoredTileEntity)var202).pos, ((CommandCloneStoredTileEntity)var202).state.getBlock());
        }
        ((TickListServer)var10.getBlockTicks()).copyArea(var6, var15);
        if (var18 == 0) {
            throw ERROR_FAILED.create();
        }
        var0.sendSuccess(new ChatMessage("commands.clone.success", var18), true);
        return var18;
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode FORCE = new Mode(true);
        public static final /* enum */ Mode MOVE = new Mode(true);
        public static final /* enum */ Mode NORMAL = new Mode(false);
        private final boolean canOverlap;
        private static final /* synthetic */ Mode[] e;

        public static Mode[] values() {
            return (Mode[])e.clone();
        }

        public static Mode valueOf(String var0) {
            return Enum.valueOf(Mode.class, var0);
        }

        private Mode(boolean var2) {
            this.canOverlap = var2;
        }

        public boolean canOverlap() {
            return this.canOverlap;
        }

        private static /* synthetic */ Mode[] b() {
            return new Mode[]{FORCE, MOVE, NORMAL};
        }

        static {
            e = Mode.b();
        }
    }

    static class CommandCloneStoredTileEntity {
        public final BlockPosition pos;
        public final IBlockData state;
        @Nullable
        public final NBTTagCompound tag;

        public CommandCloneStoredTileEntity(BlockPosition var0, IBlockData var1, @Nullable NBTTagCompound var2) {
            this.pos = var0;
            this.state = var1;
            this.tag = var2;
        }
    }
}

