/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SaveData;

public record WorldStem(IReloadableResourceManager resourceManager, DataPackResources dataPackResources, IRegistryCustom.Dimension registryAccess, SaveData worldData) implements AutoCloseable
{
    public static CompletableFuture<WorldStem> load(b var0, a var12, c var22, Executor var32, Executor var4) {
        try {
            DataPackConfiguration var5 = (DataPackConfiguration)var12.get();
            DataPackConfiguration var6 = MinecraftServer.configurePackRepository(var0.packRepository(), var5, var0.safeMode());
            List<IResourcePack> var7 = var0.packRepository().openAllSelected();
            ResourceManager var8 = new ResourceManager(EnumResourcePackType.SERVER_DATA, var7);
            Pair<SaveData, IRegistryCustom.Dimension> var9 = var22.get(var8, var6);
            SaveData var10 = (SaveData)var9.getFirst();
            IRegistryCustom.Dimension var11 = (IRegistryCustom.Dimension)var9.getSecond();
            return ((CompletableFuture)DataPackResources.loadResources(var8, var11, var0.commandSelection(), var0.functionCompilationLevel(), var32, var4).whenComplete((var1, var2) -> {
                if (var2 != null) {
                    var8.close();
                }
            })).thenApply(var3 -> new WorldStem(var8, (DataPackResources)var3, var11, var10));
        }
        catch (Exception var5) {
            return CompletableFuture.failedFuture(var5);
        }
    }

    @Override
    public void close() {
        this.resourceManager.close();
    }

    public void updateGlobals() {
        this.dataPackResources.updateRegistryTags(this.registryAccess);
    }

    @FunctionalInterface
    public static interface a
    extends Supplier<DataPackConfiguration> {
        public static a loadFromWorld(Convertable.ConversionSession var0) {
            return () -> {
                DataPackConfiguration var1 = var0.getDataPacks();
                if (var1 == null) {
                    throw new IllegalStateException("Failed to load data pack config");
                }
                return var1;
            };
        }
    }

    public record b(ResourcePackRepository packRepository, CommandDispatcher.ServerType commandSelection, int functionCompilationLevel, boolean safeMode) {
    }

    @FunctionalInterface
    public static interface c {
        public Pair<SaveData, IRegistryCustom.Dimension> get(IResourceManager var1, DataPackConfiguration var2);

        public static c loadFromWorld(Convertable.ConversionSession var0) {
            return (var1, var2) -> {
                IRegistryCustom.e var3 = IRegistryCustom.builtinCopy();
                RegistryOps<NBTBase> var4 = RegistryOps.createAndLoad(DynamicOpsNBT.INSTANCE, var3, var1);
                SaveData var5 = var0.getDataTag(var4, var2, var3.allElementsLifecycle());
                if (var5 == null) {
                    throw new IllegalStateException("Failed to load world");
                }
                return Pair.of((Object)var5, (Object)var3.freeze());
            };
        }
    }
}

