/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.EULA;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.WorldLoadListenerLogger;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.repository.ResourcePackSourceFolder;
import net.minecraft.server.packs.repository.ResourcePackSourceVanilla;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.players.UserCache;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import org.slf4j.Logger;

public class Main {
    private static final Logger LOGGER = LogUtils.getLogger();

    @DontObfuscate
    public static void main(String[] var0) {
        SharedConstants.tryDetectVersion();
        OptionParser var1 = new OptionParser();
        OptionSpecBuilder var2 = var1.accepts("nogui");
        OptionSpecBuilder var3 = var1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder var4 = var1.accepts("demo");
        OptionSpecBuilder var5 = var1.accepts("bonusChest");
        OptionSpecBuilder var6 = var1.accepts("forceUpgrade");
        OptionSpecBuilder var7 = var1.accepts("eraseCache");
        OptionSpecBuilder var8 = var1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec var9 = var1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec var10 = var1.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec var11 = var1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec var12 = var1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec var13 = var1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec var14 = var1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder var15 = var1.accepts("jfrProfile");
        NonOptionArgumentSpec var16 = var1.nonOptions();
        try {
            WorldStem var33;
            Object var34;
            boolean var31;
            OptionSet var17 = var1.parse(var0);
            if (var17.has((OptionSpec)var9)) {
                var1.printHelpOn((OutputStream)System.err);
                return;
            }
            CrashReport.preload();
            if (var17.has((OptionSpec)var15)) {
                JvmProfiler.INSTANCE.start(Environment.SERVER);
            }
            DispenserRegistry.bootStrap();
            DispenserRegistry.validate();
            SystemUtils.startTimerHackThread();
            Path var18 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings var19 = new DedicatedServerSettings(var18);
            var19.forceSave();
            Path var20 = Paths.get("eula.txt", new String[0]);
            EULA var21 = new EULA(var20);
            if (var17.has((OptionSpec)var3)) {
                LOGGER.info("Initialized '{}' and '{}'", (Object)var18.toAbsolutePath(), (Object)var20.toAbsolutePath());
                return;
            }
            if (!var21.hasAgreedToEULA()) {
                LOGGER.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File var22 = new File((String)var17.valueOf((OptionSpec)var11));
            YggdrasilAuthenticationService var23 = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
            MinecraftSessionService var24 = var23.createMinecraftSessionService();
            GameProfileRepository var25 = var23.createProfileRepository();
            UserCache var26 = new UserCache(var25, new File(var22, MinecraftServer.USERID_CACHE_FILE.getName()));
            String var27 = Optional.ofNullable((String)var17.valueOf((OptionSpec)var12)).orElse(var19.getProperties().levelName);
            Convertable var28 = Convertable.createDefault(var22.toPath());
            Convertable.ConversionSession var29 = var28.createAccess(var27);
            WorldInfo var30 = var29.getSummary();
            if (var30 != null) {
                if (var30.requiresManualConversion()) {
                    LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!var30.isCompatible()) {
                    LOGGER.info("This world was created by an incompatible version.");
                    return;
                }
            }
            if (var31 = var17.has((OptionSpec)var8)) {
                LOGGER.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            ResourcePackRepository var32 = new ResourcePackRepository(EnumResourcePackType.SERVER_DATA, new ResourcePackSourceVanilla(), new ResourcePackSourceFolder(var29.getLevelPath(SavedFile.DATAPACK_DIR).toFile(), PackSource.WORLD));
            try {
                var34 = new WorldStem.b(var32, CommandDispatcher.ServerType.DEDICATED, var19.getProperties().functionPermissionLevel, var31);
                var33 = WorldStem.load((WorldStem.b)var34, () -> {
                    DataPackConfiguration var1 = var29.getDataPacks();
                    return var1 == null ? DataPackConfiguration.DEFAULT : var1;
                }, (arg_0, arg_1) -> Main.a(var29, var17, (OptionSpec)var4, var19, (OptionSpec)var5, arg_0, arg_1), SystemUtils.backgroundExecutor(), Runnable::run).get();
            }
            catch (Exception var342) {
                LOGGER.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)var342);
                var32.close();
                return;
            }
            var33.updateGlobals();
            var34 = var33.registryAccess();
            var19.getProperties().getWorldGenSettings((IRegistryCustom)var34);
            SaveData var35 = var33.worldData();
            if (var17.has((OptionSpec)var6)) {
                Main.forceUpgrade(var29, DataConverterRegistry.getDataFixer(), var17.has((OptionSpec)var7), () -> true, var35.worldGenSettings());
            }
            var29.saveDataTag((IRegistryCustom)var34, var35);
            final DedicatedServer var36 = MinecraftServer.spin(arg_0 -> Main.a(var29, var32, var33, var19, var24, var25, var26, var17, (OptionSpec)var10, (OptionSpec)var13, (OptionSpec)var4, (OptionSpec)var14, (OptionSpec)var2, (OptionSpec)var16, arg_0));
            Thread var37 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    var36.halt(true);
                }
            };
            var37.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
            Runtime.getRuntime().addShutdownHook(var37);
        }
        catch (Exception var17) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)var17);
        }
    }

    public static void forceUpgrade(Convertable.ConversionSession var0, DataFixer var1, boolean var2, BooleanSupplier var3, GeneratorSettings var4) {
        LOGGER.info("Forcing world upgrade!");
        WorldUpgrader var5 = new WorldUpgrader(var0, var1, var4, var2);
        IChatBaseComponent var6 = null;
        while (!var5.isFinished()) {
            int var8;
            IChatBaseComponent var7 = var5.getStatus();
            if (var6 != var7) {
                var6 = var7;
                LOGGER.info(var5.getStatus().getString());
            }
            if ((var8 = var5.getTotalChunks()) > 0) {
                int var9 = var5.getConverted() + var5.getSkipped();
                LOGGER.info("{}% completed ({} / {} chunks)...", new Object[]{MathHelper.floor((float)var9 / (float)var8 * 100.0f), var9, var8});
            }
            if (!var3.getAsBoolean()) {
                var5.cancel();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ DedicatedServer a(Convertable.ConversionSession var0, ResourcePackRepository var1, WorldStem var2, DedicatedServerSettings var3, MinecraftSessionService var4, GameProfileRepository var5, UserCache var6, OptionSet var7, OptionSpec var8, OptionSpec var9, OptionSpec var10, OptionSpec var11, OptionSpec var12, OptionSpec var13, Thread var14) {
        boolean var16;
        DedicatedServer var15 = new DedicatedServer(var14, var0, var1, var2, var3, DataConverterRegistry.getDataFixer(), var4, var5, var6, WorldLoadListenerLogger::new);
        var15.setSingleplayerName((String)var7.valueOf(var8));
        var15.setPort((Integer)var7.valueOf(var9));
        var15.setDemo(var7.has(var10));
        var15.setId((String)var7.valueOf(var11));
        boolean bl = var16 = !var7.has(var12) && !var7.valuesOf(var13).contains("nogui");
        if (var16 && !GraphicsEnvironment.isHeadless()) {
            var15.showGui();
        }
        return var15;
    }

    private static /* synthetic */ Pair a(Convertable.ConversionSession var0, OptionSet var1, OptionSpec var2, DedicatedServerSettings var3, OptionSpec var4, IResourceManager var5, DataPackConfiguration var6) {
        Object var12;
        GeneratorSettings var11;
        WorldSettings var10;
        IRegistryCustom.e var7 = IRegistryCustom.builtinCopy();
        RegistryOps<NBTBase> var8 = RegistryOps.createAndLoad(DynamicOpsNBT.INSTANCE, var7, var5);
        SaveData var9 = var0.getDataTag(var8, var6, var7.allElementsLifecycle());
        if (var9 != null) {
            return Pair.of((Object)var9, (Object)var7.freeze());
        }
        if (var1.has(var2)) {
            var10 = MinecraftServer.DEMO_SETTINGS;
            var11 = GeneratorSettings.demoSettings(var7);
        } else {
            var12 = var3.getProperties();
            var10 = new WorldSettings(((DedicatedServerProperties)var12).levelName, ((DedicatedServerProperties)var12).gamemode, ((DedicatedServerProperties)var12).hardcore, ((DedicatedServerProperties)var12).difficulty, false, new GameRules(), var6);
            var11 = var1.has(var4) ? ((DedicatedServerProperties)var12).getWorldGenSettings(var7).withBonusChest() : ((DedicatedServerProperties)var12).getWorldGenSettings(var7);
        }
        var12 = new WorldDataServer(var10, var11, Lifecycle.stable());
        return Pair.of((Object)var12, (Object)var7.freeze());
    }
}

