/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;

public class ResourceKey<T> {
    private static final Map<String, ResourceKey<?>> VALUES = Collections.synchronizedMap(Maps.newIdentityHashMap());
    private final MinecraftKey registryName;
    private final MinecraftKey location;

    public static <T> Codec<ResourceKey<T>> codec(ResourceKey<? extends IRegistry<T>> var0) {
        return MinecraftKey.CODEC.xmap(var1 -> ResourceKey.create(var0, var1), ResourceKey::location);
    }

    public static <T> ResourceKey<T> create(ResourceKey<? extends IRegistry<T>> var0, MinecraftKey var1) {
        return ResourceKey.create(var0.location, var1);
    }

    public static <T> ResourceKey<IRegistry<T>> createRegistryKey(MinecraftKey var0) {
        return ResourceKey.create(IRegistry.ROOT_REGISTRY_NAME, var0);
    }

    private static <T> ResourceKey<T> create(MinecraftKey var0, MinecraftKey var1) {
        String var22 = (var0 + ":" + var1).intern();
        return VALUES.computeIfAbsent(var22, var2 -> new ResourceKey(var0, var1));
    }

    private ResourceKey(MinecraftKey var0, MinecraftKey var1) {
        this.registryName = var0;
        this.location = var1;
    }

    public String toString() {
        return "ResourceKey[" + this.registryName + " / " + this.location + "]";
    }

    public boolean isFor(ResourceKey<? extends IRegistry<?>> var0) {
        return this.registryName.equals(var0.location());
    }

    public <E> Optional<ResourceKey<E>> cast(ResourceKey<? extends IRegistry<E>> var0) {
        return this.isFor(var0) ? Optional.of(this) : Optional.empty();
    }

    public MinecraftKey location() {
        return this.location;
    }

    public MinecraftKey registry() {
        return this.registryName;
    }

    public static <T> Function<MinecraftKey, ResourceKey<T>> elementKey(ResourceKey<? extends IRegistry<T>> var0) {
        return var1 -> ResourceKey.create(var0, var1);
    }
}

