/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;

public class RegistryLoader {
    private final RegistryResourceAccess resources;
    private final Map<ResourceKey<? extends IRegistry<?>>, b<?>> readCache = new IdentityHashMap();

    RegistryLoader(RegistryResourceAccess var0) {
        this.resources = var0;
    }

    public <E> DataResult<? extends IRegistry<E>> overrideRegistryFromResources(IRegistryWritable<E> var0, ResourceKey<? extends IRegistry<E>> var1, Codec<E> var2, DynamicOps<JsonElement> var3) {
        Collection var42 = this.resources.listResources(var1);
        DataResult var5 = DataResult.success(var0, (Lifecycle)Lifecycle.stable());
        for (ResourceKey var7 : var42) {
            var5 = var5.flatMap(var4 -> this.overrideElementFromResources((IRegistryWritable)var4, var1, var2, var7, var3).map(var1 -> var4));
        }
        return var5.setPartial(var0);
    }

    <E> DataResult<Holder<E>> overrideElementFromResources(IRegistryWritable<E> var0, ResourceKey<? extends IRegistry<E>> var12, Codec<E> var2, ResourceKey<E> var3, DynamicOps<JsonElement> var4) {
        DataResult var9;
        b<E> var5 = this.readCache(var12);
        DataResult var6 = var5.values.get(var3);
        if (var6 != null) {
            return var6;
        }
        Holder var7 = var0.getOrCreateHolder(var3);
        var5.values.put(var3, DataResult.success(var7));
        Optional<DataResult<RegistryResourceAccess.ParsedEntry<E>>> var8 = this.resources.parseElement(var4, var12, var3, var2);
        if (var8.isEmpty()) {
            var9 = var0.containsKey(var3) ? DataResult.success(var7, (Lifecycle)Lifecycle.stable()) : DataResult.error((String)("Missing referenced custom/removed registry entry for registry " + var12 + " named " + var3.location()));
        } else {
            DataResult<RegistryResourceAccess.ParsedEntry<E>> var10 = var8.get();
            Optional var11 = var10.result();
            if (var11.isPresent()) {
                RegistryResourceAccess.ParsedEntry var122 = (RegistryResourceAccess.ParsedEntry)var11.get();
                var0.registerOrOverride(var122.fixedId(), var3, var122.value(), var10.lifecycle());
            }
            var9 = var10.map(var1 -> var7);
        }
        var5.values.put(var3, var9);
        return var9;
    }

    private <E> b<E> readCache(ResourceKey<? extends IRegistry<E>> var02) {
        return this.readCache.computeIfAbsent(var02, var0 -> new b());
    }

    public a bind(IRegistryCustom.e var0) {
        return new a(var0, this);
    }

    static final class b<E> {
        final Map<ResourceKey<E>, DataResult<Holder<E>>> values = Maps.newIdentityHashMap();

        b() {
        }
    }

    public record a(IRegistryCustom.e access, RegistryLoader loader) {
        public <E> DataResult<? extends IRegistry<E>> overrideRegistryFromResources(ResourceKey<? extends IRegistry<E>> var0, Codec<E> var1, DynamicOps<JsonElement> var2) {
            IRegistryWritable var3 = this.access.ownedWritableRegistryOrThrow(var0);
            return this.loader.overrideRegistryFromResources(var3, var0, var1, var2);
        }

        public <E> DataResult<Holder<E>> overrideElementFromResources(ResourceKey<? extends IRegistry<E>> var0, Codec<E> var1, ResourceKey<E> var2, DynamicOps<JsonElement> var3) {
            IRegistryWritable var4 = this.access.ownedWritableRegistryOrThrow(var0);
            return this.loader.overrideElementFromResources(var4, var0, var1, var2, var3);
        }
    }
}

