/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.util.ChatDeserializer;
import org.apache.commons.lang3.StringUtils;

public class MinecraftKey
implements Comparable<MinecraftKey> {
    public static final Codec<MinecraftKey> CODEC = Codec.STRING.comapFlatMap(MinecraftKey::read, MinecraftKey::toString).stable();
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)new ChatMessage("argument.id.invalid"));
    public static final char NAMESPACE_SEPARATOR = ':';
    public static final String DEFAULT_NAMESPACE = "minecraft";
    public static final String REALMS_NAMESPACE = "realms";
    protected final String namespace;
    protected final String path;

    protected MinecraftKey(String[] var0) {
        this.namespace = StringUtils.isEmpty((CharSequence)var0[0]) ? DEFAULT_NAMESPACE : var0[0];
        this.path = var0[1];
        if (!MinecraftKey.isValidNamespace(this.namespace)) {
            throw new ResourceKeyInvalidException("Non [a-z0-9_.-] character in namespace of location: " + this.namespace + ":" + this.path);
        }
        if (!MinecraftKey.isValidPath(this.path)) {
            throw new ResourceKeyInvalidException("Non [a-z0-9/._-] character in path of location: " + this.namespace + ":" + this.path);
        }
    }

    public MinecraftKey(String var0) {
        this(MinecraftKey.decompose(var0, ':'));
    }

    public MinecraftKey(String var0, String var1) {
        this(new String[]{var0, var1});
    }

    public static MinecraftKey of(String var0, char var1) {
        return new MinecraftKey(MinecraftKey.decompose(var0, var1));
    }

    @Nullable
    public static MinecraftKey tryParse(String var0) {
        try {
            return new MinecraftKey(var0);
        }
        catch (ResourceKeyInvalidException var1) {
            return null;
        }
    }

    protected static String[] decompose(String var0, char var1) {
        String[] var2 = new String[]{DEFAULT_NAMESPACE, var0};
        int var3 = var0.indexOf(var1);
        if (var3 >= 0) {
            var2[1] = var0.substring(var3 + 1, var0.length());
            if (var3 >= 1) {
                var2[0] = var0.substring(0, var3);
            }
        }
        return var2;
    }

    public static DataResult<MinecraftKey> read(String var0) {
        try {
            return DataResult.success((Object)new MinecraftKey(var0));
        }
        catch (ResourceKeyInvalidException var1) {
            return DataResult.error((String)("Not a valid resource location: " + var0 + " " + var1.getMessage()));
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String toString() {
        return this.namespace + ":" + this.path;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof MinecraftKey) {
            MinecraftKey var1 = (MinecraftKey)var0;
            return this.namespace.equals(var1.namespace) && this.path.equals(var1.path);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.namespace.hashCode() + this.path.hashCode();
    }

    @Override
    public int compareTo(MinecraftKey var0) {
        int var1 = this.path.compareTo(var0.path);
        if (var1 == 0) {
            var1 = this.namespace.compareTo(var0.namespace);
        }
        return var1;
    }

    public String toDebugFileName() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public static MinecraftKey read(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        while (var0.canRead() && MinecraftKey.isAllowedInResourceLocation(var0.peek())) {
            var0.skip();
        }
        String var2 = var0.getString().substring(var1, var0.getCursor());
        try {
            return new MinecraftKey(var2);
        }
        catch (ResourceKeyInvalidException var3) {
            var0.setCursor(var1);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)var0);
        }
    }

    public static boolean isAllowedInResourceLocation(char var0) {
        return var0 >= '0' && var0 <= '9' || var0 >= 'a' && var0 <= 'z' || var0 == '_' || var0 == ':' || var0 == '/' || var0 == '.' || var0 == '-';
    }

    private static boolean isValidPath(String var0) {
        for (int var1 = 0; var1 < var0.length(); ++var1) {
            if (MinecraftKey.validPathChar(var0.charAt(var1))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidNamespace(String var0) {
        for (int var1 = 0; var1 < var0.length(); ++var1) {
            if (MinecraftKey.validNamespaceChar(var0.charAt(var1))) continue;
            return false;
        }
        return true;
    }

    public static boolean validPathChar(char var0) {
        return var0 == '_' || var0 == '-' || var0 >= 'a' && var0 <= 'z' || var0 >= '0' && var0 <= '9' || var0 == '/' || var0 == '.';
    }

    private static boolean validNamespaceChar(char var0) {
        return var0 == '_' || var0 == '-' || var0 >= 'a' && var0 <= 'z' || var0 >= '0' && var0 <= '9' || var0 == '.';
    }

    public static boolean isValidResourceLocation(String var0) {
        String[] var1 = MinecraftKey.decompose(var0, ':');
        return MinecraftKey.isValidNamespace(StringUtils.isEmpty((CharSequence)var1[0]) ? DEFAULT_NAMESPACE : var1[0]) && MinecraftKey.isValidPath(var1[1]);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((MinecraftKey)object);
    }

    public static class a
    implements JsonDeserializer<MinecraftKey>,
    JsonSerializer<MinecraftKey> {
        public MinecraftKey deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
            return new MinecraftKey(ChatDeserializer.convertToString(var0, "location"));
        }

        public JsonElement serialize(MinecraftKey var0, Type var1, JsonSerializationContext var2) {
            return new JsonPrimitive(var0.toString());
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((MinecraftKey)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

