/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;

public class PacketLoginInEncryptionBegin
implements Packet<PacketLoginInListener> {
    private final byte[] keybytes;
    private final byte[] nonce;

    public PacketLoginInEncryptionBegin(SecretKey var0, PublicKey var1, byte[] var2) throws CryptographyException {
        this.keybytes = MinecraftEncryption.encryptUsingKey(var1, var0.getEncoded());
        this.nonce = MinecraftEncryption.encryptUsingKey(var1, var2);
    }

    public PacketLoginInEncryptionBegin(PacketDataSerializer var0) {
        this.keybytes = var0.readByteArray();
        this.nonce = var0.readByteArray();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeByteArray(this.keybytes);
        var0.writeByteArray(this.nonce);
    }

    @Override
    public void handle(PacketLoginInListener var0) {
        var0.handleKey(this);
    }

    public SecretKey getSecretKey(PrivateKey var0) throws CryptographyException {
        return MinecraftEncryption.decryptByteToSecretKey(var0, this.keybytes);
    }

    public byte[] getNonce(PrivateKey var0) throws CryptographyException {
        return MinecraftEncryption.decryptUsingKey(var0, this.nonce);
    }
}

