/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundCategory;

public class PacketPlayOutStopSound
implements Packet<PacketListenerPlayOut> {
    private static final int HAS_SOURCE = 1;
    private static final int HAS_SOUND = 2;
    @Nullable
    private final MinecraftKey name;
    @Nullable
    private final SoundCategory source;

    public PacketPlayOutStopSound(@Nullable MinecraftKey var0, @Nullable SoundCategory var1) {
        this.name = var0;
        this.source = var1;
    }

    public PacketPlayOutStopSound(PacketDataSerializer var0) {
        byte var1 = var0.readByte();
        this.source = (var1 & 1) > 0 ? var0.readEnum(SoundCategory.class) : null;
        this.name = (var1 & 2) > 0 ? var0.readResourceLocation() : null;
    }

    @Override
    public void write(PacketDataSerializer var0) {
        if (this.source != null) {
            if (this.name != null) {
                var0.writeByte(3);
                var0.writeEnum(this.source);
                var0.writeResourceLocation(this.name);
            } else {
                var0.writeByte(1);
                var0.writeEnum(this.source);
            }
        } else if (this.name != null) {
            var0.writeByte(2);
            var0.writeResourceLocation(this.name);
        } else {
            var0.writeByte(0);
        }
    }

    @Nullable
    public MinecraftKey getName() {
        return this.name;
    }

    @Nullable
    public SoundCategory getSource() {
        return this.source;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleStopSoundEvent(this);
    }
}

