/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class PacketPlayOutScoreboardObjective
implements Packet<PacketListenerPlayOut> {
    public static final int METHOD_ADD = 0;
    public static final int METHOD_REMOVE = 1;
    public static final int METHOD_CHANGE = 2;
    private final String objectiveName;
    private final IChatBaseComponent displayName;
    private final IScoreboardCriteria.EnumScoreboardHealthDisplay renderType;
    private final int method;

    public PacketPlayOutScoreboardObjective(ScoreboardObjective var0, int var1) {
        this.objectiveName = var0.getName();
        this.displayName = var0.getDisplayName();
        this.renderType = var0.getRenderType();
        this.method = var1;
    }

    public PacketPlayOutScoreboardObjective(PacketDataSerializer var0) {
        this.objectiveName = var0.readUtf();
        this.method = var0.readByte();
        if (this.method == 0 || this.method == 2) {
            this.displayName = var0.readComponent();
            this.renderType = var0.readEnum(IScoreboardCriteria.EnumScoreboardHealthDisplay.class);
        } else {
            this.displayName = ChatComponentText.EMPTY;
            this.renderType = IScoreboardCriteria.EnumScoreboardHealthDisplay.INTEGER;
        }
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeUtf(this.objectiveName);
        var0.writeByte(this.method);
        if (this.method == 0 || this.method == 2) {
            var0.writeComponent(this.displayName);
            var0.writeEnum(this.renderType);
        }
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleAddObjective(this);
    }

    public String getObjectiveName() {
        return this.objectiveName;
    }

    public IChatBaseComponent getDisplayName() {
        return this.displayName;
    }

    public int getMethod() {
        return this.method;
    }

    public IScoreboardCriteria.EnumScoreboardHealthDisplay getRenderType() {
        return this.renderType;
    }
}

