/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.EnumSet;
import java.util.Set;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class PacketPlayOutPosition
implements Packet<PacketListenerPlayOut> {
    private final double x;
    private final double y;
    private final double z;
    private final float yRot;
    private final float xRot;
    private final Set<EnumPlayerTeleportFlags> relativeArguments;
    private final int id;
    private final boolean dismountVehicle;

    public PacketPlayOutPosition(double var0, double var2, double var4, float var6, float var7, Set<EnumPlayerTeleportFlags> var8, int var9, boolean var10) {
        this.x = var0;
        this.y = var2;
        this.z = var4;
        this.yRot = var6;
        this.xRot = var7;
        this.relativeArguments = var8;
        this.id = var9;
        this.dismountVehicle = var10;
    }

    public PacketPlayOutPosition(PacketDataSerializer var0) {
        this.x = var0.readDouble();
        this.y = var0.readDouble();
        this.z = var0.readDouble();
        this.yRot = var0.readFloat();
        this.xRot = var0.readFloat();
        this.relativeArguments = EnumPlayerTeleportFlags.unpack(var0.readUnsignedByte());
        this.id = var0.readVarInt();
        this.dismountVehicle = var0.readBoolean();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeDouble(this.x);
        var0.writeDouble(this.y);
        var0.writeDouble(this.z);
        var0.writeFloat(this.yRot);
        var0.writeFloat(this.xRot);
        var0.writeByte(EnumPlayerTeleportFlags.pack(this.relativeArguments));
        var0.writeVarInt(this.id);
        var0.writeBoolean(this.dismountVehicle);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleMovePlayer(this);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getXRot() {
        return this.xRot;
    }

    public int getId() {
        return this.id;
    }

    public boolean requestDismountVehicle() {
        return this.dismountVehicle;
    }

    public Set<EnumPlayerTeleportFlags> getRelativeArguments() {
        return this.relativeArguments;
    }

    public static final class EnumPlayerTeleportFlags
    extends Enum<EnumPlayerTeleportFlags> {
        public static final /* enum */ EnumPlayerTeleportFlags X = new EnumPlayerTeleportFlags(0);
        public static final /* enum */ EnumPlayerTeleportFlags Y = new EnumPlayerTeleportFlags(1);
        public static final /* enum */ EnumPlayerTeleportFlags Z = new EnumPlayerTeleportFlags(2);
        public static final /* enum */ EnumPlayerTeleportFlags Y_ROT = new EnumPlayerTeleportFlags(3);
        public static final /* enum */ EnumPlayerTeleportFlags X_ROT = new EnumPlayerTeleportFlags(4);
        private final int bit;
        private static final /* synthetic */ EnumPlayerTeleportFlags[] g;

        public static EnumPlayerTeleportFlags[] values() {
            return (EnumPlayerTeleportFlags[])g.clone();
        }

        public static EnumPlayerTeleportFlags valueOf(String var0) {
            return Enum.valueOf(EnumPlayerTeleportFlags.class, var0);
        }

        private EnumPlayerTeleportFlags(int var2) {
            this.bit = var2;
        }

        private int getMask() {
            return 1 << this.bit;
        }

        private boolean isSet(int var0) {
            return (var0 & this.getMask()) == this.getMask();
        }

        public static Set<EnumPlayerTeleportFlags> unpack(int var0) {
            EnumSet<EnumPlayerTeleportFlags> var1 = EnumSet.noneOf(EnumPlayerTeleportFlags.class);
            for (EnumPlayerTeleportFlags var5 : EnumPlayerTeleportFlags.values()) {
                if (!var5.isSet(var0)) continue;
                var1.add(var5);
            }
            return var1;
        }

        public static int pack(Set<EnumPlayerTeleportFlags> var0) {
            int var1 = 0;
            for (EnumPlayerTeleportFlags var3 : var0) {
                var1 |= var3.getMask();
            }
            return var1;
        }

        private static /* synthetic */ EnumPlayerTeleportFlags[] b() {
            return new EnumPlayerTeleportFlags[]{X, Y, Z, Y_ROT, X_ROT};
        }

        static {
            g = EnumPlayerTeleportFlags.b();
        }
    }
}

