/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.EnumGamemode;

public class PacketPlayOutPlayerInfo
implements Packet<PacketListenerPlayOut> {
    private final EnumPlayerInfoAction action;
    private final List<PlayerInfoData> entries;

    public PacketPlayOutPlayerInfo(EnumPlayerInfoAction var0, EntityPlayer ... var1) {
        this.action = var0;
        this.entries = Lists.newArrayListWithCapacity((int)var1.length);
        for (EntityPlayer var5 : var1) {
            this.entries.add(new PlayerInfoData(var5.getGameProfile(), var5.latency, var5.gameMode.getGameModeForPlayer(), var5.getTabListDisplayName()));
        }
    }

    public PacketPlayOutPlayerInfo(EnumPlayerInfoAction var0, Collection<EntityPlayer> var1) {
        this.action = var0;
        this.entries = Lists.newArrayListWithCapacity((int)var1.size());
        for (EntityPlayer var3 : var1) {
            this.entries.add(new PlayerInfoData(var3.getGameProfile(), var3.latency, var3.gameMode.getGameModeForPlayer(), var3.getTabListDisplayName()));
        }
    }

    public PacketPlayOutPlayerInfo(PacketDataSerializer var0) {
        this.action = var0.readEnum(EnumPlayerInfoAction.class);
        this.entries = var0.readList(this.action::read);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeEnum(this.action);
        var0.writeCollection(this.entries, this.action::write);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handlePlayerInfo(this);
    }

    public List<PlayerInfoData> getEntries() {
        return this.entries;
    }

    public EnumPlayerInfoAction getAction() {
        return this.action;
    }

    @Nullable
    static IChatBaseComponent readDisplayName(PacketDataSerializer var0) {
        return var0.readBoolean() ? var0.readComponent() : null;
    }

    static void writeDisplayName(PacketDataSerializer var0, @Nullable IChatBaseComponent var1) {
        if (var1 == null) {
            var0.writeBoolean(false);
        } else {
            var0.writeBoolean(true);
            var0.writeComponent(var1);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("action", (Object)this.action).add("entries", this.entries).toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class EnumPlayerInfoAction
    extends Enum<EnumPlayerInfoAction> {
        public static final /* enum */ EnumPlayerInfoAction ADD_PLAYER = new EnumPlayerInfoAction(){

            @Override
            protected PlayerInfoData read(PacketDataSerializer var0) {
                GameProfile var12 = new GameProfile(var0.readUUID(), var0.readUtf(16));
                PropertyMap var2 = var12.getProperties();
                var0.readWithCount(var1 -> {
                    String var2 = var1.readUtf();
                    String var3 = var1.readUtf();
                    if (var1.readBoolean()) {
                        String var4 = var1.readUtf();
                        var2.put((Object)var2, (Object)new Property(var2, var3, var4));
                    } else {
                        var2.put((Object)var2, (Object)new Property(var2, var3));
                    }
                });
                EnumGamemode var3 = EnumGamemode.byId(var0.readVarInt());
                int var4 = var0.readVarInt();
                IChatBaseComponent var5 = PacketPlayOutPlayerInfo.readDisplayName(var0);
                return new PlayerInfoData(var12, var4, var3, var5);
            }

            @Override
            protected void write(PacketDataSerializer var02, PlayerInfoData var12) {
                var02.writeUUID(var12.getProfile().getId());
                var02.writeUtf(var12.getProfile().getName());
                var02.writeCollection(var12.getProfile().getProperties().values(), (var0, var1) -> {
                    var0.writeUtf(var1.getName());
                    var0.writeUtf(var1.getValue());
                    if (var1.hasSignature()) {
                        var0.writeBoolean(true);
                        var0.writeUtf(var1.getSignature());
                    } else {
                        var0.writeBoolean(false);
                    }
                });
                var02.writeVarInt(var12.getGameMode().getId());
                var02.writeVarInt(var12.getLatency());
                PacketPlayOutPlayerInfo.writeDisplayName(var02, var12.getDisplayName());
            }
        };
        public static final /* enum */ EnumPlayerInfoAction UPDATE_GAME_MODE = new EnumPlayerInfoAction(){

            @Override
            protected PlayerInfoData read(PacketDataSerializer var0) {
                GameProfile var1 = new GameProfile(var0.readUUID(), null);
                EnumGamemode var2 = EnumGamemode.byId(var0.readVarInt());
                return new PlayerInfoData(var1, 0, var2, null);
            }

            @Override
            protected void write(PacketDataSerializer var0, PlayerInfoData var1) {
                var0.writeUUID(var1.getProfile().getId());
                var0.writeVarInt(var1.getGameMode().getId());
            }
        };
        public static final /* enum */ EnumPlayerInfoAction UPDATE_LATENCY = new EnumPlayerInfoAction(){

            @Override
            protected PlayerInfoData read(PacketDataSerializer var0) {
                GameProfile var1 = new GameProfile(var0.readUUID(), null);
                int var2 = var0.readVarInt();
                return new PlayerInfoData(var1, var2, null, null);
            }

            @Override
            protected void write(PacketDataSerializer var0, PlayerInfoData var1) {
                var0.writeUUID(var1.getProfile().getId());
                var0.writeVarInt(var1.getLatency());
            }
        };
        public static final /* enum */ EnumPlayerInfoAction UPDATE_DISPLAY_NAME = new EnumPlayerInfoAction(){

            @Override
            protected PlayerInfoData read(PacketDataSerializer var0) {
                GameProfile var1 = new GameProfile(var0.readUUID(), null);
                IChatBaseComponent var2 = PacketPlayOutPlayerInfo.readDisplayName(var0);
                return new PlayerInfoData(var1, 0, null, var2);
            }

            @Override
            protected void write(PacketDataSerializer var0, PlayerInfoData var1) {
                var0.writeUUID(var1.getProfile().getId());
                PacketPlayOutPlayerInfo.writeDisplayName(var0, var1.getDisplayName());
            }
        };
        public static final /* enum */ EnumPlayerInfoAction REMOVE_PLAYER = new EnumPlayerInfoAction(){

            @Override
            protected PlayerInfoData read(PacketDataSerializer var0) {
                GameProfile var1 = new GameProfile(var0.readUUID(), null);
                return new PlayerInfoData(var1, 0, null, null);
            }

            @Override
            protected void write(PacketDataSerializer var0, PlayerInfoData var1) {
                var0.writeUUID(var1.getProfile().getId());
            }
        };
        private static final /* synthetic */ EnumPlayerInfoAction[] f;

        public static EnumPlayerInfoAction[] values() {
            return (EnumPlayerInfoAction[])f.clone();
        }

        public static EnumPlayerInfoAction valueOf(String var0) {
            return Enum.valueOf(EnumPlayerInfoAction.class, var0);
        }

        protected abstract PlayerInfoData read(PacketDataSerializer var1);

        protected abstract void write(PacketDataSerializer var1, PlayerInfoData var2);

        private static /* synthetic */ EnumPlayerInfoAction[] a() {
            return new EnumPlayerInfoAction[]{ADD_PLAYER, UPDATE_GAME_MODE, UPDATE_LATENCY, UPDATE_DISPLAY_NAME, REMOVE_PLAYER};
        }

        static {
            f = EnumPlayerInfoAction.a();
        }
    }

    public static class PlayerInfoData {
        private final int latency;
        private final EnumGamemode gameMode;
        private final GameProfile profile;
        @Nullable
        private final IChatBaseComponent displayName;

        public PlayerInfoData(GameProfile var0, int var1, @Nullable EnumGamemode var2, @Nullable IChatBaseComponent var3) {
            this.profile = var0;
            this.latency = var1;
            this.gameMode = var2;
            this.displayName = var3;
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public int getLatency() {
            return this.latency;
        }

        public EnumGamemode getGameMode() {
            return this.gameMode;
        }

        @Nullable
        public IChatBaseComponent getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("latency", this.latency).add("gameMode", (Object)this.gameMode).add("profile", (Object)this.profile).add("displayName", this.displayName == null ? null : IChatBaseComponent.ChatSerializer.toJson(this.displayName)).toString();
        }
    }
}

