/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;

public record PacketPlayOutLogin(int playerId, boolean hardcore, EnumGamemode gameType, @Nullable EnumGamemode previousGameType, Set<ResourceKey<World>> levels, IRegistryCustom.Dimension registryHolder, Holder<DimensionManager> dimensionType, ResourceKey<World> dimension, long seed, int maxPlayers, int chunkRadius, int simulationDistance, boolean reducedDebugInfo, boolean showDeathScreen, boolean isDebug, boolean isFlat) implements Packet<PacketListenerPlayOut>
{
    public PacketPlayOutLogin(PacketDataSerializer var02) {
        this(var02.readInt(), var02.readBoolean(), EnumGamemode.byId(var02.readByte()), EnumGamemode.byNullableId(var02.readByte()), var02.readCollection(Sets::newHashSetWithExpectedSize, var0 -> ResourceKey.create(IRegistry.DIMENSION_REGISTRY, var0.readResourceLocation())), var02.readWithCodec(IRegistryCustom.NETWORK_CODEC).freeze(), var02.readWithCodec(DimensionManager.CODEC), ResourceKey.create(IRegistry.DIMENSION_REGISTRY, var02.readResourceLocation()), var02.readLong(), var02.readVarInt(), var02.readVarInt(), var02.readVarInt(), var02.readBoolean(), var02.readBoolean(), var02.readBoolean(), var02.readBoolean());
    }

    @Override
    public void write(PacketDataSerializer var02) {
        var02.writeInt(this.playerId);
        var02.writeBoolean(this.hardcore);
        var02.writeByte(this.gameType.getId());
        var02.writeByte(EnumGamemode.getNullableId(this.previousGameType));
        var02.writeCollection(this.levels, (var0, var1) -> var0.writeResourceLocation(var1.location()));
        var02.writeWithCodec(IRegistryCustom.NETWORK_CODEC, this.registryHolder);
        var02.writeWithCodec(DimensionManager.CODEC, this.dimensionType);
        var02.writeResourceLocation(this.dimension.location());
        var02.writeLong(this.seed);
        var02.writeVarInt(this.maxPlayers);
        var02.writeVarInt(this.chunkRadius);
        var02.writeVarInt(this.simulationDistance);
        var02.writeBoolean(this.reducedDebugInfo);
        var02.writeBoolean(this.showDeathScreen);
        var02.writeBoolean(this.isDebug);
        var02.writeBoolean(this.isFlat);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleLogin(this);
    }
}

