/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;

public class PacketPlayOutEntityEffect
implements Packet<PacketListenerPlayOut> {
    private static final int FLAG_AMBIENT = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_SHOW_ICON = 4;
    private final int entityId;
    private final int effectId;
    private final byte effectAmplifier;
    private final int effectDurationTicks;
    private final byte flags;

    public PacketPlayOutEntityEffect(int var0, MobEffect var1) {
        this.entityId = var0;
        this.effectId = MobEffectList.getId(var1.getEffect());
        this.effectAmplifier = (byte)(var1.getAmplifier() & 0xFF);
        this.effectDurationTicks = var1.getDuration() > Short.MAX_VALUE ? Short.MAX_VALUE : var1.getDuration();
        byte var2 = 0;
        if (var1.isAmbient()) {
            var2 = (byte)(var2 | 1);
        }
        if (var1.isVisible()) {
            var2 = (byte)(var2 | 2);
        }
        if (var1.showIcon()) {
            var2 = (byte)(var2 | 4);
        }
        this.flags = var2;
    }

    public PacketPlayOutEntityEffect(PacketDataSerializer var0) {
        this.entityId = var0.readVarInt();
        this.effectId = var0.readVarInt();
        this.effectAmplifier = var0.readByte();
        this.effectDurationTicks = var0.readVarInt();
        this.flags = var0.readByte();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.entityId);
        var0.writeVarInt(this.effectId);
        var0.writeByte(this.effectAmplifier);
        var0.writeVarInt(this.effectDurationTicks);
        var0.writeByte(this.flags);
    }

    public boolean isSuperLongDuration() {
        return this.effectDurationTicks == Short.MAX_VALUE;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleUpdateMobEffect(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getEffectId() {
        return this.effectId;
    }

    public byte getEffectAmplifier() {
        return this.effectAmplifier;
    }

    public int getEffectDurationTicks() {
        return this.effectDurationTicks;
    }

    public boolean isEffectVisible() {
        return (this.flags & 2) == 2;
    }

    public boolean isEffectAmbient() {
        return (this.flags & 1) == 1;
    }

    public boolean effectShowsIcon() {
        return (this.flags & 4) == 4;
    }
}

