/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentRegistry;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class PacketPlayOutCommands
implements Packet<PacketListenerPlayOut> {
    private static final byte MASK_TYPE = 3;
    private static final byte FLAG_EXECUTABLE = 4;
    private static final byte FLAG_REDIRECT = 8;
    private static final byte FLAG_CUSTOM_SUGGESTIONS = 16;
    private static final byte TYPE_ROOT = 0;
    private static final byte TYPE_LITERAL = 1;
    private static final byte TYPE_ARGUMENT = 2;
    private final RootCommandNode<ICompletionProvider> root;

    public PacketPlayOutCommands(RootCommandNode<ICompletionProvider> var0) {
        this.root = var0;
    }

    public PacketPlayOutCommands(PacketDataSerializer var0) {
        List<a> var1 = var0.readList(PacketPlayOutCommands::readNode);
        PacketPlayOutCommands.resolveEntries(var1);
        int var2 = var0.readVarInt();
        this.root = (RootCommandNode)var1.get((int)var2).node;
    }

    @Override
    public void write(PacketDataSerializer var0) {
        Object2IntMap<CommandNode<ICompletionProvider>> var12 = PacketPlayOutCommands.enumerateNodes(this.root);
        List<CommandNode<ICompletionProvider>> var22 = PacketPlayOutCommands.getNodesInIdOrder(var12);
        var0.writeCollection(var22, (var1, var2) -> PacketPlayOutCommands.writeNode(var1, (CommandNode<ICompletionProvider>)var2, (Map<CommandNode<ICompletionProvider>, Integer>)var12));
        var0.writeVarInt(var12.get(this.root));
    }

    private static void resolveEntries(List<a> var0) {
        ArrayList var12 = Lists.newArrayList(var0);
        while (!var12.isEmpty()) {
            boolean var2 = var12.removeIf(var1 -> var1.build(var0));
            if (var2) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static Object2IntMap<CommandNode<ICompletionProvider>> enumerateNodes(RootCommandNode<ICompletionProvider> var0) {
        CommandNode var3;
        Object2IntOpenHashMap var1 = new Object2IntOpenHashMap();
        ArrayDeque var2 = Queues.newArrayDeque();
        var2.add(var0);
        while ((var3 = (CommandNode)var2.poll()) != null) {
            if (var1.containsKey((Object)var3)) continue;
            int var4 = var1.size();
            var1.put((Object)var3, var4);
            var2.addAll(var3.getChildren());
            if (var3.getRedirect() == null) continue;
            var2.add(var3.getRedirect());
        }
        return var1;
    }

    private static List<CommandNode<ICompletionProvider>> getNodesInIdOrder(Object2IntMap<CommandNode<ICompletionProvider>> var0) {
        ObjectArrayList var1 = new ObjectArrayList(var0.size());
        var1.size(var0.size());
        for (Object2IntMap.Entry var3 : Object2IntMaps.fastIterable(var0)) {
            var1.set(var3.getIntValue(), (Object)((CommandNode)var3.getKey()));
        }
        return var1;
    }

    private static a readNode(PacketDataSerializer var0) {
        byte var1 = var0.readByte();
        int[] var2 = var0.readVarIntArray();
        int var3 = (var1 & 8) != 0 ? var0.readVarInt() : 0;
        ArgumentBuilder<ICompletionProvider, ?> var4 = PacketPlayOutCommands.createBuilder(var0, var1);
        return new a(var4, var1, var3, var2);
    }

    @Nullable
    private static ArgumentBuilder<ICompletionProvider, ?> createBuilder(PacketDataSerializer var0, byte var1) {
        int var2 = var1 & 3;
        if (var2 == 2) {
            String var3 = var0.readUtf();
            ArgumentType<?> var4 = ArgumentRegistry.deserialize(var0);
            if (var4 == null) {
                return null;
            }
            RequiredArgumentBuilder var5 = RequiredArgumentBuilder.argument((String)var3, var4);
            if ((var1 & 0x10) != 0) {
                var5.suggests(CompletionProviders.getProvider(var0.readResourceLocation()));
            }
            return var5;
        }
        if (var2 == 1) {
            return LiteralArgumentBuilder.literal((String)var0.readUtf());
        }
        return null;
    }

    private static void writeNode(PacketDataSerializer var0, CommandNode<ICompletionProvider> var1, Map<CommandNode<ICompletionProvider>, Integer> var2) {
        int var3 = 0;
        if (var1.getRedirect() != null) {
            var3 = (byte)(var3 | 8);
        }
        if (var1.getCommand() != null) {
            var3 = (byte)(var3 | 4);
        }
        if (var1 instanceof RootCommandNode) {
            var3 = (byte)(var3 | 0);
        } else if (var1 instanceof ArgumentCommandNode) {
            var3 = (byte)(var3 | 2);
            if (((ArgumentCommandNode)var1).getCustomSuggestions() != null) {
                var3 = (byte)(var3 | 0x10);
            }
        } else if (var1 instanceof LiteralCommandNode) {
            var3 = (byte)(var3 | 1);
        } else {
            throw new UnsupportedOperationException("Unknown node type " + var1);
        }
        var0.writeByte(var3);
        var0.writeVarInt(var1.getChildren().size());
        for (CommandNode var5 : var1.getChildren()) {
            var0.writeVarInt(var2.get(var5));
        }
        if (var1.getRedirect() != null) {
            var0.writeVarInt(var2.get(var1.getRedirect()));
        }
        if (var1 instanceof ArgumentCommandNode) {
            ArgumentCommandNode var4 = (ArgumentCommandNode)var1;
            var0.writeUtf(var4.getName());
            ArgumentRegistry.serialize(var0, var4.getType());
            if (var4.getCustomSuggestions() != null) {
                var0.writeResourceLocation(CompletionProviders.getName((SuggestionProvider<ICompletionProvider>)var4.getCustomSuggestions()));
            }
        } else if (var1 instanceof LiteralCommandNode) {
            var0.writeUtf(((LiteralCommandNode)var1).getLiteral());
        }
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleCommands(this);
    }

    public RootCommandNode<ICompletionProvider> getRoot() {
        return this.root;
    }

    static class a {
        @Nullable
        private final ArgumentBuilder<ICompletionProvider, ?> builder;
        private final byte flags;
        private final int redirect;
        private final int[] children;
        @Nullable
        CommandNode<ICompletionProvider> node;

        a(@Nullable ArgumentBuilder<ICompletionProvider, ?> var0, byte var1, int var2, int[] var3) {
            this.builder = var0;
            this.flags = var1;
            this.redirect = var2;
            this.children = var3;
        }

        public boolean build(List<a> var02) {
            if (this.node == null) {
                if (this.builder == null) {
                    this.node = new RootCommandNode();
                } else {
                    if ((this.flags & 8) != 0) {
                        if (var02.get((int)this.redirect).node == null) {
                            return false;
                        }
                        this.builder.redirect(var02.get((int)this.redirect).node);
                    }
                    if ((this.flags & 4) != 0) {
                        this.builder.executes(var0 -> 0);
                    }
                    this.node = this.builder.build();
                }
            }
            for (int var4 : this.children) {
                if (var02.get((int)var4).node != null) continue;
                return false;
            }
            for (int var4 : this.children) {
                CommandNode<ICompletionProvider> var5 = var02.get((int)var4).node;
                if (var5 instanceof RootCommandNode) continue;
                this.node.addChild(var5);
            }
            return true;
        }
    }
}

