/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.ChatComponentKeybind;
import net.minecraft.network.chat.ChatComponentNBT;
import net.minecraft.network.chat.ChatComponentScore;
import net.minecraft.network.chat.ChatComponentSelector;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.ChatTypeAdapterFactory;
import net.minecraft.util.FormattedString;

public interface IChatBaseComponent
extends Message,
IChatFormatted {
    public ChatModifier getStyle();

    public String getContents();

    @Override
    default public String getString() {
        return IChatFormatted.super.getString();
    }

    default public String getString(int var0) {
        StringBuilder var1 = new StringBuilder();
        this.visit(var2 -> {
            int var3 = var0 - var1.length();
            if (var3 <= 0) {
                return STOP_ITERATION;
            }
            var1.append(var2.length() <= var3 ? var2 : var2.substring(0, var3));
            return Optional.empty();
        });
        return var1.toString();
    }

    public List<IChatBaseComponent> getSiblings();

    public IChatMutableComponent plainCopy();

    public IChatMutableComponent copy();

    public FormattedString getVisualOrderText();

    @Override
    default public <T> Optional<T> visit(IChatFormatted.b<T> var0, ChatModifier var1) {
        ChatModifier var2 = this.getStyle().applyTo(var1);
        Optional<T> var3 = this.visitSelf(var0, var2);
        if (var3.isPresent()) {
            return var3;
        }
        for (IChatBaseComponent var5 : this.getSiblings()) {
            Optional<T> var6 = var5.visit(var0, var2);
            if (!var6.isPresent()) continue;
            return var6;
        }
        return Optional.empty();
    }

    @Override
    default public <T> Optional<T> visit(IChatFormatted.a<T> var0) {
        Optional<T> var1 = this.visitSelf(var0);
        if (var1.isPresent()) {
            return var1;
        }
        for (IChatBaseComponent var3 : this.getSiblings()) {
            Optional<T> var4 = var3.visit(var0);
            if (!var4.isPresent()) continue;
            return var4;
        }
        return Optional.empty();
    }

    default public <T> Optional<T> visitSelf(IChatFormatted.b<T> var0, ChatModifier var1) {
        return var0.accept(var1, this.getContents());
    }

    default public <T> Optional<T> visitSelf(IChatFormatted.a<T> var0) {
        return var0.accept(this.getContents());
    }

    default public List<IChatBaseComponent> toFlatList(ChatModifier var0) {
        ArrayList var12 = Lists.newArrayList();
        this.visit((var1, var2) -> {
            if (!var2.isEmpty()) {
                var12.add(new ChatComponentText(var2).withStyle(var1));
            }
            return Optional.empty();
        }, var0);
        return var12;
    }

    public static IChatBaseComponent nullToEmpty(@Nullable String var0) {
        return var0 != null ? new ChatComponentText(var0) : ChatComponentText.EMPTY;
    }

    public static class ChatSerializer
    implements JsonDeserializer<IChatMutableComponent>,
    JsonSerializer<IChatBaseComponent> {
        private static final Gson GSON = SystemUtils.make(() -> {
            GsonBuilder var0 = new GsonBuilder();
            var0.disableHtmlEscaping();
            var0.registerTypeHierarchyAdapter(IChatBaseComponent.class, (Object)new ChatSerializer());
            var0.registerTypeHierarchyAdapter(ChatModifier.class, (Object)new ChatModifier.ChatModifierSerializer());
            var0.registerTypeAdapterFactory((TypeAdapterFactory)new ChatTypeAdapterFactory());
            return var0.create();
        });
        private static final Field JSON_READER_POS = SystemUtils.make(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field var0 = JsonReader.class.getDeclaredField("pos");
                var0.setAccessible(true);
                return var0;
            }
            catch (NoSuchFieldException var0) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", var0);
            }
        });
        private static final Field JSON_READER_LINESTART = SystemUtils.make(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field var0 = JsonReader.class.getDeclaredField("lineStart");
                var0.setAccessible(true);
                return var0;
            }
            catch (NoSuchFieldException var0) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", var0);
            }
        });

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IChatMutableComponent deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
            void var5_19;
            if (var0.isJsonPrimitive()) {
                return new ChatComponentText(var0.getAsString());
            }
            if (var0.isJsonObject()) {
                void var5_17;
                Object var5;
                JsonObject var3 = var0.getAsJsonObject();
                if (var3.has("text")) {
                    ChatComponentText chatComponentText = new ChatComponentText(ChatDeserializer.getAsString(var3, "text"));
                } else if (var3.has("translate")) {
                    var5 = ChatDeserializer.getAsString(var3, "translate");
                    if (var3.has("with")) {
                        JsonArray jsonArray = ChatDeserializer.getAsJsonArray(var3, "with");
                        Object[] var7 = new Object[jsonArray.size()];
                        for (int var8 = 0; var8 < var7.length; ++var8) {
                            ChatComponentText var9;
                            var7[var8] = this.deserialize(jsonArray.get(var8), var1, var2);
                            if (!(var7[var8] instanceof ChatComponentText) || !(var9 = (ChatComponentText)var7[var8]).getStyle().isEmpty() || !var9.getSiblings().isEmpty()) continue;
                            var7[var8] = var9.getText();
                        }
                        ChatMessage chatMessage = new ChatMessage((String)var5, var7);
                    } else {
                        ChatMessage chatMessage = new ChatMessage((String)var5);
                    }
                } else if (var3.has("score")) {
                    var5 = ChatDeserializer.getAsJsonObject(var3, "score");
                    if (!var5.has("name") || !var5.has("objective")) throw new JsonParseException("A score component needs a least a name and an objective");
                    ChatComponentScore chatComponentScore = new ChatComponentScore(ChatDeserializer.getAsString((JsonObject)var5, "name"), ChatDeserializer.getAsString((JsonObject)var5, "objective"));
                } else if (var3.has("selector")) {
                    var5 = this.parseSeparator(var1, var2, var3);
                    ChatComponentSelector chatComponentSelector = new ChatComponentSelector(ChatDeserializer.getAsString(var3, "selector"), (Optional<IChatBaseComponent>)var5);
                } else if (var3.has("keybind")) {
                    ChatComponentKeybind chatComponentKeybind = new ChatComponentKeybind(ChatDeserializer.getAsString(var3, "keybind"));
                } else {
                    if (!var3.has("nbt")) throw new JsonParseException("Don't know how to turn " + var0 + " into a Component");
                    var5 = ChatDeserializer.getAsString(var3, "nbt");
                    Optional<IChatBaseComponent> optional = this.parseSeparator(var1, var2, var3);
                    boolean var7 = ChatDeserializer.getAsBoolean(var3, "interpret", false);
                    if (var3.has("block")) {
                        ChatComponentNBT.a a2 = new ChatComponentNBT.a((String)var5, var7, ChatDeserializer.getAsString(var3, "block"), optional);
                    } else if (var3.has("entity")) {
                        ChatComponentNBT.b b2 = new ChatComponentNBT.b((String)var5, var7, ChatDeserializer.getAsString(var3, "entity"), optional);
                    } else {
                        if (!var3.has("storage")) throw new JsonParseException("Don't know how to turn " + var0 + " into a Component");
                        ChatComponentNBT.c c2 = new ChatComponentNBT.c((String)var5, var7, new MinecraftKey(ChatDeserializer.getAsString(var3, "storage")), optional);
                    }
                }
                if (var3.has("extra")) {
                    void var7_27;
                    var5 = ChatDeserializer.getAsJsonArray(var3, "extra");
                    if (var5.size() <= 0) throw new JsonParseException("Unexpected empty array of components");
                    boolean bl = false;
                    while (var7_27 < var5.size()) {
                        var5_17.append(this.deserialize(var5.get((int)var7_27), var1, var2));
                        ++var7_27;
                    }
                }
                var5_17.setStyle((ChatModifier)var2.deserialize(var0, ChatModifier.class));
                return var5_17;
            }
            if (!var0.isJsonArray()) throw new JsonParseException("Don't know how to turn " + var0 + " into a Component");
            JsonArray var3 = var0.getAsJsonArray();
            Object var5_18 = null;
            for (JsonElement jsonElement : var3) {
                IChatMutableComponent var7 = this.deserialize(jsonElement, jsonElement.getClass(), var2);
                if (var5_19 == null) {
                    IChatMutableComponent iChatMutableComponent = var7;
                    continue;
                }
                var5_19.append(var7);
            }
            return var5_19;
        }

        private Optional<IChatBaseComponent> parseSeparator(Type var0, JsonDeserializationContext var1, JsonObject var2) {
            if (var2.has("separator")) {
                return Optional.of(this.deserialize(var2.get("separator"), var0, var1));
            }
            return Optional.empty();
        }

        private void serializeStyle(ChatModifier var0, JsonObject var1, JsonSerializationContext var2) {
            JsonElement var3 = var2.serialize((Object)var0);
            if (var3.isJsonObject()) {
                JsonObject var4 = (JsonObject)var3;
                for (Map.Entry var6 : var4.entrySet()) {
                    var1.add((String)var6.getKey(), (JsonElement)var6.getValue());
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public JsonElement serialize(IChatBaseComponent var0, Type var1, JsonSerializationContext var2) {
            Object var4;
            JsonObject var3 = new JsonObject();
            if (!var0.getStyle().isEmpty()) {
                this.serializeStyle(var0.getStyle(), var3, var2);
            }
            if (!var0.getSiblings().isEmpty()) {
                var4 = new JsonArray();
                for (IChatBaseComponent var6 : var0.getSiblings()) {
                    var4.add(this.serialize(var6, var6.getClass(), var2));
                }
                var3.add("extra", (JsonElement)var4);
            }
            if (var0 instanceof ChatComponentText) {
                var3.addProperty("text", ((ChatComponentText)var0).getText());
                return var3;
            } else if (var0 instanceof ChatMessage) {
                var4 = (ChatMessage)var0;
                var3.addProperty("translate", ((ChatMessage)var4).getKey());
                if (((ChatMessage)var4).getArgs() == null || ((ChatMessage)var4).getArgs().length <= 0) return var3;
                var5 = new JsonArray();
                for (Object var9 : ((ChatMessage)var4).getArgs()) {
                    if (var9 instanceof IChatBaseComponent) {
                        var5.add(this.serialize((IChatBaseComponent)var9, var9.getClass(), var2));
                        continue;
                    }
                    var5.add((JsonElement)new JsonPrimitive(String.valueOf(var9)));
                }
                var3.add("with", (JsonElement)var5);
                return var3;
            } else if (var0 instanceof ChatComponentScore) {
                var4 = (ChatComponentScore)var0;
                var5 = new JsonObject();
                var5.addProperty("name", ((ChatComponentScore)var4).getName());
                var5.addProperty("objective", ((ChatComponentScore)var4).getObjective());
                var3.add("score", (JsonElement)var5);
                return var3;
            } else if (var0 instanceof ChatComponentSelector) {
                var4 = (ChatComponentSelector)var0;
                var3.addProperty("selector", ((ChatComponentSelector)var4).getPattern());
                this.serializeSeparator(var2, var3, ((ChatComponentSelector)var4).getSeparator());
                return var3;
            } else if (var0 instanceof ChatComponentKeybind) {
                var4 = (ChatComponentKeybind)var0;
                var3.addProperty("keybind", ((ChatComponentKeybind)var4).getName());
                return var3;
            } else {
                if (!(var0 instanceof ChatComponentNBT)) throw new IllegalArgumentException("Don't know how to serialize " + var0 + " as a Component");
                var4 = (ChatComponentNBT)var0;
                var3.addProperty("nbt", ((ChatComponentNBT)var4).getNbtPath());
                var3.addProperty("interpret", Boolean.valueOf(((ChatComponentNBT)var4).isInterpreting()));
                this.serializeSeparator(var2, var3, ((ChatComponentNBT)var4).separator);
                if (var0 instanceof ChatComponentNBT.a) {
                    var5 = (ChatComponentNBT.a)var0;
                    var3.addProperty("block", ((ChatComponentNBT.a)var5).getPos());
                    return var3;
                } else if (var0 instanceof ChatComponentNBT.b) {
                    var5 = (ChatComponentNBT.b)var0;
                    var3.addProperty("entity", ((ChatComponentNBT.b)var5).getSelector());
                    return var3;
                } else {
                    if (!(var0 instanceof ChatComponentNBT.c)) throw new IllegalArgumentException("Don't know how to serialize " + var0 + " as a Component");
                    var5 = (ChatComponentNBT.c)var0;
                    var3.addProperty("storage", ((ChatComponentNBT.c)var5).getId().toString());
                }
            }
            return var3;
        }

        private void serializeSeparator(JsonSerializationContext var0, JsonObject var1, Optional<IChatBaseComponent> var22) {
            var22.ifPresent(var2 -> var1.add("separator", this.serialize((IChatBaseComponent)var2, (Type)var2.getClass(), var0)));
        }

        public static String toJson(IChatBaseComponent var0) {
            return GSON.toJson((Object)var0);
        }

        public static JsonElement toJsonTree(IChatBaseComponent var0) {
            return GSON.toJsonTree((Object)var0);
        }

        @Nullable
        public static IChatMutableComponent fromJson(String var0) {
            return ChatDeserializer.fromJson(GSON, var0, IChatMutableComponent.class, false);
        }

        @Nullable
        public static IChatMutableComponent fromJson(JsonElement var0) {
            return (IChatMutableComponent)GSON.fromJson(var0, IChatMutableComponent.class);
        }

        @Nullable
        public static IChatMutableComponent fromJsonLenient(String var0) {
            return ChatDeserializer.fromJson(GSON, var0, IChatMutableComponent.class, true);
        }

        public static IChatMutableComponent fromJson(com.mojang.brigadier.StringReader var0) {
            try {
                JsonReader var1 = new JsonReader((Reader)new StringReader(var0.getRemaining()));
                var1.setLenient(false);
                IChatMutableComponent var2 = (IChatMutableComponent)GSON.getAdapter(IChatMutableComponent.class).read(var1);
                var0.setCursor(var0.getCursor() + ChatSerializer.getPos(var1));
                return var2;
            }
            catch (IOException | StackOverflowError var1) {
                throw new JsonParseException(var1);
            }
        }

        private static int getPos(JsonReader var0) {
            try {
                return JSON_READER_POS.getInt(var0) - JSON_READER_LINESTART.getInt(var0) + 1;
            }
            catch (IllegalAccessException var1) {
                throw new IllegalStateException("Couldn't read position of JsonReader", var1);
            }
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((IChatBaseComponent)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

