/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatBaseComponent;
import net.minecraft.network.chat.ChatComponentContextual;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.TileEntity;
import org.slf4j.Logger;

public abstract class ChatComponentNBT
extends ChatBaseComponent
implements ChatComponentContextual {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final boolean interpreting;
    protected final Optional<IChatBaseComponent> separator;
    protected final String nbtPathPattern;
    @Nullable
    protected final ArgumentNBTKey.g compiledNbtPath;

    @Nullable
    private static ArgumentNBTKey.g compileNbtPath(String var0) {
        try {
            return new ArgumentNBTKey().parse(new StringReader(var0));
        }
        catch (CommandSyntaxException var1) {
            return null;
        }
    }

    public ChatComponentNBT(String var0, boolean var1, Optional<IChatBaseComponent> var2) {
        this(var0, ChatComponentNBT.compileNbtPath(var0), var1, var2);
    }

    protected ChatComponentNBT(String var0, @Nullable ArgumentNBTKey.g var1, boolean var2, Optional<IChatBaseComponent> var3) {
        this.nbtPathPattern = var0;
        this.compiledNbtPath = var1;
        this.interpreting = var2;
        this.separator = var3;
    }

    protected abstract Stream<NBTTagCompound> getData(CommandListenerWrapper var1) throws CommandSyntaxException;

    public String getNbtPath() {
        return this.nbtPathPattern;
    }

    public boolean isInterpreting() {
        return this.interpreting;
    }

    @Override
    public IChatMutableComponent resolve(@Nullable CommandListenerWrapper var02, @Nullable Entity var13, int var22) throws CommandSyntaxException {
        if (var02 == null || this.compiledNbtPath == null) {
            return new ChatComponentText("");
        }
        Stream<String> var32 = this.getData(var02).flatMap(var0 -> {
            try {
                return this.compiledNbtPath.get((NBTBase)var0).stream();
            }
            catch (CommandSyntaxException var1) {
                return Stream.empty();
            }
        }).map(NBTBase::getAsString);
        if (this.interpreting) {
            IChatBaseComponent var4 = (IChatBaseComponent)DataFixUtils.orElse(ChatComponentUtils.updateForEntity(var02, this.separator, var13, var22), (Object)ChatComponentUtils.DEFAULT_NO_STYLE_SEPARATOR);
            return var32.flatMap(var3 -> {
                try {
                    IChatMutableComponent var4 = IChatBaseComponent.ChatSerializer.fromJson(var3);
                    return Stream.of(ChatComponentUtils.updateForEntity(var02, var4, var13, var22));
                }
                catch (Exception var4) {
                    LOGGER.warn("Failed to parse component: {}", var3, (Object)var4);
                    return Stream.of(new IChatMutableComponent[0]);
                }
            }).reduce((var1, var2) -> var1.append(var4).append((IChatBaseComponent)var2)).orElseGet(() -> new ChatComponentText(""));
        }
        return ChatComponentUtils.updateForEntity(var02, this.separator, var13, var22).map(var12 -> var32.map(var0 -> new ChatComponentText((String)var0)).reduce((var1, var2) -> var1.append((IChatBaseComponent)var12).append((IChatBaseComponent)var2)).orElseGet(() -> new ChatComponentText(""))).orElseGet(() -> new ChatComponentText(var32.collect(Collectors.joining(", "))));
    }

    public static class c
    extends ChatComponentNBT {
        private final MinecraftKey id;

        public c(String var0, boolean var1, MinecraftKey var2, Optional<IChatBaseComponent> var3) {
            super(var0, var1, var3);
            this.id = var2;
        }

        public c(String var0, @Nullable ArgumentNBTKey.g var1, boolean var2, MinecraftKey var3, Optional<IChatBaseComponent> var4) {
            super(var0, var1, var2, var4);
            this.id = var3;
        }

        public MinecraftKey getId() {
            return this.id;
        }

        @Override
        public c plainCopy() {
            return new c(this.nbtPathPattern, this.compiledNbtPath, this.interpreting, this.id, this.separator);
        }

        @Override
        protected Stream<NBTTagCompound> getData(CommandListenerWrapper var0) {
            NBTTagCompound var1 = var0.getServer().getCommandStorage().get(this.id);
            return Stream.of(var1);
        }

        @Override
        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 instanceof c) {
                c var1 = (c)var0;
                return Objects.equals(this.id, var1.id) && Objects.equals(this.nbtPathPattern, var1.nbtPathPattern) && super.equals(var0);
            }
            return false;
        }

        @Override
        public String toString() {
            return "StorageNbtComponent{id='" + this.id + "'path='" + this.nbtPathPattern + "', siblings=" + this.siblings + ", style=" + this.getStyle() + "}";
        }

        @Override
        public /* synthetic */ ChatBaseComponent plainCopy() {
            return this.plainCopy();
        }

        @Override
        public /* synthetic */ IChatMutableComponent plainCopy() {
            return this.plainCopy();
        }
    }

    public static class a
    extends ChatComponentNBT {
        private final String posPattern;
        @Nullable
        private final IVectorPosition compiledPos;

        public a(String var0, boolean var1, String var2, Optional<IChatBaseComponent> var3) {
            super(var0, var1, var3);
            this.posPattern = var2;
            this.compiledPos = this.compilePos(this.posPattern);
        }

        @Nullable
        private IVectorPosition compilePos(String var0) {
            try {
                return ArgumentPosition.blockPos().parse(new StringReader(var0));
            }
            catch (CommandSyntaxException var1) {
                return null;
            }
        }

        private a(String var0, @Nullable ArgumentNBTKey.g var1, boolean var2, String var3, @Nullable IVectorPosition var4, Optional<IChatBaseComponent> var5) {
            super(var0, var1, var2, var5);
            this.posPattern = var3;
            this.compiledPos = var4;
        }

        @Nullable
        public String getPos() {
            return this.posPattern;
        }

        @Override
        public a plainCopy() {
            return new a(this.nbtPathPattern, this.compiledNbtPath, this.interpreting, this.posPattern, this.compiledPos, this.separator);
        }

        @Override
        protected Stream<NBTTagCompound> getData(CommandListenerWrapper var0) {
            TileEntity var3;
            BlockPosition var2;
            WorldServer var1;
            if (this.compiledPos != null && (var1 = var0.getLevel()).isLoaded(var2 = this.compiledPos.getBlockPos(var0)) && (var3 = var1.getBlockEntity(var2)) != null) {
                return Stream.of(var3.saveWithFullMetadata());
            }
            return Stream.empty();
        }

        @Override
        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 instanceof a) {
                a var1 = (a)var0;
                return Objects.equals(this.posPattern, var1.posPattern) && Objects.equals(this.nbtPathPattern, var1.nbtPathPattern) && super.equals(var0);
            }
            return false;
        }

        @Override
        public String toString() {
            return "BlockPosArgument{pos='" + this.posPattern + "'path='" + this.nbtPathPattern + "', siblings=" + this.siblings + ", style=" + this.getStyle() + "}";
        }

        @Override
        public /* synthetic */ ChatBaseComponent plainCopy() {
            return this.plainCopy();
        }

        @Override
        public /* synthetic */ IChatMutableComponent plainCopy() {
            return this.plainCopy();
        }
    }

    public static class b
    extends ChatComponentNBT {
        private final String selectorPattern;
        @Nullable
        private final EntitySelector compiledSelector;

        public b(String var0, boolean var1, String var2, Optional<IChatBaseComponent> var3) {
            super(var0, var1, var3);
            this.selectorPattern = var2;
            this.compiledSelector = b.compileSelector(var2);
        }

        @Nullable
        private static EntitySelector compileSelector(String var0) {
            try {
                ArgumentParserSelector var1 = new ArgumentParserSelector(new StringReader(var0));
                return var1.parse();
            }
            catch (CommandSyntaxException var1) {
                return null;
            }
        }

        private b(String var0, @Nullable ArgumentNBTKey.g var1, boolean var2, String var3, @Nullable EntitySelector var4, Optional<IChatBaseComponent> var5) {
            super(var0, var1, var2, var5);
            this.selectorPattern = var3;
            this.compiledSelector = var4;
        }

        public String getSelector() {
            return this.selectorPattern;
        }

        @Override
        public b plainCopy() {
            return new b(this.nbtPathPattern, this.compiledNbtPath, this.interpreting, this.selectorPattern, this.compiledSelector, this.separator);
        }

        @Override
        protected Stream<NBTTagCompound> getData(CommandListenerWrapper var0) throws CommandSyntaxException {
            if (this.compiledSelector != null) {
                List<? extends Entity> var1 = this.compiledSelector.findEntities(var0);
                return var1.stream().map(CriterionConditionNBT::getEntityTagToCompare);
            }
            return Stream.empty();
        }

        @Override
        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 instanceof b) {
                b var1 = (b)var0;
                return Objects.equals(this.selectorPattern, var1.selectorPattern) && Objects.equals(this.nbtPathPattern, var1.nbtPathPattern) && super.equals(var0);
            }
            return false;
        }

        @Override
        public String toString() {
            return "EntityNbtComponent{selector='" + this.selectorPattern + "'path='" + this.nbtPathPattern + "', siblings=" + this.siblings + ", style=" + this.getStyle() + "}";
        }

        @Override
        public /* synthetic */ ChatBaseComponent plainCopy() {
            return this.plainCopy();
        }

        @Override
        public /* synthetic */ IChatMutableComponent plainCopy() {
            return this.plainCopy();
        }
    }
}

